<?php
/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2010 Coppermine Dev Team
  v1.0 originally written by Gregory Demar

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 3
  as published by the Free Software Foundation.

  ********************************************
  Coppermine version: 1.5.10
  $HeadURL: https://coppermine.svn.sourceforge.net/svnroot/coppermine/trunk/cpg1.5.x/include/themes.inc.php $
  $Revision: 8107 $
  $LastChangedBy$: DaMysterious
  $Date$: 06-12-2010
**********************************************/

/////////////////////////////////////////////////////////////////
//                                                             //
// Do not edit this file.                                      //
// If you need to customize your theme,                        //
// edit themes/yourtheme/theme.php instead !!!                 //
// Take a look at the sample theme (themes/sample/theme.php)   //
// to get an idea what to copy into your custom theme.         //
// Really, don't edit this file! We mean it!                   //
//                                                             //
/////////////////////////////////////////////////////////////////

// ----------------------------------------------------------------------------- //
// All lines that should NOT be IN themes/sample/theme.php             //{THEMES}//
// should end in "//{THEMES}" so that they can be easily stripped      //{THEMES}//
// The individual sections are marked accordingly with                       //
      /***********************************
      ** Section <<<SECTIONNAME>>> - START
      ***********************************/
      // actual code here
      /***********************************
      ** Section <<<SECTIONNAME>>> - END
      ***********************************/
// ----------------------------------------------------------------------------- //

if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}         //{THEMES}//

// The following terms can be defined in theme.php
// ('THEME_HAS_RATING_GRAPHICS', 1) : The location for the ratings graphics will
//    be directed to the themes images folder.
//('THEME_HAS_NAVBAR_GRAPHICS', 1); : The location for the navbar graphics will
//    be directed to the themes images folder.
//    Back to thumbnails   : images/navbar/thumbnails.png
//    Picture Information  : images/navbar/info.png
//    Slideshow            : images/navbar/slideshow.png
//    Report to admin      : images/navbar/report.png
//    Ecard                : images/navbar/ecard.png
//    Previous             : images/navbar/prev.png
//    Next                 : images/navbar/next.png
// ('THEME_HAS_FILM_STRIP_GRAPHIC', 1) : The location for the film strip graphics will
//    be directed to the themes images folder.
//    tile                 : images/tile.gif
// ('THEME_HAS_FILM_STRIP_GRAPHICS', 1) : The location for the film strip graphics will
//    be directed to the themes images folder.
//    tile on the top      : images/tile1.gif
//    tile on the bottom   : images/tile2.gif
//  ('THEME_HAS_NO_SYS_MENU_BUTTONS', 1) : When present the system won't attempt to replace {BUTTONS} in the SYS_MENU template
//    The entire block needs to be present like in Coppermine 1.3 themes
//  ('THEME_HAS_NO_SUB_MENU_BUTTONS', 1) When present the system won't attempt to replace {BUTTONS} in the SUB_MENU template
//    The entire block needs to be present like in Coppermine 1.3 themes

define('THEME_HAS_PROGRESS_GRAPHICS', 1);
define('THEME_HAS_FILM_STRIP_GRAPHIC', 1); 

// These parameters overide what the user inputs in the Configuration setup to prevent the theme from breaking.
$CONFIG['max_film_strip_items'] = 3; //overrides the number of thumbnails.
$CONFIG['thumbcols'] = 4; //overrides the number of columns for thumbnails.
$CONFIG['main_table_width'] = '100%'; //overrides the Width of the main table (pixels or %).
$CONFIG['picture_table_width'] = '100%'; //overrides the Width of the table for file display (pixels or %).
$CONFIG['album_list_cols'] = 2; // sets "Number of columns for the album list = 2"
$CONFIG['first_level'] = 1; //sets "Show first level album thumbnails in categories = no".

// HTML template for template sys_menu spacer
$template_sys_menu_spacer ="&raquo;";

if (!isset($template_sub_menu)) { //{THEMES}
/******************************************************************************
** Section <<<$template_sub_menu>>> - START
******************************************************************************/
// HTML template for sub_menu
$template_sys_menu_button = $template_sub_menu_button = <<<EOT
<!-- BEGIN {BLOCK_ID} -->
    <li>
        <a href="{HREF_TGT}" title="{HREF_TITLE}" class="firstlevel"><span class="firstlevel">{HREF_LNK}</span></a>
    </li>
<!-- END {BLOCK_ID} -->
EOT;
/******************************************************************************
** Section <<<$template_sub_menu>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_sys_menu)) { //{THEMES}
/******************************************************************************
** Section <<<$template_sys_menu>>> - START
******************************************************************************/
$template_sys_menu = <<<EOT
<ul class="dropmenu">
<!-- BEGIN home -->
                <li>
                    <a href="{HOME_TGT}" title="{HOME_TITLE}" class="firstlevel"><span class="firstlevel">{HOME_ICO}{HOME_LNK}</span></a>
                    <ul>
                    <!-- BEGIN contact -->
                                <li>
                                    <a href="{CONTACT_TGT}" title="{CONTACT_TITLE}"><span>{CONTACT_ICO}{CONTACT_LNK}</span></a>
                                </li>
                    <!-- END contact --> 
                    <!-- BEGIN sidebar -->
                                    <li>
                                        <a href="{SIDEBAR_TGT}" title="{SIDEBAR_TITLE}"><span>{SIDEBAR_ICO}{SIDEBAR_LNK}</span></a>
                                    </li>
                    <!-- END sidebar -->
                    <!-- BEGIN my_profile -->
                                    <li>
                                        <a href="{MY_PROF_TGT}" title="{MY_PROF_LNK}"><span>{MY_PROF_ICO}{MY_PROF_LNK}</span></a>
                                    </li>
                    <!-- END my_profile -->
                    </ul>
                </li>
<!-- BEGIN allow_memberlist -->
                                    <!--
                                    <li>
                                        <a href="{MEMBERLIST_TGT}" title="{MEMBERLIST_TITLE}"><span>{MEMBERLIST_ICO}{MEMBERLIST_LNK}</span></a>
                                    </li>
                                    -->
<!-- END allow_memberlist -->

<!-- END home -->
<!-- BEGIN my_gallery -->
                <li>
                    <a href="{MY_GAL_TGT}" title="{MY_GAL_TITLE}" class="firstlevel"><span class="firstlevel">{MY_GAL_ICO}{MY_GAL_LNK}</span></a>
                    <ul>
                    <!-- BEGIN allow_memberlist -->
                                    <li>
                                        <a href="{MEMBERLIST_TGT}" title="{MEMBERLIST_TITLE}"><span>{MEMBERLIST_ICO}{MEMBERLIST_LNK}</span></a>
                                    </li>
                    <!-- END allow_memberlist -->
                    <!-- BEGIN enter_admin_mode -->
                                    <li>
                                    <a href="{ADM_MODE_TGT}" title="{ADM_MODE_TITLE}"><span>{ADM_MODE_ICO}{ADM_MODE_LNK}</span></a>
                                    </li>
                    <!-- END enter_admin_mode -->
                    <!-- BEGIN leave_admin_mode -->
                                    <li>
                                        <a href="{USR_MODE_TGT}" title="{USR_MODE_TITLE}"><span>{USR_MODE_ICO}{USR_MODE_LNK}</span></a>
                                    </li>
                    <!-- END leave_admin_mode -->
                    </ul>
                </li>
<!-- END my_gallery -->
<!-- BEGIN upload_pic -->
                <li>
                    <a href="{UPL_PIC_TGT}" title="{UPL_PIC_TITLE}" class="firstlevel"><span class="firstlevel">{UPL_PIC_ICO}{UPL_PIC_LNK}</span></a>
                </li>
<!-- END upload_pic -->
<!-- BEGIN register -->
                <li>
                    <a href="{REGISTER_TGT}" title="{REGISTER_TITLE}" class="firstlevel"><span class="firstlevel">{REGISTER_ICO}{REGISTER_LNK}</span></a>
                </li>
<!-- END register -->
<!-- BEGIN login -->
                <li>
                    <a href="{LOGIN_TGT}" title="{LOGIN_LNK}" class="firstlevel"><span class="firstlevel">{LOGIN_ICO}{LOGIN_LNK}</span></a>
                </li>
<!-- END login -->
<!-- BEGIN logout -->
                <li>
                    <a href="{LOGOUT_TGT}" title="{LOGOUT_LNK}" class="firstlevel"><span class="firstlevel">{LOGOUT_ICO}{LOGOUT_LNK}</span></a>
                </li>
<!-- END logout -->
</ul>

EOT;


// HTML template for sub menu
if ($CONFIG['browse_by_date'] != 0) {
    $browsebydatebutton = <<< EOT
                        <li>
                            <a href="{BROWSEBYDATE_TGT}" title="{BROWSEBYDATE_TITLE}" rel="nofollow" class="greybox"><span>{BROWSEBYDATE_ICO}{BROWSEBYDATE_LNK}</span></a>
                        </li>
EOT;
} else {
    $browsebydatebutton = '';
}
$template_sub_menu = <<<EOT

<ul class="dropmenu">
<!-- BEGIN custom_link -->
                <li>
                    <a href="{CUSTOM_LNK_TGT}" title="{CUSTOM_LNK_TITLE}" class="firstlevel"><span class="firstlevel">{CUSTOM_LNK_LNK}</span></a>
                </li>
<!-- END custom_link -->
<!-- BEGIN album_list -->
                <li>
                    <a href="{ALB_LIST_TGT}" title="{ALB_LIST_TITLE}" class="firstlevel"><span class="firstlevel">{ALB_LIST_ICO}{ALB_LIST_LNK}</span></a>
                    <ul>
<!-- BEGIN lastup -->
                        <li>
                            <a href="{LASTUP_TGT}" title="{LASTUP_LNK}" rel="nofollow"><span>{LASTUP_ICO}{LASTUP_LNK}</span></a>
                        </li>
<!-- END lastup -->
<!-- BEGIN lastcom -->
                        <li>
                            <a href="{LASTCOM_TGT}" title="{LASTCOM_LNK}" rel="nofollow" ><span>{LASTCOM_ICO}{LASTCOM_LNK}</span></a>
                        </li>
<!-- END lastcom -->
<!-- BEGIN topn -->
                        <li>
                            <a href="{TOPN_TGT}" title="{TOPN_LNK}" rel="nofollow"><span>{TOPN_ICO}{TOPN_LNK}</span></a>
                        </li>
<!-- END topn -->
<!-- BEGIN toprated -->
                        <li>
                            <a href="{TOPRATED_TGT}" title="{TOPRATED_LNK}" rel="nofollow"><span>{TOPRATED_ICO}{TOPRATED_LNK}</span></a>
                        </li>
<!-- END toprated -->
<!-- BEGIN favpics -->
                        <li>
                            <a href="{FAV_TGT}" title="{FAV_LNK}" rel="nofollow"><span>{FAV_ICO}{FAV_LNK}</span></a>
                        </li>
<!-- END favpics -->
<!-- BEGIN browse_by_date -->
                        $browsebydatebutton
<!-- END browse_by_date -->
                    </ul>
                </li>
<!-- END album_list -->
<!-- BEGIN search -->
                <li>
                    <a href="{SEARCH_TGT}" title="{SEARCH_LNK}" class="firstlevel"><span class="firstlevel">{SEARCH_ICO}{SEARCH_LNK}</span></a>
                </li>
<!-- END search -->
</ul>
EOT;
/******************************************************************************
** Section <<<$template_sys_menu>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_gallery_admin_menu)) { //{THEMES}
/******************************************************************************
** Section <<<$template_gallery_admin_menu>>> - START
******************************************************************************/
// HTML template for gallery admin menu
$template_gallery_admin_menu = <<<EOT
  <ul class="dropmenu">
	  <li>
		  <a href="#" title="{FILES_TITLE}" class="firstlevel"><span class="firstlevel">{FILES_ICO}{FILES_LNK}</span></a>
		  <ul>
		  <!-- BEGIN admin_approval -->
			  <li><a href="editpics.php?mode=upload_approval" title="{UPL_APP_TITLE}" class="admin_menu_anim"><span>{UPL_APP_ICO}{UPL_APP_LNK}</span></a></li>
		  <!-- END admin_approval -->
		  <!-- BEGIN catmgr -->
			  <li><a href="catmgr.php" title="{CATEGORIES_TITLE}"><span>{CATEGORIES_ICO}{CATEGORIES_LNK}</span></a></li>
		  <!-- END catmgr -->
		  <!-- BEGIN albmgr -->
			  <li><a href="albmgr.php{CATL}" title="{ALBUMS_TITLE}"><span>{ALBUMS_ICO}{ALBUMS_LNK}</span></a></li>
		  <!-- END albmgr -->
		  <!-- BEGIN picmgr -->
			  <li><a href="picmgr.php" title="{PICTURES_TITLE}"><span>{PICTURES_ICO}{PICTURES_LNK}</span></a></li>
		  <!-- end picmgr -->
		  <!-- BEGIN batch_add -->
			  <li><a href="searchnew.php" title="{SEARCHNEW_TITLE}"><span>{SEARCHNEW_ICO}{SEARCHNEW_LNK}</span></a></li>
		  <!-- END batch_add -->
		  <!-- BEGIN admin_tools -->
			  <li><a href="util.php?t={TIME_STAMP}#admin_tools" title="{UTIL_TITLE}"><span>{UTIL_ICO}{UTIL_LNK}</span></a></li>
		  <!-- END admin_tools -->
		  </ul>
	  </li>
	  <li>
		  <a href="#" class="firstlevel" title="{INFO_TITLE}"><span class="firstlevel">{INFO_ICO}{INFO_LNK}</span></a>
		  <ul>
		  <!-- BEGIN review_comments -->
			  <li><a href="reviewcom.php" title="{COMMENTS_TITLE}"><span>{COMMENTS_ICO}{COMMENTS_LNK}</span></a></li>
		  <!-- END review_comments -->
		  <!-- BEGIN log_ecards -->
			  <li><a href="db_ecard.php" title="{DB_ECARD_TITLE}"><span>{DB_ECARD_ICO}{DB_ECARD_LNK}</span></a></li>
		  <!-- END log_ecards -->
		  <!-- BEGIN view_log_files -->
			  <li><a href="viewlog.php" title="{VIEW_LOG_FILES_TITLE}"><span>{VIEW_LOG_FILES_ICO}{VIEW_LOG_FILES_LNK}</span></a></li>
		  <!-- END view_log_files -->
		  <!-- BEGIN overall_stats -->
			  <li><a href="stat_details.php?type=hits&amp;sort=sdate&amp;dir=&amp;sdate=1&amp;ip=1&amp;search_phrase=0&amp;referer=0&amp;browser=1&amp;os=1&amp;mode=fullscreen&amp;page=1&amp;amount=50" title="{OVERALL_STATS_TITLE}" ><span>{OVERALL_STATS_ICO}{OVERALL_STATS_LNK}</span></a></li>
		  <!-- END overall_stats -->
		  <!-- BEGIN check_versions -->
			  <li><a href="versioncheck.php" title="{CHECK_VERSIONS_TITLE}"><span>{CHECK_VERSIONS_ICO}{CHECK_VERSIONS_LNK}</span></a></li>
		  <!-- END check_versions -->
		  <!-- BEGIN php_info -->
			  <li><a href="phpinfo.php" title="{PHPINFO_TITLE}"><span>{PHPINFO_ICO}{PHPINFO_LNK}</span></a></li>
		  <!-- END php_info -->
		  <!-- BEGIN show_news -->
			  <li><a href="mode.php?what=news&amp;referer=$REFERER" title="{SHOWNEWS_TITLE}"><span>{SHOWNEWS_ICO}{SHOWNEWS_LNK}</span></a></li>
		  <!-- END show_news -->
		  <!-- BEGIN documentation -->
			  <li><a href="{DOCUMENTATION_HREF}" title="{DOCUMENTATION_TITLE}"><span>{DOCUMENTATION_ICO}{DOCUMENTATION_LNK}</span></a></li>
		  <!-- END documentation -->
		  </ul>
	  </li>
  <!-- BEGIN config -->
	  <li>
		  <a href="admin.php" title="{ADMIN_TITLE}" class="firstlevel"><span class="firstlevel">{ADMIN_ICO}{ADMIN_LNK}</span></a>
		  <ul>
		  <!-- BEGIN keyword_manager -->
			  <li><a href="keywordmgr.php" title="{KEYWORDMGR_TITLE}"><span>{KEYWORDMGR_ICO}{KEYWORDMGR_LNK}</span></a></li>
		  <!-- END keyword_manager -->
		  <!-- BEGIN exif_manager -->
			  <li><a href="exifmgr.php" title="{EXIFMGR_TITLE}"><span>{EXIFMGR_ICO}{EXIFMGR_LNK}</span></a></li>
		  <!-- END exif_manager -->
		  <!-- BEGIN plugin_manager -->
			  <li><a href="pluginmgr.php" title="{PLUGINMGR_TITLE}"><span>{PLUGINMGR_ICO}{PLUGINMGR_LNK}</span></a></li>
		  <!-- END plugin_manager -->

		  <!-- BEGIN bridge_manager -->
			  <li><a href="bridgemgr.php" title="{BRIDGEMGR_TITLE}"><span>{BRIDGEMGR_ICO}{BRIDGEMGR_LNK}</span></a></li>
		  <!-- END bridge_manager -->
		  <!-- BEGIN update_database -->
			  <li><a href="update.php" title="{UPDATE_DATABASE_TITLE}"><span>{UPDATE_DATABASE_ICO}{UPDATE_DATABASE_LNK}</span></a></li>
		  <!-- END update_database -->
		  </ul>
	  </li>
  <!-- END config -->
  <!-- BEGIN usermgr -->
	  <li>
		  <a href="usermgr.php" title="{USERS_TITLE}" class="firstlevel"><span class="firstlevel">{USERS_ICO}{USERS_LNK}</span></a>
		  <ul>
		  <!-- BEGIN banmgr -->
			  <li><a href="banning.php" title="{BAN_TITLE}"><span>{BAN_ICO}{BAN_LNK}</span></a></li>
		  <!-- END banmgr -->
		  <!-- BEGIN groupmgr -->
			  <li><a href="groupmgr.php" title="{GROUPS_TITLE}"><span>{GROUPS_ICO}{GROUPS_LNK}</span></a></li>
		  <!-- END groupmgr -->
		  <!-- BEGIN admin_profile -->
			  <li><a href="profile.php?op=edit_profile" title="{MY_PROF_TITLE}"><span>{MY_PROF_ICO}{MY_PROF_LNK}</span></a></li>
		  <!-- END admin_profile -->
		  </ul>
	  </li>
  <!-- END usermgr -->
  </ul>
EOT;
/******************************************************************************
** Section <<<$template_gallery_admin_menu>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_user_admin_menu)) { //{THEMES}
/******************************************************************************
** Section <<<$template_user_admin_menu>>> - START
******************************************************************************/
// HTML template for user admin menu
$template_user_admin_menu = <<<EOT
  <ul class="dropmenu">
	  <li>
		  <a href="profile.php?op=edit_profile" title="{MY_PROF_TITLE}" class="firstlevel"><span class="firstlevel">{MY_PROF_ICO}{MY_PROF_LNK}</span></a>
		  <ul>
			  <li><a href="albmgr.php" title="{ALBMGR_TITLE}"><span>{ALBUMS_ICO}{ALBMGR_LNK}</span></a></li>
			  <li><a href="modifyalb.php" title="{MODIFYALB_TITLE}"><span>{MODIFYALB_ICO}{MODIFYALB_LNK}</span></a></li>
			  <li><a href="picmgr.php" title="{PICTURES_TITLE}"><span>{PICTURES_ICO}{PICTURES_LNK}</span></a></li>
		  </ul>
	  </li>
  </ul>
EOT;
/******************************************************************************
** Section <<<$template_user_admin_menu>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_thumb_view_title_row)) { //{THEMES}
/******************************************************************************
** Section <<<$template_thumb_view_title_row>>> - START
******************************************************************************/
// HTML template for title row of the thumbnail view (album title + sort options)
$template_thumb_view_title_row = <<<EOT

        <table width="100%" cellpadding="0" cellspacing="0" border="0">
            <tr>
                <td style="width:60%;vertical-align:top; position:absolute; left:-25px;" class="statlink">
                    <h2>{ALBUM_NAME}</h2>
                </td>
                <td style="text-align:right;">
<!-- BEGIN admin_buttons -->
                    <a href="modifyalb.php?album={ALBUM_ID}" class="admin_menu" title="{MODIFY_LNK}">{MODIFY_ICO}</a>
                    &nbsp;&nbsp;
                    <a href="index.php?cat={CAT_ID}" class="admin_menu" title="{PARENT_CAT_LNK}">{PARENT_CAT_ICO}</a>
                    &nbsp;&nbsp;
                    <a href="editpics.php?album={ALBUM_ID}" class="admin_menu" title="{EDIT_PICS_LNK}">{EDIT_PICS_ICO}</a>
                    &nbsp;&nbsp;
                    <a href="albmgr.php?cat={CAT_ID}" class="admin_menu" title="{ALBUM_MGR_LNK}">{ALBUM_MGR_ICO}</a>
<!-- END admin_buttons -->
                </td>
                <td style="text-align:right; position:absolute; right:115px;" class="sortorder_cell" id="sortorder_cell">
                    <!-- Use JavaScript to display the sorting options only to humans, but hide them from search engines to avoid double-content indexing (js/thumbnails.js) -->
                </td>
            </tr>
        </table>

EOT;
/******************************************************************************
** Section <<<$template_thumb_view_title_row>>> - END
******************************************************************************/
} //{THEMES}


if (!isset($template_thumbnail_view)) { //{THEMES}
/******************************************************************************
** Section <<<$template_thumbnail_view>>> - START
******************************************************************************/
// HTML template for thumbnails display
$template_thumbnail_view = <<<EOT

<!-- BEGIN header -->
        <tr>
<!-- END header -->
<!-- BEGIN thumb_cell -->
        <td valign="top" class="thumbnails" width ="{CELL_WIDTH}" align="center">
		
<table width="100%" class="hdr" cellspacing="0" cellpadding="0">
<tr>
  <td align="left" width="12"><img src="themes/morpheusX_gray/images/hdr_left_small.gif" width="12" height="25" alt="" /></td>
  <td width="100%" align="left" nowrap="nowrap">&nbsp;</td>
<td width="12" align="right"><img src="themes/morpheusX_gray/images/hdr_right_small.gif" width="12" height="25" alt="" /></td>
</tr>
</table>
  
<table class="maintable" width="100%" cellspacing="0">
						<tr>
								<td height="1" valign="top" class="tableh2">&nbsp;</td>
						</tr>
                        <tr>
                                <td align="center">
                                        <a href="{LINK_TGT}">{THUMB}<br /></a>
                                        {CAPTION}
                                        {ADMIN_MENU}
                                </td>
                        </tr>
</table>
           
<table width="100%" cellspacing="0" cellpadding="0" border="0">
  <tr>
    <td align="right" width="8"><img src="themes/morpheusX_gray/images/ftr_left.gif" width="8" height="8" alt="" /></td>
    <td style="background-image:url(themes/morpheusX_gray/images/ftr_bg.gif); background-repeat:repeat-x; " ><img src="themes/morpheusX_gray/images/spacer.gif" width="1" height="1" alt="" /></td>
    <td align="left" width="8"><img src="themes/morpheusX_gray/images/ftr_right.gif" width="8" height="8" alt="" /></td>
  </tr>
</table>

       </td>
<!-- END thumb_cell -->
<!-- BEGIN empty_cell -->
                <td valign="top" class="thumbnails" align="center">&nbsp;</td>
<!-- END empty_cell -->
<!-- BEGIN row_separator -->
        </tr>
        <tr>
<!-- END row_separator -->
<!-- BEGIN footer -->
        </tr>
<!-- END footer -->
<!-- BEGIN tabs -->
        <tr>
                <td colspan="{THUMB_COLS}" style="padding: 0px;">
                        <table width="100%" cellspacing="0" cellpadding="0">
                                <tr>
                                       {TABS}
                                </tr>
                        </table>
                </td>
        </tr>
<!-- END tabs -->
<!-- BEGIN spacer -->

        <img src="images/spacer.gif" width="1" height="7" border="" alt="" /><br />
<!-- END spacer -->

EOT;
/******************************************************************************
** Section <<<$template_thumbnail_view>>> - END
******************************************************************************/
} //{THEMES}


if (!isset($template_image_rating)) { //{THEMES}
/******************************************************************************
** Section <<<$template_image_rating>>> - START
******************************************************************************/
// HTML template for the image rating box
$template_image_rating = <<<EOT

<table align="center" width="100%" cellspacing="0" cellpadding="0" style="background-image:url(themes/morpheusX_gray/images/hdr_bg.gif); background-repeat:repeat-x; ">
  <tr>
    <td align="left" width="35"><img src="themes/morpheusX_gray/images/hdr_left_post.gif" width="35" height="25" alt="" /></td>
    <td width="100%" align="left" nowrap="nowrap">&nbsp;<b>{TITLE}</b> {VOTES}</td>
    <td width="120" align="right"><img src="themes/morpheusX_gray/images/hdr_right_blue.gif" width="115" height="25" alt="" /></td>
  </tr>
</table>

			<table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintable">
					<tr>
							<td height="1" valign="top" class="tableh2">&nbsp;</td>
					</tr>
					<tr  id="rating_stars">
						<td class="tableb" id="star_rating" ></td>
					</tr>
				    <noscript>
					<tr>
					  <td class="tableb" colspan="6" align="center">{JS_WARNING}</td>
					</tr>
					</noscript>
			</table>
                                
<table width="100%" cellspacing="0" cellpadding="0" border="0">
  <tr>
    <td align="right" width="8"><img src="themes/morpheusX_gray/images/ftr_left.gif" width="8" height="8" alt="" /></td>
    <td style="background-image:url(themes/morpheusX_gray/images/ftr_bg.gif); background-repeat:repeat-x; " ><img src="themes/morpheusX_gray/images/spacer.gif" width="1" height="1" alt="" /></td>
    <td align="left" width="8"><img src="themes/morpheusX_gray/images/ftr_right.gif" width="8" height="8" alt="" /></td>
  </tr>
</table>

EOT;
/******************************************************************************
** Section <<<$template_image_rating>>> - END
******************************************************************************/
} //{THEMES}


if (!isset($template_image_comments)) { //{THEMES}
/******************************************************************************
** Section <<<$template_image_comments>>> - START
******************************************************************************/
// HTML template for the display of comments
$template_image_comments = <<<EOT

<table align="center" width="100%" cellspacing="0" cellpadding="0" style="background-image:url(themes/morpheusX_gray/images/hdr_bg.gif); background-repeat:repeat-x; ">
  <tr>
    <td align="left" width="35"><img src="themes/morpheusX_gray/images/hdr_left_post.gif" width="35" height="25" alt="" /></td>
    <td width="100%" align="left" nowrap="nowrap">&nbsp;</td>
    <td width="120" align="right"><img src="themes/morpheusX_gray/images/hdr_right_blue.gif" width="115" height="25" alt="" /></td>
  </tr>
</table>
  
<table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintable" border="0">
	<tr>
			<td height="1" valign="top" class="tableh2">&nbsp;</td>
	</tr>
    <tr>
        <td>
            <table width="100%" cellpadding="0" cellspacing="0">
                <tr>
                    <td class="tableh2" nowrap="nowrap">
                        <strong>{MSG_AUTHOR_LNK}</strong>
                        <a name="comment{MSG_ID}"></a>&nbsp;
<!-- BEGIN ipinfo -->
                        ({IP})
<!-- END ipinfo -->
                    </td>
                    <td class="tableh2" align="right" width="100%">
<!-- BEGIN report_comment_button -->
                        <a href="report_file.php?pid={PID}&amp;msg_id={MSG_ID}&amp;what=comment" title="{REPORT_COMMENT_TITLE}">{REPORT_COMMENT_ICON}</a>
<!-- END report_comment_button -->
<!-- BEGIN pending approval -->
                        {PENDING_APPROVAL}
<!-- END pending approval -->
<!-- BEGIN buttons -->
                        <script type="text/javascript">
                            document.write('<a href="javascript:;" onclick="blocking(\'cbody{MSG_ID}\',\'\', \'block\'); blocking(\'cedit{MSG_ID}\',\'\', \'block\'); return false;" title="{EDIT_TITLE}">{EDIT_ICON}</a>');
                        </script>
                        <a href="delete.php?msg_id={MSG_ID}&amp;what=comment&amp;form_token={FORM_TOKEN}&amp;timestamp={TIMESTAMP}" onclick="return confirm('{CONFIRM_DELETE}');" title="{DELETE_TITLE}">{DELETE_ICON}</a>
<!-- END buttons -->
                    </td>
                    <td class="tableh2" align="right" nowrap="nowrap">
                        <span class="comment_date">[{MSG_DATE}]</span>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>
            <div id="cbody{MSG_ID}" style="display:block">
                {MSG_BODY}
            </div>
            <div id="cedit{MSG_ID}" style="display:none">
<!-- BEGIN edit_box_smilies -->
                <form name="f{MSG_ID}" id="f{MSG_ID}" method="post" action="db_input.php">
                    <table width="100%" cellpadding="0" cellspacing="0">
                        <tr>
                            <td valign="top">
                                <input type="hidden" name="event" value="comment_update" />
                                <input type="hidden" name="msg_id" value="{MSG_ID}" />
                            </td>
                        </tr>
                        <tr>
                            <td width="80%">
                                <textarea cols="40" rows="2" class="textinput" name="msg_body" onselect="storeCaret_f{MSG_ID}(this);" onclick="storeCaret_f{MSG_ID}(this);" onkeyup="storeCaret_f{MSG_ID}(this);" style="width: 100%;">{MSG_BODY_RAW}</textarea>
                            </td>
                            <td></td>
                            <td>
                                <input type="submit" class="button" name="submit" value="{OK}" />
                                <input type="hidden" name="form_token" value="{FORM_TOKEN}" />
                                <input type="hidden" name="timestamp" value="{TIMESTAMP}" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                <img src="images/spacer.gif" width="1" height="2" border="0" alt="" />
                                <br />
                            </td>
                        </tr>
                    </table>
                </form>
                {SMILIES}
<!-- END edit_box_smilies -->
<!-- BEGIN edit_box_no_smilies -->
                <form name="f{MSG_ID}" id="f{MSG_ID}" method="POST" action="db_input.php">
                    <table width="100%" cellpadding="0" cellspacing="0">
                        <tr>
                            <td>    
                                <input type="hidden" name="event" value="comment_update" />
                                <input type="hidden" name="msg_id" value="{MSG_ID}" />
                            </td>
                        </tr>
                        <tr>
                            <td width="100%">
                                <textarea cols="40" rows="2" class="textinput" name="msg_body" style="width: 100%;">{MSG_BODY_RAW}</textarea>
                            </td>
                            <td></td>
                            <td>
                                <input type="submit" class="button" name="submit" value="{OK}" />
                                <input type="hidden" name="form_token" value="{FORM_TOKEN}" />
                                <input type="hidden" name="timestamp" value="{TIMESTAMP}" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                <img src="images/spacer.gif" width="1" height="2" border="0" alt="" />
                                <br />
                            </td>
                        </tr>
                    </table>
                </form>
<!-- END edit_box_no_smilies -->
            </div>
        </td>
    </tr>
</table>

<table align="center" width="100%" cellspacing="0" cellpadding="0" class="maintable">
  <tr>
    <td align="right" width="8"><img src="themes/morpheusX_gray/images/ftr_left_new.gif" width="8" height="8" alt="" /></td>
    <td style="background-image:url(themes/morpheusX_gray/images/ftr_bg_new.gif); background-repeat:repeat-x; " ><img src="themes/morpheusX_gray/images/spacer.gif" width="1" height="1" alt="" /></td>
    <td align="left" width="8"><img src="themes/morpheusX_gray/images/ftr_right_new.gif" width="8" height="8" alt="" /></td>
  </tr>
</table>

EOT;
/******************************************************************************
** Section <<<$template_image_comments>>> - END
******************************************************************************/
} //{THEMES}


if (!isset($template_add_your_comment)) { //{THEMES}
/******************************************************************************
** Section <<<$template_add_your_comment>>> - START
******************************************************************************/
$template_add_your_comment = <<<EOT

<table align="center" width="100%" cellspacing="0" cellpadding="0" style="background-image:url(themes/morpheusX_gray/images/hdr_bg.gif); background-repeat:repeat-x; ">
  <tr>
    <td align="left" width="35"><img src="themes/morpheusX_gray/images/hdr_left_post.gif" width="35" height="25" alt="" /></td>
    <td width="100%" align="left" nowrap="nowrap">{ADD_YOUR_COMMENT}{HELP_ICON}</td>
    <td width="120" align="right"><img src="themes/morpheusX_gray/images/hdr_right_blue.gif" width="115" height="25" alt="" /></td>
  </tr>
</table>
          
        <form method="post" name="post" id="post" action="db_input.php">
                <table align="center" width="{WIDTH}" cellspacing="1" cellpadding="0" class="maintable">
					<tr>
							<td height="1" valign="top" class="tableh2">&nbsp;</td>
					</tr>
                        <tr>
                <td colspan="1">
                        <table width="100%" cellpadding="0" cellspacing="0">

<!-- BEGIN user_name_input -->
                                                        <tr>
                               <td>
                                        {NAME}
                                </td>
                                <td>
                                        <input type="text" class="textinput" name="msg_author" size="10" maxlength="20" value="{USER_NAME}" onclick="if (this.value == '{DEFAULT_USERNAME}') this.value = '';" onkeyup="if (this.value == '{DEFAULT_USERNAME}') this.value = '';" />
                                </td>
<!-- END user_name_input -->
<!-- BEGIN input_box_smilies -->
                                <td>
                                {COMMENT}
                                </td>
                                <td width="100%">
                                <input type="text" class="textinput" id="message" name="msg_body" onselect="storeCaret_post(this);" onclick="storeCaret_post(this);" onkeyup="storeCaret_post(this);" maxlength="{MAX_COM_LENGTH}" style="width: 100%;" />
                                </td>
<!-- END input_box_smilies -->
<!-- BEGIN input_box_no_smilies -->
                                <td>
                                {COMMENT}
                                </td>
                                <td width="100%">
                                <input type="text" class="textinput" id="message" name="msg_body"  maxlength="{MAX_COM_LENGTH}" style="width: 100%;" />
                                </td>
<!-- END input_box_no_smilies -->
<!-- BEGIN submit -->
                                <td>
                                <input type="hidden" name="event" value="comment" />
                                <input type="hidden" name="pid" value="{PIC_ID}" />
                                <button type="submit" class="button" name="submit" value="{OK}"  onclick="return notDefaultUsername(this.form, '{DEFAULT_USERNAME}', '{DEFAULT_USERNAME_MESSAGE}');">{OK_ICON}{OK}</button>
                                <input type="hidden" name="form_token" value="{FORM_TOKEN}" />
                                <input type="hidden" name="timestamp" value="{TIMESTAMP}" />
                                </td>
<!-- END submit -->
                                                        </tr>
<!-- BEGIN comment_captcha -->
                                                        <tr>
                                <td colspan="2">
                                  {CONFIRM}
                                </td>
                                <td colspan="2">
                                  <input type="text" name="confirmCode" size="5" maxlength="5" class="textinput" />
                                  <img src="captcha.php" align="middle" border="0" alt="" />
                                </td>
                                                        </tr>
<!-- END comment_captcha -->
                        </table>
                </td>
        </tr>
<!-- BEGIN smilies -->
        <tr>
                <td width="100%">
                        {SMILIES}
                </td>
        </tr>
<!-- END smilies -->
<!-- BEGIN login_to_comment -->
        <tr>
                                <td colspan="2">
                                  {LOGIN_TO_COMMENT}
                                </td>
        </tr>
<!-- END login_to_comment -->
                </table>
        </form>
          
<table align="center" width="100%" cellspacing="0" cellpadding="0" class="maintable">
  <tr>
    <td align="right" width="8"><img src="themes/morpheusX_gray/images/ftr_left_new.gif" width="8" height="8" alt="" /></td>
    <td style="background-image:url(themes/morpheusX_gray/images/ftr_bg_new.gif); background-repeat:repeat-x; " ><img src="themes/morpheusX_gray/images/spacer.gif" width="1" height="1" alt="" /></td>
    <td align="left" width="8"><img src="themes/morpheusX_gray/images/ftr_right_new.gif" width="8" height="8" alt="" /></td>
  </tr>
</table>
        
EOT;
/******************************************************************************
** Section <<<$template_add_your_comment>>> - END
******************************************************************************/
} //{THEMES}

if (!isset($template_film_strip)) { //{THEMES}
/******************************************************************************
** Section <<<$template_film_strip>>> - START
******************************************************************************/
// HTML template for filmstrip display
$template_film_strip = <<<EOT

      <table width="100%" cellspacing="0" cellpadding="0" class="filmstrip_background">
        <tr>
          <td class="filmstrip_background" style="overflow-y: hidden; background-image: url({TILE1});"><img src="{TILE1}" alt="" border="0" style="visibility:hidden;" /></td>
          <td><table>
              <tr>
                <td class="prev_strip"></td>
              </tr>
              <tr>
                <td valign="bottom" style="{THUMB_TD_STYLE}" class="filmstrip_background" height="100%">
                  <div id="film">
                    <table class="tape">
                      {THUMB_STRIP}
                    </table>
                  </div></td>
              </tr>
              <tr>
                <td class="next_strip"></td>
              </tr>
            </table></td>
          <td class="filmstrip_background" style="background-image: url({TILE2});"><img src="{TILE2}" alt="" border="0" style="visibility:hidden;" /></td>
        </tr>
      </table>

<!-- BEGIN thumb_cell -->
                <tr><td class="thumb" style="height:{$CONFIG['thumb_width']}px;vertical-align: middle; text-align: center;">
                  <a href="{LINK_TGT}" class="thumbLink" style="{ONE_WIDTH}">{THUMB}</a>
                </td></tr>
<!-- END thumb_cell -->
<!-- BEGIN empty_cell -->
                <tr><td valign="top" align="center" >&nbsp;</td></tr>
<!-- END empty_cell -->
EOT;
/******************************************************************************
** Section <<<$template_film_strip>>> - END
******************************************************************************/
} //{THEMES}

if (!function_exists('theme_display_film_strip')) {  //{THEMES}
/******************************************************************************
** Section <<<theme_display_film_strip>>> - START
******************************************************************************/
// Function to display the film strip
function theme_display_film_strip(&$thumb_list, $nbThumb, $album_name, $aid, $cat, $pos, $sort_options, $mode = 'thumb', $date='', $filmstrip_prev_pos, $filmstrip_next_pos,$max_block_items,$thumb_width)
{
    global $CONFIG, $THEME_DIR;
    global $template_film_strip, $lang_film_strip, $lang_common, $pic_count,$mar_pic;

    $superCage = Inspekt::makeSuperCage();

    static $template = '';
    static $thumb_cell = '';
    static $empty_cell = '';
    static $spacer = '';

    if (defined('THEME_HAS_FILM_STRIP_GRAPHIC')) { set_js_var('vertstrip', 1); }

    if ((!$template)) {
        $template = $template_film_strip;
        $thumb_cell = template_extract_block($template, 'thumb_cell');
        $empty_cell = template_extract_block($template, 'empty_cell');
    }

    $cat_link = is_numeric($aid) ? '' : '&amp;cat=' . $cat;
    $date_link = $date=='' ? '' : '&amp;date=' . $date;

    if ($superCage->get->getInt('uid')) {
        $uid_link = '&amp;uid=' . $superCage->get->getInt('uid');
    } else {
        $uid_link = '';
    }

    $i = 0;
    $thumb_strip = '';
    foreach($thumb_list as $thumb) {
        $i++;
        if ($mode == 'thumb') {
            if ($thumb['pos'] == $pos && !$superCage->get->keyExists('film_strip')) {
                    $thumb['image'] = str_replace('class="image"', 'class="image middlethumb"', $thumb['image']);
            }
            // determine if thumbnail link targets should open in a pop-up
            if ($CONFIG['thumbnail_to_fullsize'] == 1) { // code for full-size pop-up
                if (!USER_ID && $CONFIG['allow_unlogged_access'] <= 2) {
                    $target = 'javascript:;" onclick="alert(\''.sprintf($lang_errors['login_needed'],'','','','').'\');';
                } elseif (USER_ID && USER_ACCESS_LEVEL <= 2) {
                    $target = 'javascript:;" onclick="alert(\''.sprintf($lang_errors['access_intermediate_only'],'','','','').'\');';
                } else {
                    $target = 'javascript:;" onclick="MM_openBrWindow(\'displayimage.php?pid=' . $thumb['pid'] . '&fullsize=1\',\'' . uniqid(rand()) . '\',\'scrollbars=yes,toolbar=no,status=no,resizable=yes,width=' . ((int)$thumb['pwidth']+(int)$CONFIG['fullsize_padding_x']) .  ',height=' .   ((int)$thumb['pheight']+(int)$CONFIG['fullsize_padding_y']). '\');';
                }
            } elseif ($aid == 'lastcom' || $aid == 'lastcomby') {
                $page = cpg_get_comment_page_number($thumb['msg_id']);
                $page = (is_numeric($page)) ? "&amp;page=$page" : '';
                $target = "displayimage.php?album=$aid$cat_link$date_link&amp;pid={$thumb['pid']}$uid_link&amp;msg_id={$thumb['msg_id']}$page#comment{$thumb['msg_id']}";
            } else {
                $target = "displayimage.php?album=$aid$cat_link$date_link&amp;pid={$thumb['pid']}$uid_link#top_display_media";
            }
            $params = array(
                '{LINK_TGT}' => $target,
                '{THUMB}' => $thumb['image'],
                '{ONE_WIDTH}'  => "width:".$thumb_width."px; float: left" ,
                );
        } else {
            $params = array(
                '{LINK_TGT}' => "index.php?cat={$thumb['cat']}",
                '{THUMB}' => $thumb['image'],
                '{ONE_WIDTH}'  => "width:".$thumb_width."px; float: left" ,
                );
        }
        $thumb_strip .= template_eval($thumb_cell, $params);
    }

        $tile1 = $THEME_DIR . 'images/tile1.gif';
        $tile2 = $THEME_DIR . 'images/tile2.gif';


    if (defined('THEME_HAS_NAVBAR_GRAPHICS')) {
        $location = $THEME_DIR;
    } else {
        $location= '';
    }
    $max_itme_width_ul = $max_block_items;
    if(($max_block_items%2)==0){
        $max_itme_width_ul = $max_block_items +1;
    }
    $set_width_to_film = "width:".($max_block_items*($thumb_width+4))."px; position:relative;";

    $params = array('{THUMB_STRIP}' => $thumb_strip,
        '{COLS}' => $i,
        '{TILE1}' => $tile1,
        '{TILE2}' => $tile2,
        '{SET_WIDTH}'  => $set_width_to_film,
        );

    ob_start();
    echo '<div id="filmstrip">';
    if (!defined('THEME_HAS_FILM_STRIP_GRAPHIC')) { starttable($CONFIG['picture_table_width']); }
    echo template_eval($template, $params);
    if (!defined('THEME_HAS_FILM_STRIP_GRAPHIC')) { endtable(); }
    echo '</div>';
    $film_strip = ob_get_contents();
    ob_end_clean();

    return $film_strip;
}
/******************************************************************************
** Section <<<theme_display_film_strip>>> - END
******************************************************************************/
}  //{THEMES}

if (!function_exists('theme_display_image')) {  //{THEMES}
/******************************************************************************
** Section <<<theme_display_image>>> - START
******************************************************************************/
function theme_display_image($nav_menu, $picture, $votes, $pic_info, $comments, $film_strip)
{
    global $CONFIG, $LINEBREAK;

    $superCage = Inspekt::makeSuperCage();

    $width = $CONFIG['picture_table_width'];

    echo '<a name="top_display_media"></a>'; // set the navbar-anchor
    starttable();
    echo $nav_menu;
    endtable();

    starttable();

    echo "<tr>";
    echo "<td height='100%' align='center' style='padding:5px;'>
    
          <table width='100%' style='background-image:url(themes/morpheusX_gray/images/hdr_bg.gif); background-repeat:repeat-x; ' cellspacing='0' cellpadding='0'>
            <tr>
              <td align='left' width='35'><img src='themes/morpheusX_gray/images/hdr_left_blue.gif' width='35' height='25' alt='' /></td>
              <td width='100%' align='left' nowrap='nowrap'>&nbsp;</td>
              <td width='120' align='right'><img src='themes/morpheusX_gray/images/hdr_right_orange.gif' width='115' height='25' alt='' /></td>
            </tr>
          </table>
   
          <table class='maintable' width='100%' cellspacing='1'>
            <tr>
              <td height='1' valign='top' class='tableh2'>&nbsp;</td>
            </tr>
            <tr>
              <td valign='top'><!-- gb before picture -->";    
    echo $picture;
    echo "</td></tr></table>
    
          <table width='100%' cellspacing='0' cellpadding='0'>
            <tr>
              <td align='right' width='8'><img src='themes/morpheusX_gray/images/ftr_left.gif' width='8' height='8' alt='' /></td>
              <td style='background-image:url(themes/morpheusX_gray/images/ftr_bg.gif); background-repeat:repeat-x; ' ><img src='themes/morpheusX_gray/images/spacer.gif' width='1' height='1' alt='' /></td>
              <td align='left' width='8'><img src='themes/morpheusX_gray/images/ftr_right.gif' width='8' height='8' alt='' /></td>
            </tr>
          </table>
    
          </td><!-- gb after picture -->";
    if ($CONFIG['display_film_strip'] == 1) {
    echo "<td width='200' height='100%' align='center' style='padding:5px;'>

          <table width='100%' style='background-image:url(themes/morpheusX_gray/images/hdr_bg.gif); background-repeat:repeat-x; ' cellspacing='0' cellpadding='0'>
            <tr>
              <td align='left' width='35'><img src='themes/morpheusX_gray/images/hdr_left_blue.gif' width='35' height='25' alt='' /></td>
              <td width='100%' align='left' nowrap='nowrap'>&nbsp;</td>
              <td width='120' align='right'><img src='themes/morpheusX_gray/images/hdr_right_orange.gif' width='115' height='25' alt='' /></td>
            </tr>
          </table>

          <table class='maintable' width='100%' cellspacing='1'>
           <tr>
              <td valign='top'><!-- gb before film_strip -->";
    echo $film_strip;
    echo "</td></tr></table>
    
          <table width='100%' cellspacing='0' cellpadding='0'>
            <tr>
              <td align='right' width='8'><img src='themes/morpheusX_gray/images/ftr_left.gif' width='8' height='8' alt='' /></td>
              <td style='background-image:url(themes/morpheusX_gray/images/ftr_bg.gif); background-repeat:repeat-x; ' ><img src='themes/morpheusX_gray/images/spacer.gif' width='1' height='1' alt='' /></td>
              <td align='left' width='8'><img src='themes/morpheusX_gray/images/ftr_right.gif' width='8' height='8' alt='' /></td>
            </tr>
          </table>
    
          </td><!-- gb after film_strip -->";
    }
    echo "</tr>";

    endtable();

    echo $votes;

    $picinfo = $superCage->cookie->keyExists('picinfo') ? $superCage->cookie->getAlpha('picinfo') : ($CONFIG['display_pic_info'] ? 'block' : 'none');
    echo $LINEBREAK . '<div id="picinfo" style="display: '.$picinfo.';">' . $LINEBREAK;
    starttable();
    echo $pic_info;
    endtable();
    echo '</div>' . $LINEBREAK;

    echo '<a name="comments_top"></a>';
    echo '<div id="comments">' . $LINEBREAK;
    echo $comments;
    echo '</div>' . $LINEBREAK;

}
/******************************************************************************
** Section <<<theme_display_image>>> - END
******************************************************************************/
}  //{THEMES}

if (!isset($template_album_list_cat)) { //{THEMES}
/******************************************************************************
** Section <<<$template_album_list_cat>>> - START
******************************************************************************/
// HTML template for the album list
$template_album_list_cat = <<<EOT

<!-- BEGIN c_stat_row -->
        <tr>
                <td colspan="{COLUMNS}" class="tableh1" align="center"><span class="statlink">{STATISTICS}</span></td>
        </tr>
<!-- END c_stat_row -->
<!-- BEGIN c_header -->
        <tr class="tableb tableb_alternate">
<!-- END c_header -->
<!-- BEGIN c_album_cell -->
        <td width="{COL_WIDTH}%" valign="top">

<div style="margin:5px;">
<table width="100%" style="background-image:url(themes/morpheusX_gray/images/hdr_bg.gif); background-repeat:repeat-x;" cellspacing="0" cellpadding="0">
  <tr>
    <td align="left" width="35"><img src="themes/morpheusX_gray/images/hdr_left_house.gif" width="35" height="25" alt="" /></td>
    <td width="100%" align="left" nowrap="nowrap" style="font-size: 9px;">&nbsp;<span class="alblink"><a href="{ALB_LINK_TGT}">{ALBUM_TITLE}</a></span></td>
    <td width="120" align="right"><img src="themes/morpheusX_gray/images/hdr_right_orange.gif" width="115" height="25" alt="" /></td>
  </tr>
</table>
		
        <table class="maintable" width="100%" cellspacing="0" cellpadding="0">
        <tr>
                <td colspan="3" height="1" valign="top" class="tableh2">&nbsp;</td>
        </tr>
        <tr>
                <td colspan="3">
                        <img src="images/spacer.gif" width="1" height="1" border="0" alt="" /><br />
                </td>
        </tr>
        <tr>
                <td align="center" valign="middle" class="thumbnails">
                        <img src="images/spacer.gif" width="{THUMB_CELL_WIDTH}" height="1" style="margin-top: 0px; margin-bottom: 0px; border: none;" alt="" /><br />
                        <a href="{ALB_LINK_TGT}" class="albums">{ALB_LINK_PIC}<br /></a>
                </td>
                <td>
                        <img src="images/spacer.gif" width="1" height="1" border="0" alt="" />
                </td>
                <td width="100%" valign="top" class="tableb tableb_alternate">
                        {ADMIN_MENU}
                        <p>{ALB_DESC}</p>
                        <p class="album_stat">{ALB_INFOS}<br />{ALB_HITS}</p>
                </td>
        </tr>
        </table>

<table width="100%" cellspacing="0" cellpadding="0" border="0">
  <tr>
    <td align="right" width="8"><img src="themes/morpheusX_gray/images/ftr_left_new.gif" width="8" height="8" alt="" /></td>
    <td style="background-image:url(themes/morpheusX_gray/images/ftr_bg_new.gif); background-repeat:repeat-x; " ><img src="themes/morpheusX_gray/images/spacer.gif" width="1" height="1" alt="" /></td>
    <td align="left" width="8"><img src="themes/morpheusX_gray/images/ftr_right_new.gif" width="8" height="8" alt="" /></td>
  </tr>
</table>
</div>
		
        </td>
<!-- END c_album_cell -->
<!-- BEGIN c_empty_cell -->
        <td width="{COL_WIDTH}%" valign="top">
		
<table width="100%" style="background-image:url(themes/morpheusX_gray/images/hdr_bg.gif); background-repeat:repeat-x; " cellspacing="0" cellpadding="0">
  <tr>
    <td align="left" width="35"><img src="themes/morpheusX_gray/images/hdr_left_orange.gif" width="35" height="25" alt="" /></td>
    <td width="100%" align="left" nowrap="nowrap"><b>&nbsp;</b></td>
    <td width="120" align="right"><img src="themes/morpheusX_gray/images/hdr_right_blue.gif" width="115" height="25" alt="" /></td>
  </tr>
</table>
		
        <table width="100%" cellspacing="0" cellpadding="0" border="1">
        <tr>
                <td width="100%" valign="top" class="tableb_compact" >
                      <div class="thumbnails" style="background-color:transparent"><img src="images/spacer.gif" width="1" height="{SPACER}" border="0" class="image" style="border:0;margin-top:1px;margin-bottom:0" alt="" /></div>
                </td>
        </tr>
        </table>

<table width="100%" cellspacing="0" cellpadding="0" border="0">
  <tr>
    <td align="right" width="8"><img src="themes/morpheusX_gray/images/ftr_left_new.gif" width="8" height="8" alt="" /></td>
    <td style="background-image:url(themes/morpheusX_gray/images/ftr_bg_new.gif); background-repeat:repeat-x; " ><img src="themes/morpheusX_gray/images/spacer.gif" width="1" height="1" alt="" /></td>
    <td align="left" width="8"><img src="themes/morpheusX_gray/images/ftr_right_new.gif" width="8" height="8" alt="" /></td>
  </tr>
</table>
		
        </td>
<!-- END c_empty_cell -->
<!-- BEGIN c_row_separator -->
        </tr>
        <tr class="tableb_compact">
<!-- END c_row_separator -->
<!-- BEGIN c_footer -->
        </tr>
<!-- END c_footer -->
<!-- BEGIN c_tabs -->
        <tr>
                <td colspan="{COLUMNS}" style="padding: 0px;">
                        <table width="100%" cellspacing="0" cellpadding="0">
                                <tr>
                                       {TABS}
                                </tr>
                        </table>
                </td>
        </tr>
<!-- END c_tabs -->
<!-- BEGIN c_spacer -->
        <img src="images/spacer.gif" width="1" height="7" border="" alt="" /><br />
<!-- END c_spacer -->

EOT;
/******************************************************************************
** Section <<<$template_album_list_cat>>> - END
******************************************************************************/
} //{THEMES}

if (!function_exists('theme_style_credits')) {  //{THEMES}
/******************************************************************************
** Section <<<theme_credits>>> - START
******************************************************************************/
// Function for the credits-section
function theme_style_credits() 
{
    $return = <<< EOT
<span class="copyright"> Design by <a href="http://www.phpbbstyles.com" target="_blank">phpBBStyles.com</a> | <a href="http://www.stylesdb.com" target="_blank">Styles Database</a> | Converted for Coppermine Gallery 1.5.x by <a href="http://www.portalxl.nl/forum/">PortalXL Group</a>&nbsp;&copy; 2010</span>    
EOT;
    return $return;
}
/******************************************************************************
** Section <<<theme_credits>>> - END
******************************************************************************/
}  //{THEMES}

if (!function_exists('pagefooter')) {  //{THEMES}
/******************************************************************************
** Section <<<pagefooter>>> - START
******************************************************************************/
// Function for writing a pagefooter
function pagefooter()
{
    //global $HTTP_GET_VARS, $HTTP_POST_VARS, $HTTP_SERVER_VARS;
    global $USER, $USER_DATA, $CONFIG, $time_start, $query_stats, $queries;
    global $template_footer;

    $custom_footer = cpg_get_custom_include($CONFIG['custom_footer_path']);

    if ($CONFIG['debug_mode']==1 || ($CONFIG['debug_mode']==2 && GALLERY_ADMIN_MODE)) {
        cpg_debug_output();
    }

    $template_vars = array(
        '{GAL_NAME}' => $CONFIG['gallery_name'],
        '{GAL_DESCRIPTION}' => $CONFIG['gallery_description'],
        '{SYS_MENU}' => theme_main_menu('sys_menu'),
        '{SUB_MENU}' => theme_main_menu('sub_menu'),
        '{ADMIN_MENU}' => theme_admin_mode_menu(),
        '{CUSTOM_HEADER}' => $custom_header,
        '{JAVASCRIPT}' => theme_javascript_head(),
        '{CUSTOM_FOOTER}' => $custom_footer,
        '{VANITY}' => (defined('THEME_IS_XHTML10_TRANSITIONAL')) ? theme_vanity() : '',
        '{CREDITS}' => theme_credits(),
        '{THEME_CREDITS}' => theme_style_credits(),
    );

    echo template_eval($template_footer, $template_vars);
}
/******************************************************************************
** Section <<<pagefooter>>> - END
******************************************************************************/
}  //{THEMES}

if (!function_exists('starttable')) {  //{THEMES}
/******************************************************************************
** Section <<<starttable>>> - START
******************************************************************************/
// Function to start a 'standard' table
function starttable($width = '-1', $title = '', $title_colspan = '1')
{
    global $CONFIG;

    if ($width == '-1') $width = $CONFIG['picture_table_width'];
    if ($width == '100%') $width = $CONFIG['main_table_width'];
    echo <<<EOT

<!-- Start standard table -->
<table align="center" width="100%" cellspacing="0" cellpadding="0" style="background-image:url(themes/morpheusX_gray/images/hdr_bg.gif); background-repeat:repeat-x; ">
  <tr>
    <td align="left" width="35"><img src="themes/morpheusX_gray/images/hdr_left_post.gif" width="35" height="25" alt="" /></td>
    <td width="100%" align="left" nowrap="nowrap">		
                  
EOT;
    if ($title) {
        echo <<<EOT
        <table width="100%" cellpadding="0" cellspacing="0">
          <tr>
              <td colspan="$title_colspan" style="position:absolute; left:100px; width:85%; margin-top:-11px;">$title</td>
          </tr>
        </table>
EOT;
    }

	echo <<<EOT
		
	</td>
    <td width="120" align="right"><img src="themes/morpheusX_gray/images/hdr_right_blue.gif" width="115" height="25" alt="" /></td>
  </tr>
</table>
                                    
<table align="center" width="$width" class="maintable" cellspacing="1" cellpadding="0">

EOT;
}
/******************************************************************************
** Section <<<starttable>>> - END
******************************************************************************/
}  //{THEMES}

if (!function_exists('endtable')) {  //{THEMES}
/******************************************************************************
** Section <<<endtable>>> - START
******************************************************************************/
function endtable($return = false)
{
    $text = <<<EOT
</table>
                       
<table align="center" width="100%" cellspacing="0" cellpadding="0">
  <tr>
    <td align="right" width="8"><img src="themes/morpheusX_gray/images/ftr_left_new.gif" width="8" height="8" alt="" /></td>
    <td style="background-image:url(themes/morpheusX_gray/images/ftr_bg_new.gif); background-repeat:repeat-x;"><img src="themes/morpheusX_gray/images/spacer.gif" width="1" height="1" alt="" /></td>
    <td align="left" width="8"><img src="themes/morpheusX_gray/images/ftr_right_new.gif" width="8" height="8" alt="" /></td>
  </tr>
</table>
<!-- End standard table -->

EOT;
    if (!$return) {
        echo $text;
    } else {
        return $text;
    }
}
/******************************************************************************
** Section <<<endtable>>> - END
******************************************************************************/
}  //{THEMES}

?>