/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import snaq.db.StatementListener;
import snaq.util.Reusable;

public class CachedStatement
implements Statement,
Reusable {
    protected StatementListener listener;
    protected Statement st;
    protected boolean open = true;

    public CachedStatement(Statement statement) {
        this.st = statement;
    }

    protected String getParametersString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            switch (this.getResultSetType()) {
                case 1004: {
                    stringBuffer.append("TYPE_SCROLL_INSENSITIVE");
                    break;
                }
                case 1005: {
                    stringBuffer.append("TYPE_SCROLL_SENSITIVE");
                    break;
                }
                default: {
                    stringBuffer.append("TYPE_FORWARD_ONLY");
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            stringBuffer.append("TYPE_UNKNOWN");
        }
        stringBuffer.append(',');
        try {
            switch (this.getResultSetConcurrency()) {
                case 1008: {
                    stringBuffer.append("CONCUR_UPDATABLE");
                    break;
                }
                default: {
                    stringBuffer.append("CONCUR_READ_ONLY");
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            stringBuffer.append("CONCUR_UNKNOWN");
        }
        stringBuffer.append(',');
        try {
            switch (this.getResultSetHoldability()) {
                case 2: {
                    stringBuffer.append("CLOSE_CURSORS_AT_COMMIT");
                    break;
                }
                case 1: {
                    stringBuffer.append("HOLD_CURSORS_OVER_COMMIT");
                }
            }
        }
        catch (SQLException sQLException) {
            stringBuffer.append("HOLD_UNKNOWN");
        }
        return stringBuffer.toString();
    }

    public void recycle() throws SQLException {
        ResultSet resultSet = this.st.getResultSet();
        if (resultSet != null) {
            resultSet.close();
        }
        try {
            this.st.clearWarnings();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.st.clearBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void close() throws SQLException {
        if (!this.open) {
            return;
        }
        this.open = false;
        if (this.listener != null) {
            this.listener.statementClosed(this);
        } else {
            this.release();
        }
    }

    public void release() throws SQLException {
        this.st.close();
    }

    void setOpen() {
        this.open = true;
    }

    void setStatementListener(StatementListener statementListener) {
        this.listener = statementListener;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        return this.st.executeQuery(string);
    }

    public int executeUpdate(String string) throws SQLException {
        return this.st.executeUpdate(string);
    }

    public int getMaxFieldSize() throws SQLException {
        return this.st.getMaxFieldSize();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.st.setMaxFieldSize(n);
    }

    public int getMaxRows() throws SQLException {
        return this.st.getMaxRows();
    }

    public void setMaxRows(int n) throws SQLException {
        this.st.setMaxRows(n);
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.st.setEscapeProcessing(bl);
    }

    public int getQueryTimeout() throws SQLException {
        return this.st.getQueryTimeout();
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.st.setQueryTimeout(n);
    }

    public void cancel() throws SQLException {
        this.st.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.st.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.st.clearWarnings();
    }

    public void setCursorName(String string) throws SQLException {
        this.st.setCursorName(string);
    }

    public boolean execute(String string) throws SQLException {
        return this.st.execute(string);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.st.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.st.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.st.getMoreResults();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.st.setFetchDirection(n);
    }

    public int getFetchDirection() throws SQLException {
        return this.st.getFetchDirection();
    }

    public void setFetchSize(int n) throws SQLException {
        this.st.setFetchSize(n);
    }

    public int getFetchSize() throws SQLException {
        return this.st.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.st.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.st.getResultSetType();
    }

    public void addBatch(String string) throws SQLException {
        this.st.addBatch(string);
    }

    public void clearBatch() throws SQLException {
        this.st.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.st.executeBatch();
    }

    public Connection getConnection() throws SQLException {
        return this.st.getConnection();
    }

    public boolean getMoreResults(int n) throws SQLException {
        return this.st.getMoreResults(n);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.st.getGeneratedKeys();
    }

    public int executeUpdate(String string, int n) throws SQLException {
        return this.st.executeUpdate(string, n);
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        return this.st.executeUpdate(string, nArray);
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        return this.st.executeUpdate(string, stringArray);
    }

    public boolean execute(String string, int n) throws SQLException {
        return this.st.execute(string, n);
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        return this.st.execute(string, nArray);
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        return this.st.execute(string, stringArray);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.st.getResultSetHoldability();
    }
}

