/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfFontList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] DEFAULT_FONT = "\\deff".getBytes();
    private static final byte[] FONT_TABLE = "\\fonttbl".getBytes();
    public static final byte[] FONT_NUMBER = "\\f".getBytes();
    private ArrayList fontList = new ArrayList();

    public RtfFontList(RtfDocument doc) {
        super(doc);
        this.fontList.add(new RtfFont(this.document, 0));
    }

    public int getFontNumber(RtfFont font) {
        int fontIndex = -1;
        for (int i = 0; i < this.fontList.size(); ++i) {
            if (!this.fontList.get(i).equals(font)) continue;
            fontIndex = i;
        }
        if (fontIndex == -1) {
            fontIndex = this.fontList.size();
            this.fontList.add(font);
        }
        return fontIndex;
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(DEFAULT_FONT);
            result.write(this.intToByteArray(0));
            result.write(RtfBasicElement.OPEN_GROUP);
            result.write(FONT_TABLE);
            for (int i = 0; i < this.fontList.size(); ++i) {
                result.write(RtfBasicElement.OPEN_GROUP);
                result.write(FONT_NUMBER);
                result.write(this.intToByteArray(i));
                result.write(((RtfFont)this.fontList.get(i)).writeDefinition());
                result.write(RtfBasicElement.COMMA_DELIMITER);
                result.write(RtfBasicElement.CLOSE_GROUP);
            }
            result.write(RtfBasicElement.CLOSE_GROUP);
            result.write(10);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

