/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import util.Arith;

public class ArrayUtil {
    public static Object getObject(String colName, int index, ArrayList v) {
        if (v == null) {
            return null;
        }
        if (index > v.size()) {
            return null;
        }
        HashMap h = (HashMap)v.get(index);
        Object result = h.get(colName.toLowerCase());
        if (result == null) {
            result = h.get(colName.toUpperCase());
        }
        if (result == null) {
            result = h.get(colName);
        }
        return result;
    }

    public static String getString(String colName, int index, ArrayList v) {
        if (v == null) {
            return "";
        }
        if (index > v.size()) {
            return "";
        }
        HashMap h = (HashMap)v.get(index);
        String result = (String)h.get(colName.toLowerCase());
        if (result == null) {
            result = (String)h.get(colName.toUpperCase());
        }
        if (result == null) {
            result = (String)h.get(colName);
        }
        return result == null ? "" : result;
    }

    public static int getInt(String colName, int index, ArrayList v) {
        if (v == null) {
            return 0;
        }
        if (index > v.size()) {
            return 0;
        }
        HashMap h = (HashMap)v.get(index);
        Integer result = (Integer)h.get(colName.toLowerCase());
        if (result == null) {
            result = (Integer)h.get(colName.toUpperCase());
        }
        if (result == null) {
            result = (Integer)h.get(colName);
        }
        return result;
    }

    public static double getDouble(String colName, int index, ArrayList v) {
        if (v == null) {
            return 0.0;
        }
        if (index > v.size()) {
            return 0.0;
        }
        HashMap h = (HashMap)v.get(index);
        BigDecimal result = (BigDecimal)h.get(colName.toLowerCase());
        if (result == null) {
            result = (BigDecimal)h.get(colName.toUpperCase());
        }
        if (result == null) {
            result = (BigDecimal)h.get(colName);
        }
        return result.doubleValue();
    }

    public static Timestamp getTimestamp(String colName, int index, ArrayList v) {
        if (v == null) {
            return null;
        }
        if (index > v.size()) {
            return null;
        }
        HashMap h = (HashMap)v.get(index);
        Timestamp result = (Timestamp)h.get(colName.toLowerCase());
        if (result == null) {
            result = (Timestamp)h.get(colName.toUpperCase());
        }
        if (result == null) {
            result = (Timestamp)h.get(colName);
        }
        return result;
    }

    public static int indexOf(String colName, Object value, ArrayList v) {
        int i = 0;
        while (i < v.size()) {
            Object obj = ArrayUtil.getObject(colName, i, v);
            if (obj.equals(value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(String[] colNames, Object[] values, ArrayList v) {
        int i = 0;
        while (i < v.size()) {
            boolean eq = false;
            int j = 0;
            while (j < colNames.length) {
                Object obj = ArrayUtil.getObject(colNames[j], i, v);
                if (!obj.equals(values[j])) break;
                if (j == colNames.length - 1) {
                    eq = true;
                }
                ++j;
            }
            if (eq) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void setObject(String col, Object c, int i, ArrayList v) {
        HashMap h = (HashMap)v.get(i);
        h.put(col.toLowerCase(), c);
        h.put(col, c);
    }

    public static void setString(String col, String c, int i, ArrayList v) {
        HashMap h = (HashMap)v.get(i);
        h.put(col.toLowerCase(), c);
        h.put(col, c);
    }

    public static void setInt(String col, int c, int i, ArrayList v) {
        HashMap h = (HashMap)v.get(i);
        h.put(col.toLowerCase(), new Integer(c));
        h.put(col, new Integer(c));
    }

    public static void setDouble(String col, double c, int i, ArrayList v) {
        HashMap h = (HashMap)v.get(i);
        h.put(col.toLowerCase(), new BigDecimal(c));
        h.put(col, new BigDecimal(c));
    }

    public static void setTimestamp(String col, Timestamp t, int i, ArrayList v) {
        HashMap h = (HashMap)v.get(i);
        h.put(col.toLowerCase(), t);
        h.put(col, t);
    }

    public static void addInt(String col, int c, int i, ArrayList v) {
        int a = ArrayUtil.getInt(col, i, v);
        ArrayUtil.setInt(col, a + c, i, v);
    }

    public static void addDouble(String col, double c, int i, ArrayList v) {
        double a = ArrayUtil.getDouble(col, i, v);
        ArrayUtil.setDouble(col, Arith.add(a, c), i, v);
    }

    public static int compare(HashMap h1, HashMap h2, String[] cols) {
        int result = 0;
        int i = 0;
        Object obj1 = null;
        Object obj2 = null;
        while (result == 0 && i < cols.length) {
            obj1 = h1.get(cols[i].toLowerCase());
            obj2 = h2.get(cols[i].toLowerCase());
            if (obj1 == null && obj2 == null) {
                return new Integer(0);
            }
            if (obj1 == null) {
                return new Integer(-1);
            }
            if (obj2 == null) {
                return new Integer(1);
            }
            if (obj1 instanceof Integer) {
                result = ((Integer)obj1).compareTo((Integer)obj2);
            } else if (obj1 instanceof Double) {
                result = ((Double)obj1).compareTo((Double)obj2);
            } else if (obj1 instanceof String) {
                result = ((String)obj1).compareTo((String)obj2);
            } else if (obj1 instanceof Timestamp) {
                result = ((Timestamp)obj1).compareTo((Timestamp)obj2);
            } else if (obj1 instanceof BigDecimal) {
                result = ((BigDecimal)obj1).compareTo((BigDecimal)obj2);
            }
            ++i;
        }
        return result;
    }

    public static ArrayList sort(ArrayList a, String col) {
        return ArrayUtil.sort(a, new String[]{col});
    }

    public static ArrayList sort(ArrayList a, String[] cols) {
        ArrayList v = (ArrayList)a.clone();
        HashMap data = null;
        int i = 0;
        int j = 0;
        i = 1;
        while (i < v.size()) {
            data = (HashMap)v.get(i);
            j = i;
            while (j > 0 && ArrayUtil.compare((HashMap)v.get(j - 1), data, cols) > 0) {
                --j;
            }
            if (j != i) {
                v.remove(i);
                v.add(j, data);
            }
            ++i;
        }
        return v;
    }

    public static ArrayList sortDesc(ArrayList a, String col) {
        return ArrayUtil.sortDesc(a, new String[]{col});
    }

    public static ArrayList sortDesc(ArrayList a, String[] cols) {
        ArrayList v = (ArrayList)a.clone();
        HashMap data = null;
        int i = 0;
        int j = 0;
        i = 1;
        while (i < v.size()) {
            data = (HashMap)v.get(i);
            j = i;
            while (j > 0 && ArrayUtil.compare((HashMap)v.get(j - 1), data, cols) < 0) {
                --j;
            }
            if (j != i) {
                v.remove(i);
                v.add(j, data);
            }
            ++i;
        }
        return v;
    }

    public static ArrayList uniq(ArrayList a, String[] cols) {
        ArrayList v = (ArrayList)a.clone();
        int i = 1;
        while (i < v.size()) {
            if (ArrayUtil.compare((HashMap)v.get(i - 1), (HashMap)v.get(i), cols) == 0) {
                v.remove(i);
                continue;
            }
            ++i;
        }
        return v;
    }

    public static double getDoubleSum(ArrayList a, String col) {
        if (a == null) {
            return -1.0;
        }
        double sum = 0.0;
        int i = 0;
        while (i < a.size()) {
            sum = Arith.add(sum, ArrayUtil.getDouble(col, i, a));
            ++i;
        }
        return sum;
    }

    public static double getIntSum(ArrayList a, String col) {
        if (a == null) {
            return -1.0;
        }
        int sum = 0;
        int i = 0;
        while (i < a.size()) {
            sum += ArrayUtil.getInt(col, i, a);
            ++i;
        }
        return sum;
    }

    public static ArrayList getGroupItems(ArrayList a, String col, Object value) {
        return ArrayUtil.getGroupItems(a, new String[]{col}, new Object[]{value});
    }

    public static ArrayList getGroupItems(ArrayList a, String[] cols, Object[] values) {
        HashMap<String, Object> h = new HashMap<String, Object>();
        ArrayList<HashMap> v = new ArrayList<HashMap>();
        int i = 0;
        while (i < cols.length) {
            h.put(cols[i].toLowerCase(), values[i]);
            ++i;
        }
        i = 0;
        while (i < a.size()) {
            HashMap h2 = (HashMap)a.get(i);
            if (ArrayUtil.compare(h, h2, cols) == 0) {
                v.add(h2);
            }
            ++i;
        }
        return v;
    }

    public static ArrayList getCol(ArrayList a, String col) {
        ArrayList<Object> v = new ArrayList<Object>();
        int i = 0;
        while (i < a.size()) {
            v.add(ArrayUtil.getObject(col, i, a));
            ++i;
        }
        return v;
    }
}

