/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ui.DataDialog;
import ui.TableLayout;
import util.TimeUtil;

public class DatePicker
extends JComboBox {
    private CalendarDialog gCal;
    private boolean gMultiSelect;

    public DatePicker(DataDialog d, Timestamp start_date, boolean multi_select) {
        this.gMultiSelect = multi_select;
        this.gCal = new CalendarDialog(d, start_date, multi_select);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (DatePicker.this.isEnabled()) {
                    DatePicker.this.gCal.setVisible(true);
                }
            }
        });
    }

    public void setSelectedDates(ArrayList dates) {
        this.gCal.setSelectedDates(dates);
    }

    public ArrayList getSelectedDates() {
        return this.gCal.getSelectedDates();
    }

    class CalendarDialog
    extends DataDialog {
        public ArrayList gDateAL;
        public boolean gMultiSelect;
        private JPanel control_panel;
        private JTextField dateTF;
        private JButton confirmB;
        private JButton clearB;
        private JComboBox monthCB;
        private JSpinner yearSP;
        private JPanel weekday_panel;
        private JPanel day_panel;
        private JPanel[] p;
        private JButton[] b;
        private HandlerClass handler;
        private Color df_color;

        public CalendarDialog(DataDialog f, Timestamp start_date, boolean multi_select) {
            super(f, "\u6708\u66c6", false);
            this.gDateAL = new ArrayList();
            this.gMultiSelect = false;
            this.p = new JPanel[42];
            this.b = new JButton[31];
            this.handler = new HandlerClass();
            if (start_date != null) {
                this.addDate(TimeUtil.getStringByDate(start_date));
            }
            this.gMultiSelect = multi_select;
            this.setLayout();
            this.setEventHandler();
            this.updateList();
        }

        public void setMultiSelect(boolean multi_select) {
            this.gMultiSelect = multi_select;
        }

        public void setSelectedDates(ArrayList dates) {
            this.gDateAL = dates;
            this.updateList();
        }

        public ArrayList getSelectedDates() {
            return this.gDateAL;
        }

        public void setSelectedDates(String[] dates) {
            int i = 0;
            while (i < dates.length) {
                if (TimeUtil.isValidDateString(dates[i])) {
                    this.addDate(dates[i]);
                }
                ++i;
            }
        }

        public void setDate(String start_date) {
            if (!TimeUtil.isValidDateString(start_date)) {
                start_date = TimeUtil.getStringByDate(TimeUtil.getCurrentDate());
            }
            int y = TimeUtil.getYear(TimeUtil.getDateByString(start_date));
            int M = TimeUtil.getMonth(TimeUtil.getDateByString(start_date));
            int d = TimeUtil.getDay(TimeUtil.getDateByString(start_date));
            this.yearSP.setValue(y);
            this.monthCB.setSelectedIndex(M - 1);
            this.handler.db = d - 1;
            this.refreshPanel();
        }

        private void setLayout() {
            SpinnerNumberModel snm = new SpinnerNumberModel(new Integer(2000), new Integer(2000), new Integer(2999), new Integer(1));
            String[] month_name = new String[]{"\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708"};
            JLabel sun = new JLabel(" \u65e5");
            JLabel mon = new JLabel(" \u4e00");
            JLabel tue = new JLabel(" \u4e8c");
            JLabel wed = new JLabel(" \u4e09");
            JLabel thu = new JLabel(" \u56db");
            JLabel fri = new JLabel(" \u4e94");
            JLabel sat = new JLabel(" \u516d");
            mon.setHorizontalAlignment(0);
            tue.setHorizontalAlignment(0);
            wed.setHorizontalAlignment(0);
            thu.setHorizontalAlignment(0);
            fri.setHorizontalAlignment(0);
            sat.setHorizontalAlignment(0);
            sun.setHorizontalAlignment(0);
            sun.setForeground(Color.RED);
            sat.setForeground(Color.BLUE);
            TableLayout t = new TableLayout(this, 400, 225, 12, 5);
            this.control_panel = new JPanel();
            this.control_panel.setLayout(null);
            this.control_panel.setSize(400, 31);
            this.control_panel.setLocation(1, 1);
            this.yearSP = new JSpinner(snm);
            this.yearSP.setSize(60, 30);
            this.yearSP.setLocation(1, 0);
            this.yearSP.setFont(new Font("Arial", 0, 14));
            this.yearSP.setEditor(new JSpinner.NumberEditor(this.yearSP, "#"));
            this.monthCB = new JComboBox<String>(month_name);
            this.monthCB.setSize(91, 30);
            this.monthCB.setLocation(61, 0);
            this.monthCB.setMaximumRowCount(12);
            this.dateTF = new JTextField();
            this.dateTF.setSize(79, 30);
            this.dateTF.setLocation(152, 0);
            this.dateTF.setBackground(Color.WHITE);
            this.dateTF.setFont(new Font("Arial", 0, 14));
            this.dateTF.setEditable(false);
            this.confirmB = new JButton("\u78ba\u5b9a");
            this.confirmB.setSize(80, 30);
            this.confirmB.setLocation(231, 0);
            this.clearB = new JButton("\u6e05\u9664");
            this.clearB.setSize(80, 30);
            this.clearB.setLocation(311, 0);
            this.control_panel.add(this.yearSP);
            this.control_panel.add(this.monthCB);
            this.control_panel.add(this.dateTF);
            this.control_panel.add(this.confirmB);
            this.control_panel.add(this.clearB);
            t.add(this.control_panel);
            this.weekday_panel = new JPanel();
            this.weekday_panel.setLayout(new GridLayout(1, 7, 1, 1));
            this.weekday_panel.setSize(390, 20);
            this.weekday_panel.setLocation(1, 32);
            this.weekday_panel.add(sun);
            this.weekday_panel.add(mon);
            this.weekday_panel.add(tue);
            this.weekday_panel.add(wed);
            this.weekday_panel.add(thu);
            this.weekday_panel.add(fri);
            this.weekday_panel.add(sat);
            t.add(this.weekday_panel);
            this.day_panel = new JPanel();
            this.day_panel.setLayout(new GridLayout(6, 7, 1, 1));
            this.day_panel.setSize(390, 141);
            this.day_panel.setLocation(1, 52);
            t.add(this.day_panel);
            int x = 0;
            while (x < 42) {
                this.p[x] = new JPanel();
                this.p[x].setLayout(new GridLayout(1, 1));
                this.p[x].setBackground(Color.WHITE);
                ++x;
            }
            int i = 0;
            while (i < 31) {
                this.b[i] = new JButton();
                this.b[i].addActionListener(this.handler);
                this.b[i].setFont(new Font("Times New Roman", 0, 11));
                this.b[i].setFocusable(false);
                this.b[i].setText(Integer.toString(i + 1));
                ++i;
            }
            this.df_color = this.b[0].getBackground();
        }

        private void setEventHandler() {
            this.clearB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    CalendarDialog.this.onClear();
                }
            });
            this.confirmB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    CalendarDialog.this.onConfirm();
                }
            });
            this.monthCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    CalendarDialog.this.refreshPanel();
                }
            });
            this.yearSP.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    CalendarDialog.this.refreshPanel();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent evt) {
                    CalendarDialog.this.setDate(!CalendarDialog.this.gDateAL.isEmpty() ? (String)CalendarDialog.this.gDateAL.get(0) : "");
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                    CalendarDialog.this.updateList();
                }
            });
        }

        private void onClear() {
            this.gDateAL.clear();
            this.refreshPanel();
        }

        private void onConfirm() {
            this.dispose();
        }

        private void refreshPanel() {
            int y = (Integer)this.yearSP.getValue();
            this.day_panel.removeAll();
            this.validate();
            int x = 0;
            while (x < 42) {
                this.p[x].removeAll();
                this.day_panel.add(this.p[x]);
                this.validate();
                ++x;
            }
            GregorianCalendar cal = new GregorianCalendar(y, this.monthCB.getSelectedIndex(), 1);
            int day_of_week = cal.get(7);
            int i = 0;
            while (i < this.getDaysNo()) {
                this.p[day_of_week - 1].add(this.b[i]);
                if (this.isSelected(i + 1, this.monthCB.getSelectedIndex() + 1, y)) {
                    this.b[i].setBackground(Color.RED);
                } else {
                    this.b[i].setBackground(this.df_color);
                }
                ++day_of_week;
                ++i;
            }
            this.dateTF.setText(TimeUtil.getStringByDate(TimeUtil.getDateByDMY(this.handler.db + 1, this.monthCB.getSelectedIndex() + 1, y)));
            this.validate();
        }

        private void updateList() {
            DatePicker.this.removeAllItems();
            int i = 0;
            while (i < this.getSelectedDates().size()) {
                DatePicker.this.addItem((String)this.getSelectedDates().get(i));
                ++i;
            }
            if (DatePicker.this.getItemCount() == 0) {
                DatePicker.this.addItem("-\u6309\u6b64\u9078\u64c7-");
            }
        }

        private boolean isSelected(int day, int month, int year) {
            int k = this.gDateAL.indexOf(TimeUtil.getStringByDate(TimeUtil.getDateByDMY(day, month, year)));
            return k != -1;
        }

        private int getDaysNo() {
            int no = 31;
            int m = this.monthCB.getSelectedIndex() + 1;
            if (m == 2) {
                no = 28;
                int y = (Integer)this.yearSP.getValue();
                if (y % 400 == 0 || y % 4 == 0 && y % 100 != 0) {
                    no = 29;
                }
                this.monthCB.validate();
            }
            if (m == 4 || m == 6 || m == 9 || m == 11) {
                no = 30;
            }
            return no;
        }

        private void addDate(String d) {
            int i = 0;
            while (i < this.gDateAL.size()) {
                if (TimeUtil.getDateByString((String)this.gDateAL.get(i)).after(TimeUtil.getDateByString(d))) {
                    this.gDateAL.add(i, d);
                    return;
                }
                ++i;
            }
            this.gDateAL.add(d);
        }

        private class HandlerClass
        implements ActionListener {
            Calendar now = Calendar.getInstance();
            public int db;

            private HandlerClass() {
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                int i = 0;
                while (i < 31) {
                    if (evt.getSource() == CalendarDialog.this.b[i]) {
                        this.db = i;
                        CalendarDialog.this.dateTF.setText(TimeUtil.getStringByDate(TimeUtil.getDateByDMY(this.db + 1, CalendarDialog.this.monthCB.getSelectedIndex() + 1, (Integer)CalendarDialog.this.yearSP.getValue())));
                        if (CalendarDialog.this.b[i].getBackground() != Color.RED) {
                            CalendarDialog.this.b[i].setBackground(Color.RED);
                            if (!CalendarDialog.this.gMultiSelect && !CalendarDialog.this.gDateAL.isEmpty()) {
                                CalendarDialog.this.gDateAL.clear();
                            }
                            CalendarDialog.this.addDate(CalendarDialog.this.dateTF.getText());
                        } else {
                            CalendarDialog.this.b[i].setBackground(CalendarDialog.this.df_color);
                            int k = CalendarDialog.this.gDateAL.indexOf(CalendarDialog.this.dateTF.getText());
                            if (k != -1) {
                                CalendarDialog.this.gDateAL.remove(k);
                            }
                        }
                        CalendarDialog.this.validate();
                        if (CalendarDialog.this.gMultiSelect) {
                            break;
                        }
                    } else if (!CalendarDialog.this.gMultiSelect) {
                        CalendarDialog.this.b[i].setBackground(CalendarDialog.this.df_color);
                    }
                    ++i;
                }
            }
        }
    }
}

