/*
 * Decompiled with CFR 0.152.
 */
package system;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import system.Constants;
import system.MsgOutDialog;
import util.TimeUtil;
import util.WinUtil;

public final class MsgOut
implements Thread.UncaughtExceptionHandler {
    @Override
    public void uncaughtException(Thread aThread, Throwable aThrowable) {
        String msg = MsgOut.getStackTrace(aThrowable);
        MsgOut.write(msg);
    }

    private static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static void write(String msg) {
        msg = "[" + TimeUtil.getLocalTimestamp().toString() + "] " + msg + System.getProperty("line.separator");
        if (Constants.ERR_MSG_OUT.indexOf("stdout") >= 0) {
            new MsgOutDialog(msg);
        }
        if (Constants.ERR_MSG_OUT.indexOf("file") >= 0) {
            try {
                FileWriter f = new FileWriter("error.txt", true);
                f.write(msg);
                f.close();
            }
            catch (IOException e) {
                WinUtil.showMessage(null, "Unable to write error.txt: " + e.toString());
            }
        }
        if (Constants.ERR_MSG_OUT.indexOf("stdout") <= 0 && Constants.ERR_MSG_OUT.indexOf("file") <= 0) {
            System.err.println(msg);
        }
    }

    public static void write(Exception e) {
        MsgOut.write("[" + TimeUtil.getLocalTimestamp().toString() + "] " + MsgOut.getStackTrace(e) + System.getProperty("line.separator"));
    }
}

