/*
 * Decompiled with CFR 0.152.
 */
package member;

import database.DBUtil;
import member.Member;
import member.MemberGroup;
import member.MemberRemark;
import printout.xls.ExcelFormat;
import printout.xls.ExcelPrintout;
import system.Lang;
import system.SystemCode;
import util.RecordList;
import util.TimeUtil;
import util.Tools;

public class MemberReport {
    private static int gFixedColNum = 23;
    private int gMemberGroupSeq;
    private boolean gShowExpiredMember;

    public MemberReport() {
        this.genReport();
    }

    public MemberReport(int member_group_seq, boolean show_expired_member) {
        this.gMemberGroupSeq = member_group_seq;
        this.gShowExpiredMember = show_expired_member;
        this.genReport();
    }

    private void genReport() {
        RecordList remarkCols = MemberRemark.getRemarkCols();
        RecordList members = this.getMembers();
        RecordList remarks = this.getRemarks();
        int[] widths = new int[gFixedColNum + remarkCols.size()];
        widths[0] = 32;
        widths[1] = 22;
        widths[2] = 22;
        widths[3] = 45;
        widths[4] = 30;
        widths[5] = 12;
        widths[6] = 25;
        widths[7] = 12;
        widths[8] = 70;
        widths[9] = 30;
        widths[10] = 30;
        widths[11] = 60;
        widths[12] = 25;
        widths[13] = 30;
        widths[14] = 30;
        widths[15] = 20;
        widths[16] = 25;
        widths[17] = 25;
        widths[18] = 35;
        widths[19] = 35;
        widths[20] = 20;
        widths[21] = 25;
        widths[22] = 25;
        int i = 0;
        while (i < remarkCols.size()) {
            widths[MemberReport.gFixedColNum + i] = 30;
            ++i;
        }
        ExcelPrintout p = new ExcelPrintout(ExcelFormat.PA4R, widths);
        p.addHeader(Lang.set("\u6703\u773e\u8cc7\u6599\u5831\u8868"), new String[]{String.valueOf(Lang.set("\u6703\u773e\u7fa4\u7d44: ")) + MemberGroup.getName(this.gMemberGroupSeq), Lang.set("\u986f\u793a\u5728\u7fa4\u7d44\u4e2d\u5931\u6548\u6703\u773e: " + (this.gShowExpiredMember ? "\u662f" : "\u5426"))});
        int row = p.getRowNumAfterHeader();
        p.addCell(0, row, Lang.set("\u6703\u773e\u7de8\u865f"), p.TL);
        p.addCell(1, row, Lang.set("\u59d3\u540d1"), p.TL);
        p.addCell(2, row, Lang.set("\u59d3\u540d2"), p.TL);
        p.addCell(3, row, Lang.set("\u5b98\u65b9\u59d3\u540d"), p.TL);
        p.addCell(4, row, Lang.set("\u8eab\u4efd\u8b49\u865f\u78bc"), p.TL);
        p.addCell(5, row, Lang.set("\u6027\u5225"), p.TL);
        p.addCell(6, row, Lang.set("\u51fa\u751f\u65e5\u671f"), p.TL);
        p.addCell(7, row, Lang.set("\u6b72\u6578"), p.TL);
        p.addCell(8, row, Lang.set("\u4f4f\u5740"), p.TL);
        p.addCell(9, row, Lang.set("\u96fb\u8a711"), p.TL);
        p.addCell(10, row, Lang.set("\u96fb\u8a712"), p.TL);
        p.addCell(11, row, Lang.set("\u96fb\u90f5"), p.TL);
        p.addCell(12, row, Lang.set("\u8077\u696d"), p.TL);
        p.addCell(13, row, Lang.set("\u5b78\u6b77"), p.TL);
        p.addCell(14, row, Lang.set("\u8208\u8da3"), p.TL);
        p.addCell(15, row, Lang.set("\u5a5a\u59fb\u72c0\u6cc1"), p.TL);
        p.addCell(16, row, Lang.set("\u53d7\u6d17\u65e5\u671f"), p.TL);
        p.addCell(17, row, Lang.set("\u52a0\u5165\u6559\u6703\u65e5\u671f"), p.TL);
        p.addCell(18, row, Lang.set("\u81ea\u5b9a\u767b\u5165\u7de8\u865f"), p.TL);
        p.addCell(19, row, Lang.set("\u5bc6\u78bc"), p.TL);
        p.addCell(20, row, Lang.set("\u6536\u64da\u5f62\u5f0f"), p.TL);
        p.addCell(21, row, Lang.set("\u751f\u6548\u65e5\u671f"), p.TL);
        p.addCell(22, row, Lang.set("\u7d42\u6b62\u65e5\u671f"), p.TL);
        int i2 = 0;
        while (i2 < remarkCols.size()) {
            p.addCell(gFixedColNum + i2, row, remarkCols.getS("name", i2), p.TL);
            ++i2;
        }
        i2 = 0;
        while (i2 < members.size()) {
            members.setCurrentRow(i2);
            p.addCell(0, ++row, members.getS("member_id"));
            p.addCell(1, row, members.getS("name1"));
            p.addCell(2, row, members.getS("name2"));
            p.addCell(3, row, members.getS("official_name"));
            p.addCell(4, row, members.getS("hkid"));
            p.addCell(5, row, SystemCode.getGender(members.getS("gender")));
            p.addCell(6, row, TimeUtil.getStringByDate(members.getT("dob")));
            p.addCell(7, row, TimeUtil.getAge(members.getT("dob")));
            p.addCell(8, row, members.getS("address"));
            p.addCell(9, row, members.getS("tel1"));
            p.addCell(10, row, members.getS("tel2"));
            p.addCell(11, row, members.getS("email"));
            p.addCell(12, row, members.getS("career"));
            p.addCell(13, row, members.getS("education"));
            p.addCell(14, row, members.getS("hobby"));
            p.addCell(15, row, SystemCode.getMartial_status(members.getS("marital_status")));
            p.addCell(16, row, TimeUtil.getStringByDate(members.getT("baptist_date")));
            p.addCell(17, row, TimeUtil.getStringByDate(members.getT("church_join_date")));
            p.addCell(18, row, members.getS("login_id"));
            p.addCell(19, row, Lang.set(members.getS("password").equals("") ? "\u672a\u8a2d\u5b9a" : "\u5df2\u8a2d\u5b9a"));
            p.addCell(20, row, Lang.set(Tools.getStatusName(Member.RECEIPT_TYPE_MAP, members.getS("receipt_type"))));
            p.addCell(21, row, TimeUtil.getStringByDate(members.getT("start_date")));
            p.addCell(22, row, TimeUtil.getStringByDate(members.getT("end_date")));
            RecordList mrs = remarks.getGroupItems("member_seq", members.getI("member_seq"));
            int j = 0;
            while (j < remarkCols.size()) {
                int k = mrs.indexOf("code", remarkCols.getS("code", j));
                String r = k != -1 ? mrs.getS("remark", k) : "";
                p.addCell(gFixedColNum + j, row, r);
                ++j;
            }
            ++i2;
        }
        p.genPrintout();
    }

    private RecordList getMembers() {
        String sql = "select mb.*,mgm.start_date,mgm.end_date from member mb,member_group_member mgm where mgm.member_group_seq=?" + (this.gShowExpiredMember ? "" : " and mgm.end_date>=curdate()") + " and mgm.member_seq=mb.member_seq" + " order by mb.member_id";
        return DBUtil.run(sql, this.gMemberGroupSeq);
    }

    private RecordList getRemarks() {
        String sql = "select mbr.* from member_remark mbr,member_group_member mgm where mgm.member_group_seq=? and mgm.member_seq=mbr.member_seq";
        return DBUtil.run("select mbr.* from member_remark mbr,member_group_member mgm where mgm.member_group_seq=? and mgm.member_seq=mbr.member_seq", this.gMemberGroupSeq);
    }
}

