/*
 * Decompiled with CFR 0.152.
 */
package member;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.Barcode39;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import member.Member;
import member.MemberRemark;
import printout.pdf.PDFPrintout;
import util.ArrayListCreator;
import util.ArrayUtil;
import util.RecordList;
import util.Tools;

public class MemberLabelPrintout {
    private float g_MM2PT = 2.8346f;
    private float g_A4_width = 210.0f;
    private float g_A4_height = 297.0f;
    private ArrayList gMembers = null;
    private RecordList gInfos;
    private RecordList gRemarkCols;
    private Properties g_Config = null;
    private String g_Output_file = "";
    private String gSorting;
    private int gCellx;
    private int gCelly;
    private int gCopy;
    private int gThreshold;
    private boolean gPrintHorizontal;
    private String gPrintGroup;
    private int gEmptyCell;
    private float g_Margin_top;
    private float g_Margin_bottom;
    private float gHPadding = 0.0f;
    private float gVPadding = 0.0f;
    private boolean gUseBorder;
    private boolean gUseTestBorder;
    private int gBorderSize = 0;
    private int gTestBorderSize = 0;
    public static String SORT__NAME1 = "name1";
    public static String SORT__NAME2 = "name2";
    public static String SORT__OFFICIAL_NAME = "official_name";
    public static String SORT__MEMBER_ID = "member_id";
    public static String INFO__NAME1 = "NAME1";
    public static String INFO__NAME2 = "NAME2";
    public static String INFO__OFFICIAL_NAME = "OFFICIAL_NAME";
    public static String INFO__ADDRESS = "ADDRESS";
    public static String INFO__MEMBER_ID = "MEMBER_ID";
    public static String INFO__BARCODE = "BARCODE";
    public static String ALIGN__LEFT = "LEFT";
    public static String ALIGN__CENTER = "CENTER";
    public static String ALIGN__RIGHT = "RIGHT";
    public static String PRINT_GROUP__CONT = "CONT";
    public static String PRINT_GROUP__SINGLE = "SIGNLE";
    public static String PRINT_GROUP__PAGE = "PAGE";
    public static String PRINT_GROUP__PARA = "PARA";
    public static String PRINT_GROUP__PARACUT = "PARACUT";

    public MemberLabelPrintout(ArrayList member_seqs, RecordList infos, String cellx, String celly, String vPadding, String hPadding, String copy, String emptyCell, String threshold, String sorting, String printGroup, boolean printHorizontal, boolean useBorder) {
        this.gMembers = Member.getMemberCardInfo(member_seqs, sorting);
        this.gInfos = infos;
        this.gCellx = Integer.parseInt(cellx);
        this.gCelly = Integer.parseInt(celly);
        this.gVPadding = Integer.parseInt(vPadding);
        this.gHPadding = Integer.parseInt(hPadding);
        this.gCopy = Integer.parseInt(copy);
        this.gEmptyCell = Integer.parseInt(emptyCell);
        this.gThreshold = Integer.parseInt(threshold);
        this.gSorting = sorting;
        this.gPrintGroup = printGroup;
        this.gPrintHorizontal = printHorizontal;
        this.gUseBorder = useBorder;
        this.g_Output_file = String.valueOf(System.getProperty("java.io.tmpdir")) + String.valueOf(System.currentTimeMillis()) + ".pdf";
        this.g_Config = new Properties();
        try {
            this.g_Config.load(new FileInputStream("config/member_label_config.txt"));
        }
        catch (IOException e) {
            Tools.writeError(e.getMessage());
        }
        this.gUseTestBorder = this.getBooleanFromConfig("use_test_border");
        this.g_Margin_top = this.getFloatFromConfig("margin_top");
        this.g_Margin_bottom = this.getFloatFromConfig("margin_bottom");
    }

    public boolean genFile() {
        Document document = new Document(PageSize.A4, 0.0f, 0.0f, this.g_Margin_top * this.g_MM2PT, this.g_Margin_bottom * this.g_MM2PT);
        try {
            BaseFont bf = BaseFont.createFont((String)PDFPrintout.getFullFontPath(), (String)"Identity-H", (boolean)true);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(this.g_Output_file));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfPTable page_table = new PdfPTable(this.gCellx);
            page_table.setTotalWidth(this.g_A4_width * this.g_MM2PT);
            page_table.setWidthPercentage(100.0f);
            page_table.setLockedWidth(true);
            page_table.getDefaultCell().setPadding(0.0f);
            if (this.gUseTestBorder) {
                this.gTestBorderSize = 1;
            }
            if (this.gUseBorder) {
                this.gBorderSize = 1;
            }
            this.addCopy();
            if (!this.gPrintGroup.equals(PRINT_GROUP__CONT)) {
                ArrayList v;
                if (this.gPrintGroup.equals(PRINT_GROUP__SINGLE)) {
                    v = new ArrayList();
                    int i = 0;
                    while (i < this.gMembers.size()) {
                        v.add(this.gMembers.get(i));
                        MemberLabelPrintout.addRemainCell(v, this.gCellx * this.gCelly);
                        ++i;
                    }
                    this.gMembers = v;
                } else {
                    ArrayList r;
                    v = new ArrayList();
                    int group_seq = 0;
                    String ss = null;
                    int i = 0;
                    while (i < this.gMembers.size()) {
                        String data = String.valueOf(ArrayUtil.getString(this.gSorting, i, this.gMembers).trim()) + " ";
                        String char1 = Character.toString(data.charAt(0));
                        if (ss == null || ss.equals(char1)) {
                            ArrayUtil.setInt("print_group_seq", group_seq, i, this.gMembers);
                        } else {
                            ArrayUtil.setInt("print_group_seq", ++group_seq, i, this.gMembers);
                        }
                        ss = char1;
                        ++i;
                    }
                    if (this.gPrintGroup.equals(PRINT_GROUP__PARA)) {
                        i = 0;
                        while (i <= group_seq) {
                            r = ArrayUtil.getGroupItems(this.gMembers, "print_group_seq", i);
                            MemberLabelPrintout.addRemainCell(r, this.gPrintHorizontal ? this.gCellx : this.gCelly);
                            v.addAll(r);
                            ++i;
                        }
                        this.gMembers = v;
                    } else if (this.gPrintGroup.equals(PRINT_GROUP__PAGE)) {
                        i = 0;
                        while (i <= group_seq) {
                            r = ArrayUtil.getGroupItems(this.gMembers, "print_group_seq", i);
                            MemberLabelPrintout.addRemainCell(r, this.gCellx * this.gCelly);
                            v.addAll(r);
                            ++i;
                        }
                        this.gMembers = v;
                    } else if (this.gPrintGroup.equals(PRINT_GROUP__PARACUT)) {
                        i = 0;
                        while (i <= group_seq) {
                            r = ArrayUtil.getGroupItems(this.gMembers, "print_group_seq", i);
                            if (r.size() > this.gThreshold) {
                                MemberLabelPrintout.addRemainCell(r, this.gCellx * this.gCelly);
                                v.addAll(r);
                            }
                            ++i;
                        }
                        i = 0;
                        while (i <= group_seq) {
                            r = ArrayUtil.getGroupItems(this.gMembers, "print_group_seq", i);
                            if (r.size() <= this.gThreshold) {
                                MemberLabelPrintout.addRemainCell(r, this.gPrintHorizontal ? this.gCellx : this.gCelly);
                                v.addAll(r);
                            }
                            ++i;
                        }
                        this.gMembers = v;
                    }
                }
            }
            this.addEmptyCell();
            MemberLabelPrintout.addRemainCell(this.gMembers, this.gCellx * this.gCelly);
            if (!this.gPrintHorizontal) {
                this.swapVertical();
            }
            this.gInfos = this.gInfos.getGroupItems("selected", "Y");
            this.gInfos.sort("order");
            this.gRemarkCols = MemberRemark.getRemarkCols();
            int i = 0;
            while (i < this.gMembers.size()) {
                int member_seq = ArrayUtil.getInt("MEMBER_SEQ", i, this.gMembers);
                String member_id = ArrayUtil.getString("MEMBER_ID", i, this.gMembers);
                String name1 = ArrayUtil.getString("NAME1", i, this.gMembers);
                String name2 = ArrayUtil.getString("NAME2", i, this.gMembers);
                String official_name = ArrayUtil.getString("OFFICIAL_NAME", i, this.gMembers);
                String address = ArrayUtil.getString("ADDRESS", i, this.gMembers);
                MemberRemark mr = new MemberRemark(member_seq);
                RecordList mrs = mr.getItems();
                PdfPTable cell_table = new PdfPTable(1);
                cell_table.setTotalWidth(this.g_A4_width / (float)this.gCellx * this.g_MM2PT);
                cell_table.setWidthPercentage(100.0f);
                cell_table.setLockedWidth(true);
                cell_table.getDefaultCell().setPadding(0.0f);
                cell_table.getDefaultCell().setBorderWidth((float)this.gTestBorderSize);
                int j = 0;
                while (j < this.gInfos.size()) {
                    PdfPCell cell;
                    this.gInfos.setCurrentRow(j);
                    String code = this.gInfos.getS("code");
                    float point = Float.parseFloat(this.gInfos.getS("point"));
                    String align = this.gInfos.getS("align");
                    int cell_align = -1;
                    if (align.equals(ALIGN__LEFT)) {
                        cell_align = 0;
                    } else if (align.equals(ALIGN__CENTER)) {
                        cell_align = 1;
                    } else if (align.equals(ALIGN__RIGHT)) {
                        cell_align = 2;
                    }
                    String data = "";
                    boolean isTextCell = true;
                    if (code.equals(INFO__NAME1)) {
                        data = name1.isEmpty() ? " " : name1;
                    } else if (code.equals(INFO__NAME2)) {
                        data = name2.isEmpty() ? " " : name2;
                    } else if (code.equals(INFO__OFFICIAL_NAME)) {
                        data = official_name.isEmpty() ? " " : official_name;
                    } else if (code.equals(INFO__MEMBER_ID)) {
                        data = member_id.isEmpty() ? " " : member_id;
                    } else if (code.equals(INFO__ADDRESS)) {
                        data = address.isEmpty() ? " " : address;
                    } else if (code.equals(INFO__BARCODE)) {
                        isTextCell = false;
                    } else {
                        int k = mrs.indexOf(MemberRemark.CODE, code);
                        data = k == -1 ? " " : mrs.getS(MemberRemark.REMARK, k);
                        String string = data = data.isEmpty() ? " " : data;
                    }
                    if (isTextCell) {
                        cell = new PdfPCell(new Phrase(data, new Font(bf, point)));
                    } else {
                        Barcode39 bc = new Barcode39();
                        bc.setCode(member_id.replaceAll("([a-z])", "+$1").toUpperCase());
                        bc.setX(0.8f);
                        bc.setN(2.0f);
                        bc.setBarHeight(point);
                        bc.setSize(0.0f);
                        bc.setFont(null);
                        Color bar_color = member_id.equals("") ? Color.white : null;
                        cell = new PdfPCell(bc.createImageWithBarcode(cb, bar_color, null));
                    }
                    cell.setHorizontalAlignment(cell_align);
                    cell.setVerticalAlignment(1);
                    cell.setBorderWidth((float)this.gTestBorderSize);
                    cell.setPaddingLeft(this.gHPadding);
                    cell.setPaddingRight(this.gHPadding);
                    cell.setPaddingTop(this.gVPadding);
                    cell.setPaddingBottom(this.gVPadding);
                    cell_table.addCell(cell);
                    ++j;
                }
                PdfPCell page_cell = new PdfPCell(cell_table);
                float page_cell_height = (this.g_A4_height - this.g_Margin_top - this.g_Margin_bottom) / (float)this.gCelly;
                page_cell.setFixedHeight(page_cell_height * this.g_MM2PT);
                page_cell.setBorderWidth((float)this.gBorderSize);
                page_cell.setVerticalAlignment(5);
                page_table.addCell(page_cell);
                ++i;
            }
            document.add((Element)page_table);
        }
        catch (DocumentException e1) {
            Tools.writeError(e1.getMessage());
        }
        catch (IOException e2) {
            Tools.writeError(e2.getMessage());
        }
        document.close();
        try {
            Runtime.getRuntime().exec("cmd.exe /c \"" + this.g_Output_file + "\"");
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
        return true;
    }

    private void addEmptyCell() {
        if (this.gEmptyCell == 0) {
            return;
        }
        ArrayListCreator ac = new ArrayListCreator(new String[]{"member_seq", "member_id", "name1", "name2", "address"});
        int i = 0;
        while (i < this.gEmptyCell) {
            ac.add(new Object[]{new Integer(-1), "", "", "", ""});
            ++i;
        }
        this.gMembers.addAll(0, ac.getArrayList());
    }

    private void addCopy() {
        if (this.gCopy == 1) {
            return;
        }
        ArrayList<HashMap> v = new ArrayList<HashMap>();
        int size = this.gMembers.size();
        int i = 0;
        while (i < size) {
            HashMap h = (HashMap)this.gMembers.get(i);
            int j = 0;
            while (j < this.gCopy) {
                v.add(h);
                ++j;
            }
            ++i;
        }
        this.gMembers = v;
    }

    private static void addRemainCell(ArrayList members, int total_cell) {
        int remain_cell = total_cell - members.size() % total_cell;
        if (remain_cell == total_cell) {
            return;
        }
        ArrayListCreator ac = new ArrayListCreator(new String[]{"member_seq", "member_id", "name1", "name2", "address"});
        int i = 0;
        while (i < remain_cell) {
            ac.add(new Object[]{new Integer(-1), "", "", "", ""});
            ++i;
        }
        members.addAll(ac.getArrayList());
    }

    private void swapVertical() {
        ArrayList v = (ArrayList)this.gMembers.clone();
        int cell_per_page = this.gCellx * this.gCelly;
        int total_page = this.gMembers.size() / cell_per_page;
        int j = 0;
        while (j < total_page) {
            int i = 0;
            while (i < cell_per_page) {
                HashMap h = (HashMap)this.gMembers.get(j * cell_per_page + i);
                int vertical_pos = j * cell_per_page + (this.gCellx * (i % this.gCelly) + i / this.gCelly);
                v.set(vertical_pos, h);
                ++i;
            }
            ++j;
        }
        this.gMembers = v;
    }

    private int getIntFromConfig(String param) {
        String value = this.g_Config.getProperty(param);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return 0;
    }

    private float getFloatFromConfig(String param) {
        String value = this.g_Config.getProperty(param);
        if (value != null) {
            return Float.valueOf(value).floatValue();
        }
        return 0.0f;
    }

    private String getStringFromConfig(String param) {
        String value = this.g_Config.getProperty(param);
        if (value != null) {
            return value;
        }
        return "";
    }

    private boolean getBooleanFromConfig(String param) {
        String value = this.g_Config.getProperty(param);
        return value != null && value.equals("Y");
    }
}

