/*
 * Decompiled with CFR 0.152.
 */
package attendance;

import attendance.Activity;
import attendance.ActivityMemberGroup;
import attendance.Attendance;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import member.Member;
import member.MemberGroup;
import system.MasterCode;
import system.User;
import ui.ComboBoxNV;
import ui.DataDialog;
import ui.ScrollList;
import ui.ScrollList2;
import ui.TableLayout;
import ui.TimeTextField;
import util.ArrayUtil;
import util.ComparableHashMap;
import util.RecordList;
import util.TimeUtil;
import util.Validation;
import util.WinUtil;
import venue.Venue;

public class AttendanceListDialog
extends DataDialog {
    private int g_Activity_seq = -1;
    private Activity g_Activity;
    private ScrollList itemSL;
    private RecordList g_Items;
    private ScrollList2 groupSL;
    private RecordList g_Amgs;
    private JButton saveB;
    private JButton cancelB;
    private JButton addB;
    private JButton delB;
    private JButton deleteAllB;

    public AttendanceListDialog(DataDialog dialog, int activity_seq) {
        super(dialog, "\u51fa\u5e2d\u8a18\u9304\u5217\u8868", false);
        this.g_Activity_seq = activity_seq;
        this.g_Activity = new Activity(activity_seq);
        this.g_Items = Attendance.getAttendanceList(activity_seq);
        this.g_Amgs = new ActivityMemberGroup(activity_seq).getItems();
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        this.addB = new JButton("\u52a0\u5165\u9ede\u5230");
        this.delB = new JButton("\u522a\u9664\u9ede\u5230");
        this.saveB = new JButton("\u78ba\u5b9a");
        this.cancelB = new JButton("\u53d6\u6d88");
        this.deleteAllB = new JButton("\u6e05\u9664\u6240\u6709\u8a18\u9304");
        boolean enabled = User.hasPrivilege("activityModify");
        this.addB.setEnabled(enabled);
        this.delB.setEnabled(enabled);
        this.saveB.setEnabled(enabled);
        this.deleteAllB.setEnabled(enabled);
        TableLayout t = new TableLayout(this, 600, 600, 5, 10);
        int[] nArray = new int[5];
        nArray[0] = 80;
        nArray[1] = 120;
        nArray[2] = 100;
        nArray[3] = 100;
        t.getClass();
        nArray[4] = 0;
        t.addTable(nArray, new int[]{15, 15, 15, 15});
        JLabel jLabel = new JLabel("");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        JLabel jLabel2 = new JLabel("");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 1, 0, 20, 0, 100, -1);
        JLabel jLabel3 = new JLabel("\u805a\u6703\u985e\u5225:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 1, 1, 0);
        JLabel jLabel4 = new JLabel(MasterCode.getName(this.g_Activity.getType()));
        t.getClass();
        t.addCell(jLabel4, 1, 1, 20, 0);
        JLabel jLabel5 = new JLabel("\u805a\u6703\u540d\u7a31:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 0, 2, 1, 0);
        JLabel jLabel6 = new JLabel(this.g_Activity.getName());
        t.getClass();
        t.getClass();
        t.addCell(jLabel6, 1, 2, 20, 0, 140, -1);
        JLabel jLabel7 = new JLabel("\u5730\u9ede:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel7, 2, 2, 1, 0);
        JLabel jLabel8 = new JLabel(new Venue(this.g_Activity.getVenue_seq()).getName());
        t.getClass();
        t.getClass();
        t.addCell(jLabel8, 3, 2, 20, 0, 140, -1);
        JLabel jLabel9 = new JLabel("\u65e5\u671f:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel9, 0, 3, 1, 0);
        JLabel jLabel10 = new JLabel(TimeUtil.getStringByDate(this.g_Activity.getDate()));
        t.getClass();
        t.addCell(jLabel10, 1, 3, 20, 0);
        JLabel jLabel11 = new JLabel("\u8b1b\u54e1:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel11, 2, 3, 1, 0);
        JLabel jLabel12 = new JLabel(this.g_Activity.getLecturer());
        t.getClass();
        t.getClass();
        t.addCell(jLabel12, 3, 3, 20, 0, 140, -1);
        int[] nArray2 = new int[6];
        nArray2[0] = 80;
        nArray2[1] = 50;
        nArray2[2] = 100;
        nArray2[3] = 50;
        nArray2[4] = 100;
        t.getClass();
        nArray2[5] = 0;
        t.addTable(nArray2, new int[]{15, 15});
        JLabel jLabel13 = new JLabel("\u805a\u6703\u958b\u59cb\u6642\u9593:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel13, 0, 0, 1, 0);
        JLabel jLabel14 = new JLabel(TimeUtil.getStringByTime(this.g_Activity.getStart_time()));
        t.getClass();
        t.addCell(jLabel14, 1, 0, 20, 0);
        JLabel jLabel15 = new JLabel("\u805a\u6703\u7d50\u675f\u6642\u9593:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel15, 2, 0, 1, 0);
        JLabel jLabel16 = new JLabel(TimeUtil.getStringByTime(this.g_Activity.getEnd_time()));
        t.getClass();
        t.addCell(jLabel16, 3, 0, 20, 0);
        JLabel jLabel17 = new JLabel("\u9072\u5230\u6642\u9593:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel17, 4, 0, 1, 0);
        JLabel jLabel18 = new JLabel(TimeUtil.getStringByTime(this.g_Activity.getLate_time()));
        t.getClass();
        t.addCell(jLabel18, 5, 0, 20, 0);
        JLabel jLabel19 = new JLabel("\u958b\u59cb\u9ede\u5230\u6642\u9593:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel19, 0, 1, 1, 0);
        JLabel jLabel20 = new JLabel(TimeUtil.getStringByTime(this.g_Activity.getStart_record_time()));
        t.getClass();
        t.addCell(jLabel20, 1, 1, 20, 0);
        JLabel jLabel21 = new JLabel("\u7d50\u675f\u9ede\u5230\u6642\u9593:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel21, 2, 1, 1, 0);
        JLabel jLabel22 = new JLabel(TimeUtil.getStringByTime(this.g_Activity.getEnd_record_time()));
        t.getClass();
        t.addCell(jLabel22, 3, 1, 20, 0);
        int[] nArray3 = new int[2];
        nArray3[0] = 80;
        t.getClass();
        nArray3[1] = 0;
        t.addTable(nArray3, new int[]{15});
        JLabel jLabel23 = new JLabel("\u5099\u8a3b:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel23, 0, 0, 1, 0);
        JLabel jLabel24 = new JLabel(this.g_Activity.getRemark());
        t.getClass();
        t.getClass();
        t.addCell(jLabel24, 1, 0, 20, 0, 360, -1);
        int total_attendance = 0;
        int total_late = 0;
        RecordList uniq_items = this.g_Items.uniq(new String[]{"member_seq"});
        int i = 0;
        while (i < uniq_items.size()) {
            Timestamp in_time = uniq_items.getT(Attendance.IN_TIME, i);
            if (in_time != null) {
                ++total_attendance;
                if (in_time.after(this.g_Activity.getLate_time())) {
                    ++total_late;
                }
            }
            ++i;
        }
        int[] nArray4 = new int[5];
        nArray4[0] = 80;
        nArray4[1] = 100;
        nArray4[2] = 80;
        nArray4[3] = 150;
        t.getClass();
        nArray4[4] = 0;
        t.addTable(nArray4, new int[]{25});
        JLabel jLabel25 = new JLabel("\u51fa\u5e2d\u4eba\u6578:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel25, 0, 0, 1, 0);
        JLabel jLabel26 = new JLabel(new Integer(total_attendance).toString());
        t.getClass();
        t.getClass();
        t.addCell(jLabel26, 1, 0, 20, 0, 360, -1);
        JLabel jLabel27 = new JLabel("\u9072\u5230\u4eba\u6578:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel27, 2, 0, 1, 0);
        JLabel jLabel28 = new JLabel(new Integer(total_late).toString());
        t.getClass();
        t.getClass();
        t.addCell(jLabel28, 3, 0, 20, 0, 360, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.addB, 4, 0, -1, 0, 80, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.delB, 4, 0, 1, 0, 80, -1);
        boolean[] blArray = new boolean[5];
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        this.itemSL = new ScrollList(560, 255, this.g_Items, new int[]{125, 220, 50, 45, 105}, new String[]{"\u6703\u773e\u7de8\u865f", "\u59d3\u540d", "\u6642\u9593", "\u8c41\u514d", "\u5099\u8a3b"}, new String[]{"member_id", "display_name", "in_time", "exempt", "remark"}, blArray);
        this.itemSL.setEditing_mode(true);
        this.itemSL.setTimeTextFieldColumn(Attendance.IN_TIME, this.g_Activity.getDate());
        this.itemSL.setCheckBoxYNColumn(Attendance.EXEMPT, "Y", "N");
        t.addYSpace(10);
        int[] nArray5 = new int[1];
        t.getClass();
        nArray5[0] = 0;
        t.addTable(nArray5, new int[]{255});
        t.getClass();
        t.getClass();
        t.addCell(this.itemSL, 0, 0, -1, -1);
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.groupSL = new ScrollList2(560, 100, this.g_Amgs, new int[]{275, 80}, new String[]{"\u6703\u773e\u7fa4\u7d44", "\u984d\u5916\u51fa\u5e2d\u4eba\u6b21"}, new String[]{"name", ActivityMemberGroup.HEADCOUNT}, blArray2);
        this.groupSL.setEditing_mode(true);
        this.groupSL.setIntegerTextFieldColumn(ActivityMemberGroup.HEADCOUNT);
        t.addYSpace(10);
        int[] nArray6 = new int[1];
        t.getClass();
        nArray6[0] = 0;
        t.addTable(nArray6, new int[]{100});
        t.getClass();
        t.getClass();
        t.addCell(this.groupSL, 0, 0, -1, -1);
        t.addYSpace(15);
        t.addTable(new int[]{510, 10, 80}, new int[]{30});
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.deleteAllB, 0, 0, -1, 0, 100, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0);
    }

    public void setEventHandler() {
        this.deleteAllB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendanceListDialog.this.onDeleteAll(evt);
            }
        });
        this.addB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendanceListDialog.this.onAdd(evt);
            }
        });
        this.delB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendanceListDialog.this.onDel(evt);
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendanceListDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendanceListDialog.this.onCancel(evt);
            }
        });
    }

    private void onFinishAddMember(RecordList members, Timestamp in_time) {
        ArrayList newMembers = new ArrayList();
        int i = 0;
        while (i < members.size()) {
            members.setCurrentRow(i);
            int member_seq = members.getI("member_seq");
            int j = 0;
            while (j < this.g_Items.size()) {
                if (this.g_Items.getI("member_seq", j) == member_seq) {
                    Object obj = this.g_Items.get(j);
                    this.g_Items.remove(j);
                    newMembers.add(obj);
                    --j;
                }
                ++j;
            }
            ComparableHashMap h = new ComparableHashMap();
            h.put(Attendance.MEMBER_SEQ, new Integer(members.getI("member_seq")));
            h.put("member_id", members.getS("member_id"));
            h.put("display_name", members.getS("display_name"));
            h.put(Attendance.IN_TIME, in_time);
            h.put(Attendance.EXEMPT, "N");
            h.put(Attendance.REMARK, "");
            newMembers.add(h);
            ++i;
        }
        this.g_Items.addAll(newMembers);
        this.itemSL.fireDataChanged();
    }

    private void onAdd(ActionEvent evt) {
        ALAddMemberDialog d = new ALAddMemberDialog(this, this.g_Items);
    }

    private void onDel(ActionEvent evt) {
        int sel_row = this.itemSL.getSelectedRow();
        if (sel_row == -1) {
            return;
        }
        this.itemSL.getTableData().remove(sel_row);
        this.itemSL.fireDataChanged();
    }

    public void onDeleteAll(ActionEvent evt) {
        if (WinUtil.getConfirm(this, "\u78ba\u5b9a\u6e05\u9664\u6240\u6709\u8a18\u9304?")) {
            this.g_Items = new RecordList();
            this.itemSL.refreshTable(this.g_Items);
            int i = 0;
            while (i < this.g_Amgs.size()) {
                this.g_Amgs.setI(ActivityMemberGroup.HEADCOUNT, 0, i);
                ++i;
            }
            this.groupSL.fireDataChanged();
        }
    }

    public void onSave(ActionEvent evt) {
        Validation validation = new Validation();
        int i = 0;
        while (i < this.g_Items.size()) {
            this.g_Items.setCurrentRow(i);
            String member_id = this.g_Items.getS("member_id");
            Timestamp in_time = this.g_Items.getT("in_time");
            String exempt = this.g_Items.getS("exempt");
            String remark = this.g_Items.getS("remark");
            if (exempt.equals("Y") && remark.equals("")) {
                validation.add(false, "\u8c41\u514d" + member_id + "\u5fc5\u9808\u586b\u5beb\u5099\u8a3b", "RT");
            }
            if (in_time != null) {
                if (exempt.equals("Y") && !in_time.after(this.g_Activity.getLate_time())) {
                    validation.add(false, "\u8c41\u514d" + member_id + "\u7684\u6642\u9593\u5fc5\u9808\u5f8c\u65bc\u9072\u5230\u6642\u9593", "RT");
                }
                if (in_time.after(this.g_Activity.getEnd_record_time())) {
                    validation.add(false, String.valueOf(member_id) + "\u7684\u51fa\u5e2d\u6642\u9593\u4e0d\u53ef\u5f8c\u65bc\u7d50\u675f\u9ede\u5230\u6642\u9593", "RT");
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.g_Amgs.size()) {
            validation.add(this.g_Amgs.getI(ActivityMemberGroup.HEADCOUNT, i), String.valueOf(this.g_Amgs.getS("name", i)) + "\u7684\u984d\u5916\u51fa\u5e2d\u4eba\u6b21\u5fc5\u9808\u662f\u6b63\u6574\u6578", "R,I,GEZ");
            ++i;
        }
        if (!validation.isValid()) {
            return;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
        Attendance.update(this.g_Activity_seq, this.g_Items, this.g_Amgs);
        wait_dialog.dispose();
        this.dispose();
    }

    public void onCancel(ActionEvent evt) {
        this.dispose();
    }

    class ALAddMemberDialog
    extends DataDialog {
        private JButton searchB;
        private JButton addMemberB;
        private JButton cancelB;
        private JCheckBox selectAllCB;
        private JTextField nameTF;
        private TimeTextField inTimeDT;
        private ComboBoxNV member_groupNV;
        private ScrollList2 gMemberSL;
        private RecordList gMembers;
        private RecordList gAddedMembers;

        public ALAddMemberDialog(DataDialog dialog, RecordList addedMembers) {
            super(dialog, "\u52a0\u5165\u51fa\u5e2d\u6703\u773e", false);
            this.gAddedMembers = addedMembers;
            this.gMembers = this.getAllowedMembers("", -1);
            this.setLayout();
            this.setEventHandler();
            this.setVisible(true);
        }

        private RecordList getAllowedMembers(String name, int member_group_seq) {
            RecordList members = ActivityMemberGroup.getMemberInAllowedGroup(AttendanceListDialog.this.g_Activity_seq, name, member_group_seq);
            int i = 0;
            while (i < members.size()) {
                members.setCurrentRow(i);
                int member_seq = members.getI("member_seq");
                if (this.gAddedMembers.indexOf("member_seq", member_seq) >= 0) {
                    members.setS("added", "Y");
                } else {
                    members.setS("added", "N");
                }
                members.setS("selected", "N");
                ++i;
            }
            members.sort("added");
            return members;
        }

        public void setLayout() {
            this.nameTF = new JTextField();
            this.inTimeDT = new TimeTextField(AttendanceListDialog.this.g_Activity.getStart_time());
            this.searchB = new JButton("\u641c\u5c0b");
            this.selectAllCB = new JCheckBox("\u5217\u8868\u5168\u9078", false);
            this.addMemberB = new JButton("\u52a0\u5165");
            this.cancelB = new JButton("\u53d6\u6d88");
            this.setDefaultButton(this.searchB);
            boolean[] blArray = new boolean[3];
            blArray[2] = true;
            this.gMemberSL = new ScrollList2(560, 360, this.gMembers, new int[]{120, 370, 40}, new String[]{"\u6703\u773e\u7de8\u865f", "\u59d3\u540d", "\u9078\u53d6"}, new String[]{"member_id", Member.DISPLAY_NAME, "selected"}, blArray);
            this.gMemberSL.setEditing_mode(true);
            this.gMemberSL.setCheckBoxYNColumn("selected", "Y", "N");
            this.gMemberSL.setMatchedRowProperties(new String[]{"added"}, new String[]{"Y"}, Color.lightGray, true);
            ActivityMemberGroup amg = new ActivityMemberGroup(AttendanceListDialog.this.g_Activity_seq);
            RecordList mg = MemberGroup.getGroupNames(amg.getItems(), "name", "member_group_seq");
            this.member_groupNV = new ComboBoxNV((ArrayList)mg, "name", "member_group_seq", -1);
            TableLayout t = new TableLayout(this, 600, 570, 5, 10);
            int[] nArray = new int[4];
            nArray[0] = 80;
            nArray[1] = 250;
            nArray[2] = 125;
            t.getClass();
            nArray[3] = 0;
            t.addTable(nArray, new int[]{30, 30, 30});
            JLabel jLabel = new JLabel("\u59d3\u540d");
            t.getClass();
            t.getClass();
            t.addCell(jLabel, 0, 0, 1, 0);
            t.getClass();
            t.getClass();
            t.addCell(this.nameTF, 1, 0, 20, 0, 200, -1);
            t.getClass();
            t.addCell(this.selectAllCB, 2, 0, 20, 0);
            t.getClass();
            t.getClass();
            t.getClass();
            t.addCell(this.searchB, 3, 0, -1, 0, 115, -1);
            JLabel jLabel2 = new JLabel("\u6703\u773e\u7fa4\u7d44");
            t.getClass();
            t.getClass();
            t.addCell(jLabel2, 0, 1, 1, 0);
            t.getClass();
            t.getClass();
            t.addCell(this.member_groupNV, 1, 1, 20, 0, 200, -1);
            t.addYSpace(15);
            int[] nArray2 = new int[1];
            t.getClass();
            nArray2[0] = 0;
            t.addTable(nArray2, new int[]{365});
            t.getClass();
            t.getClass();
            t.addCell(this.gMemberSL, 0, 0, -1, -1);
            t.addYSpace(15);
            t.addTable(new int[]{100, 100, 100, 100, 100, 70}, new int[]{30});
            JLabel jLabel3 = new JLabel("\u9ede\u5230\u6642\u9593");
            t.getClass();
            t.getClass();
            t.addCell(jLabel3, 0, 0, 1, 0);
            t.getClass();
            t.addCell(this.inTimeDT, 1, 0, 10, 0);
            t.getClass();
            t.getClass();
            t.addCell(this.addMemberB, 4, 0, 1, 0);
            t.getClass();
            t.getClass();
            t.addCell(this.cancelB, 5, 0, 1, 0);
        }

        public void setEventHandler() {
            this.nameTF.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    ALAddMemberDialog.this.onSearchName(e);
                }
            });
            this.searchB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ALAddMemberDialog.this.onSearch(evt);
                }
            });
            this.addMemberB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ALAddMemberDialog.this.onAddMember(evt);
                }
            });
            this.cancelB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ALAddMemberDialog.this.onCancel(evt);
                }
            });
            this.selectAllCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ALAddMemberDialog.this.onSelectAll(evt);
                }
            });
            this.gMemberSL.getViewport().getView().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == 32) {
                        ALAddMemberDialog.this.onSelect(null);
                    }
                }
            });
        }

        public void onSearchName(KeyEvent evt) {
            this.gMemberSL.searchList(this.nameTF.getText());
        }

        public void onSearch(ActionEvent evt) {
            RecordList r = this.getAllowedMembers(this.nameTF.getText(), this.member_groupNV.getSelectedIntValue());
            this.gMemberSL.refreshTable(r);
            this.selectAllCB.setSelected(false);
        }

        public void onSelect(ActionEvent evt) {
            RecordList v;
            int selrow = this.gMemberSL.getSelectedRow();
            String selected = ArrayUtil.getString("SELECTED", selrow, v = this.gMemberSL.getTableData());
            ArrayUtil.setString("SELECTED", selected.equals("Y") ? "N" : "Y", selrow, v);
            this.gMemberSL.refreshTableRow(selrow);
        }

        public void onAddMember(ActionEvent evt) {
            Validation validation = new Validation();
            boolean isSelected = false;
            int i = 0;
            while (i < this.gMemberSL.getTableData().size()) {
                if (this.gMemberSL.getTableData().getS("selected", i).equals("Y")) {
                    isSelected = true;
                }
                ++i;
            }
            validation.add(isSelected, "\u5fc5\u9808\u6700\u5c11\u9078\u64c7\u4e00\u500b\u6703\u773e", "RT");
            validation.add(this.inTimeDT.getText(), "\u9ede\u5230\u6642\u9593", "R,T");
            if (!validation.isValid()) {
                return;
            }
            AttendanceListDialog.this.onFinishAddMember(this.gMemberSL.getTableData().getGroupItems("selected", "Y"), this.inTimeDT.getTime(TimeUtil.getStringByDate(AttendanceListDialog.this.g_Activity.getDate())));
            this.dispose();
        }

        public void onSelectAll(ActionEvent evt) {
            RecordList r = this.gMemberSL.getTableData();
            int i = 0;
            while (i < r.size()) {
                ArrayUtil.setString("selected", this.selectAllCB.isSelected() ? "Y" : "N", i, r);
                ++i;
            }
            this.gMemberSL.refreshTable(r);
        }

        private void onCancel(ActionEvent evt) {
            this.dispose();
        }
    }
}

