/*
 * Decompiled with CFR 0.152.
 */
package attendance;

import database.DBConn;
import database.DBUtil;
import database.SQLWhereClause;
import member.Member;
import util.RecordList;
import util.Tools;

public class ActivityMemberGroup {
    private int g_Activity_seq = -1;
    private RecordList g_Items = null;
    public static String ACTIVITY_MEMBER_GROUP_SEQ = "activity_member_group_seq";
    public static String ACTIVITY_SEQ = "activity_seq";
    public static String MEMBER_GROUP_SEQ = "member_group_seq";
    public static String HEADCOUNT = "headcount";

    public ActivityMemberGroup(int activity_seq) {
        this.g_Activity_seq = activity_seq;
        DBConn conn = new DBConn();
        this.g_Items = ActivityMemberGroup.load(this.g_Activity_seq, conn);
        conn.commit();
    }

    public RecordList getItems() {
        return this.g_Items;
    }

    public void resetHeadcount() {
        int i = 0;
        while (i < this.g_Items.size()) {
            this.g_Items.setI(HEADCOUNT, 0, i);
            ++i;
        }
    }

    private static RecordList load(int activity_seq, DBConn conn) {
        String sql = "select  mg.name,amg.*  from activity_member_group amg,member_group mg where amg.member_group_seq=mg.member_group_seq and amg.activity_seq=?";
        return DBUtil.run("select  mg.name,amg.*  from activity_member_group amg,member_group mg where amg.member_group_seq=mg.member_group_seq and amg.activity_seq=?", activity_seq);
    }

    public static void update(int activity_seq, RecordList items, DBConn conn) {
        ActivityMemberGroup.delete(activity_seq, conn);
        int i = 0;
        while (i < items.size()) {
            ActivityMemberGroup.insert(items, i, activity_seq, conn);
            ++i;
        }
    }

    private static void insert(RecordList items, int i, int activity_seq, DBConn conn) {
        String sql = "insert into activity_member_group( activity_member_group_seq,activity_seq,member_group_seq,headcount)values(?,?,?,?)";
        items.setCurrentRow(i);
        Object[] pvs = new Object[]{DBUtil.getNextValueFor(ACTIVITY_MEMBER_GROUP_SEQ, conn), new Integer(activity_seq), items.getInteger(MEMBER_GROUP_SEQ), items.getInteger(HEADCOUNT)};
        DBUtil.run("insert into activity_member_group( activity_member_group_seq,activity_seq,member_group_seq,headcount)values(?,?,?,?)", pvs, conn);
    }

    private static void delete(int activity_seq, DBConn conn) {
        String sql = "delete from activity_member_group where activity_seq=?";
        DBUtil.run("delete from activity_member_group where activity_seq=?", activity_seq, conn);
    }

    public static RecordList getMemberInAllowedGroup(int activity_seq, String name, int member_group_seq) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"amg.activity_seq=?", "lower(coalesce(mb.name1,'')||'\t'||coalesce(mb.name2,'')||'\t'||coalesce(mb.official_name,'')) like lower(?)", "mgm.member_group_seq=?"}, new Object[]{activity_seq, Tools.pad(name), member_group_seq});
        String sql = "select distinct mgm.member_seq,mb.member_id,mb.name1,mb.name2" + Member.getSelectDisplayNameSQL() + " from" + " activity_member_group amg" + ",member_group_member mgm" + ",member mb" + " where" + " amg.member_group_seq=mgm.member_group_seq" + " and mgm.member_seq=mb.member_seq" + " and mgm.start_date<=curdate()" + " and mgm.end_date>=curdate()" + clause.getConds() + Member.getOrderByDisplayNameSQL();
        return DBUtil.run(sql, clause.getPrepValues());
    }
}

