/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Voucher;
import database.DBConn;
import database.DBUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import util.RecordList;
import util.RecordListSet;

public class VoucherItem {
    private int g_Ac_doc_seq = -1;
    private RecordList g_Items = null;
    public static String AC_ITEM_SEQ = "ac_item_seq";
    public static String AC_DOC_SEQ = "ac_doc_seq";
    public static String AC_SEQ = "ac_seq";
    public static String DEBIT = "debit";
    public static String CREDIT = "credit";
    public static String CHEQUE_NO = "cheque_no";
    public static String REMARK = "remark";

    public VoucherItem(int ac_doc_seq) {
        this.g_Ac_doc_seq = ac_doc_seq;
        DBConn conn = new DBConn();
        this.g_Items = VoucherItem.load(this.g_Ac_doc_seq, conn);
        conn.commit();
    }

    public RecordList getItems() {
        return this.g_Items;
    }

    private static RecordList load(int ac_doc_seq, DBConn conn) {
        String sql = "select ac_item_seq,ac_doc_seq,ac_seq,debit,credit,cheque_no,remark from voucher_item where ac_doc_seq=?";
        return DBUtil.run(sql, ac_doc_seq, conn);
    }

    public static void update(int ac_doc_seq, RecordList items, DBConn conn) {
        RecordList old_items = VoucherItem.load(ac_doc_seq, conn);
        RecordListSet set = new RecordListSet(old_items, items, new String[]{"ac_item_seq"});
        RecordList r = set.getLeftOnly();
        int i = 0;
        while (i < r.size()) {
            VoucherItem.delete(r.getI(AC_ITEM_SEQ, i), conn);
            ++i;
        }
        r = set.getIntersectOfRight();
        i = 0;
        while (i < r.size()) {
            r.setCurrentRow(i);
            VoucherItem.update(r.getI(AC_ITEM_SEQ), r.getI(AC_SEQ), r.getD(DEBIT), r.getD(CREDIT), r.getS(CHEQUE_NO), r.getS(REMARK), conn);
            ++i;
        }
        r = set.getRightOnly();
        i = 0;
        while (i < r.size()) {
            r.setCurrentRow(i);
            VoucherItem.insert(ac_doc_seq, r.getI(AC_SEQ), r.getD(DEBIT), r.getD(CREDIT), r.getS(CHEQUE_NO), r.getS(REMARK), conn);
            ++i;
        }
    }

    private static void insert(int ac_doc_seq, int ac_seq, double debit, double credit, String cheque_no, String remark, DBConn conn) {
        String sql = "insert into voucher_item( ac_item_seq,ac_doc_seq,ac_seq,debit,credit,cheque_no,remark)values(?,?,?,?,?,?,?)";
        int ac_item_seq = DBUtil.getNextValueFor("ac_item_seq", conn);
        DBUtil.run(sql, new Object[]{new Integer(ac_item_seq), new Integer(ac_doc_seq), new Integer(ac_seq), new BigDecimal(debit), new BigDecimal(credit), cheque_no, remark}, conn);
    }

    private static void update(int ac_item_seq, int ac_seq, double debit, double credit, String cheque_no, String remark, DBConn conn) {
        String sql = "update voucher_item set ac_seq=?,debit=?,credit=?,cheque_no=?,remark=? where ac_item_seq=?";
        DBUtil.run(sql, new Object[]{new Integer(ac_seq), new BigDecimal(debit), new BigDecimal(credit), cheque_no, remark, new Integer(ac_item_seq)}, conn);
    }

    private static void delete(int ac_item_seq, DBConn conn) {
        String sql = "delete from voucher_item where ac_item_seq=?";
        DBUtil.run(sql, ac_item_seq, conn);
    }

    public static RecordList getVoucherItems(ArrayList ac_doc_seqs) {
        String sql = "select vo.ac_doc_seq,ac.id,ac.name,voi.debit,voi.credit,voi.cheque_no,voi.remark from voucher vo,voucher_item voi,ac_master ac where vo.ac_doc_seq=voi.ac_doc_seq and voi.ac_seq=ac.ac_seq and vo.status<>'" + Voucher.STATUS__CL + "'" + " and ac_doc_seq in" + DBUtil.getSQLInValues(ac_doc_seqs) + " order by voi.ac_item_seq";
        return DBUtil.run(sql);
    }
}

