/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Receipt;
import database.DBUtil;
import database.SQLWhereClause;
import java.sql.Timestamp;
import member.MemberGroup;
import member.MemberGroupMember;
import printout.xls.ExcelFormat;
import printout.xls.ExcelFormula;
import printout.xls.ExcelPrintout;
import system.Config;
import system.Lang;
import system.MasterCode;
import util.RecordList;
import util.TimeUtil;
import util.Tools;

public class ReceiptMonthlyReport {
    private RecordList gReceipts;
    private RecordList gMembers;
    private Timestamp gStartDate;
    private Timestamp gEndDate;
    private int gMonthNum;
    private int gPrefixCol;
    private ExcelPrintout gPrintout;

    public ReceiptMonthlyReport(Timestamp start_date, Timestamp end_date, String remark, String sub_type, int member_group_seq, boolean show_receipt_date, boolean show_zero) {
        RecordList non_member_items;
        this.gStartDate = start_date;
        this.gEndDate = end_date;
        this.gReceipts = this.getReceipts(start_date, end_date, remark, sub_type, show_receipt_date);
        this.gMembers = MemberGroupMember.getActiveMembersInGroup(member_group_seq, -1);
        this.gMonthNum = TimeUtil.getYear(end_date) * 12 + TimeUtil.getMonth(end_date) - TimeUtil.getYear(start_date) * 12 - TimeUtil.getMonth(start_date) + 1;
        this.gPrefixCol = 1;
        int[] widths = new int[this.gPrefixCol + this.gMonthNum + 1];
        widths[0] = 60;
        int i = 0;
        while (i < this.gMonthNum) {
            widths[this.gPrefixCol + i] = 20;
            ++i;
        }
        widths[this.gPrefixCol + this.gMonthNum] = 20;
        this.gPrintout = new ExcelPrintout(ExcelFormat.PA4R, widths);
        this.gPrintout.addHeader(Lang.set("\u6536\u64da\u6708\u5831\u8868"), new String[]{String.valueOf(Lang.set("\u65e5\u671f: ")) + TimeUtil.getStringByDate(start_date) + Lang.set(" \u81f3 ") + TimeUtil.getStringByDate(end_date), Lang.set(show_receipt_date ? "\u6309\u6536\u64da\u65e5\u671f\u6307\u7b97" : "\u6309\u6307\u5b9a\u671f\u6307\u7b97"), String.valueOf(Lang.set("\u6458\u8981/\u5099\u8a3b: ")) + remark, String.valueOf(Lang.set("\u9805\u76ee: ")) + MasterCode.getName(sub_type), String.valueOf(Lang.set("\u6703\u773e\u7fa4\u7d44: ")) + MemberGroup.getName(member_group_seq)});
        int row = this.gPrintout.getRowNumAfterHeader();
        int yyyy = TimeUtil.getYear(start_date);
        int mm = TimeUtil.getMonth(start_date);
        this.gPrintout.addCell(0, row, Lang.set("\u5b98\u65b9\u59d3\u540d"), this.gPrintout.TL);
        int i2 = 0;
        while (i2 < this.gMonthNum) {
            this.gPrintout.addCell(this.gPrefixCol + i2, row, String.valueOf(mm) + "/" + yyyy, this.gPrintout.TR);
            if (mm == 12) {
                mm = 1;
                ++yyyy;
            } else {
                ++mm;
            }
            ++i2;
        }
        this.gPrintout.addCell(this.gPrefixCol + this.gMonthNum, row, String.valueOf(Lang.set("\u7e3d\u984d")) + "(" + Config.getS(Config.currencyCode) + ")", this.gPrintout.TR);
        int start_row = row + 1;
        int i3 = 0;
        while (i3 < this.gMembers.size()) {
            this.gMembers.setCurrentRow(i3);
            int member_seq = this.gMembers.getI("member_seq");
            RecordList items = this.gReceipts.getGroupItems("member_seq", member_seq);
            if (show_zero || !items.isEmpty()) {
                this.addPrintRecord(this.gMembers.getS("official_name"), ++row, items);
            }
            ++i3;
        }
        if (member_group_seq == MemberGroup.ROOT_GROUP_SEQ && !(non_member_items = this.gReceipts.getGroupItems("member_seq", -1)).isEmpty()) {
            non_member_items.sort("offer_from");
            RecordList non_members = non_member_items.uniq(new String[]{"offer_from"});
            int i4 = 0;
            while (i4 < non_members.size()) {
                String offer_from = non_members.getS("offer_from", i4);
                RecordList items = non_member_items.getGroupItems("offer_from", offer_from);
                this.addPrintRecord(offer_from, ++row, items);
                ++i4;
            }
        }
        this.gPrintout.addCell(0, ++row, Lang.set("\u7e3d\u984d:"), this.gPrintout.AR);
        this.gPrintout.addCell(0, row + 1, Lang.set("\u7e3d\u4eba\u6578:"), this.gPrintout.AR);
        i = 0;
        while (i < this.gMonthNum + 1) {
            int col = this.gPrefixCol + i;
            if (start_row == row) {
                this.gPrintout.addCell(col, row, 0, this.gPrintout.BTBD);
                this.gPrintout.addCell(col, row + 1, 0, this.gPrintout.BTBD);
            } else {
                this.gPrintout.addCell(col, row, ExcelFormula.sum(col, start_row, col, row - 1), this.gPrintout.BTBD);
                if (i != this.gMonthNum) {
                    this.gPrintout.addCell(col, row + 1, ExcelFormula.counta(col, start_row, col, row - 1), this.gPrintout.AR);
                } else {
                    this.gPrintout.addCell(col, row + 1, ExcelFormula.countif(col, start_row, col, row - 1, ">0"), this.gPrintout.AR);
                }
            }
            ++i;
        }
        this.gPrintout.genPrintout();
    }

    private void addPrintRecord(String name, int row, RecordList items) {
        int yyyy = TimeUtil.getYear(this.gStartDate);
        int mm = TimeUtil.getMonth(this.gStartDate);
        this.gPrintout.addCell(0, row, name);
        int i = 0;
        while (i < this.gMonthNum) {
            int k = items.indexOf(new String[]{"yyyy", "mm"}, new Integer[]{yyyy, mm});
            if (k != -1) {
                this.gPrintout.addCell(this.gPrefixCol + i, row, items.getD("amount", k), this.gPrintout.FORMAT_DOUBLE);
            }
            if (mm == 12) {
                mm = 1;
                ++yyyy;
            } else {
                ++mm;
            }
            ++i;
        }
        this.gPrintout.addCell(this.gPrefixCol + this.gMonthNum, row, ExcelFormula.sum(this.gPrefixCol, row, this.gPrefixCol + this.gMonthNum - 1, row), this.gPrintout.FORMAT_DOUBLE);
    }

    private RecordList getReceipts(Timestamp start_date, Timestamp end_date, String remark, String sub_type, boolean show_receipt_date) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{show_receipt_date ? "rc.date>=?" : "coalesce(rci.target_date,rc.date)>=?", show_receipt_date ? "rc.date<?" : "coalesce(rci.target_date,rc.date)<?", "not rc.status=?", "lower(coalesce(rc.remark,'')||'\n'||coalesce(rci.note,'')) like lower(?)", "rci.sub_type=?"}, new Object[]{start_date, TimeUtil.adjustDate(end_date, 1), Receipt.STATUS__CL, Tools.pad(remark), sub_type});
        String sql = "select month(rc_date) as mm,year(rc_date) as yyyy,offer_from,member_seq,sum(amount) as amount from (select rc.offer_from,rc.member_seq,rci.amount" + (show_receipt_date ? ",rc.date as rc_date" : ",coalesce(rci.target_date,rc.date) as rc_date") + " from receipt rc" + ",receipt_item rci" + " where" + " rc.receipt_seq=rci.receipt_seq" + clause.getConds() + " ) rc" + " group by month(rc_date),year(rc_date),offer_from,member_seq";
        return DBUtil.run(sql, clause.getPrepValues());
    }
}

