/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Receipt;
import account.ReceiptInfoDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import system.MasterCode;
import system.User;
import ui.ComboBoxCN;
import ui.DateTextField;
import ui.ListDialog;
import ui.ScrollList2;
import ui.TableLayout;
import util.RecordList;
import util.WinUtil;

public class ReceiptListDialog
extends ListDialog {
    private JButton searchB;
    private JButton addB;
    private JButton modifyB;
    private JButton approveB;
    private JTextField offer_fromTF;
    private DateTextField start_dateDT;
    private DateTextField end_dateDT;
    private ComboBoxCN statusCN;
    private ComboBoxCN payment_methodCN;
    private JTextField remarkTF;
    private ScrollList2 listSL;
    private RecordList g_List = Receipt.search("", null, null, "", "", "", true);
    private RecordList g_ApproveList;

    public ReceiptListDialog(JFrame frame) {
        super(frame, "\u6536\u64da\u5217\u8868", false);
        this.setLayout();
        this.setEventHandler();
        this.showDialog();
    }

    public void setLayout() {
        this.offer_fromTF = new JTextField();
        this.start_dateDT = new DateTextField();
        this.end_dateDT = new DateTextField();
        this.statusCN = new ComboBoxCN(ComboBoxCN.buildItemsByMap(Receipt.STATUS_MAP), "");
        this.payment_methodCN = new ComboBoxCN(MasterCode.getCodes("PAYMENT_METHOD"));
        this.remarkTF = new JTextField();
        this.searchB = new JButton("\u641c\u5c0b");
        this.addB = new JButton("\u65b0\u589e");
        this.modifyB = new JButton("\u4fee\u6539/\u6aa2\u8996");
        this.approveB = new JButton("\u6279\u6838");
        this.addB.setEnabled(User.hasPrivilege("receiptModify"));
        this.approveB.setEnabled(User.hasPrivilege("receiptApprove"));
        this.setDefaultButton(this.searchB);
        this.listSL = new ScrollList2(560, 380, this.g_List, new int[]{85, 80, 215, 90, 45, 45}, new String[]{"\u6536\u64da\u7de8\u865f", "\u65e5\u671f", "\u8332\u6536\u5230", "\u91d1\u984d", "\u73fe\u6cc1", "\u96fb\u90f5"}, new String[]{"id", "date", "offer_from", "total", "status", "email_status"}, new boolean[6]);
        this.listSL.setDateTextFieldColumn("date");
        this.listSL.setBigDecimalTextFieldColumn("total");
        this.addResizeComp(this.listSL, true, true);
        TableLayout t = new TableLayout(this, 600, 570, 5, 10);
        int[] nArray = new int[4];
        nArray[0] = 80;
        nArray[1] = 250;
        nArray[2] = 130;
        t.getClass();
        nArray[3] = 0;
        t.addTable(nArray, new int[]{30, 30, 30, 30});
        int row = 0;
        JLabel jLabel = new JLabel("\u8332\u6536\u5230");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.offer_fromTF, 1, row, 20, 0, 200, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.searchB, 3, row, -1, 0, 115, -1);
        ++row;
        JLabel jLabel2 = new JLabel("\u6536\u64da\u65e5\u671f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 0, row, 1, 0);
        t.getClass();
        t.addCell(this.start_dateDT, 1, row, 20, 0);
        JLabel jLabel3 = new JLabel("\u81f3");
        t.getClass();
        t.addCell(jLabel3, 1, row, 115, 0);
        t.getClass();
        t.addCell(this.end_dateDT, 1, row, 140, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.addB, 3, row, -1, 0, 115, -1);
        ++row;
        JLabel jLabel4 = new JLabel("\u73fe\u6cc1");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 0, row, 1, 0);
        t.getClass();
        t.addCell(this.statusCN, 1, row, 20, 0);
        JLabel jLabel5 = new JLabel("\u4ed8\u6b3e\u65b9\u5f0f");
        t.getClass();
        t.addCell(jLabel5, 1, row, 115, 0);
        t.getClass();
        t.addCell(this.payment_methodCN, 1, row, 175, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.modifyB, 3, row, -1, 0, 115, -1);
        ++row;
        JLabel jLabel6 = new JLabel("\u5099\u8a3b/\u6458\u8981");
        t.getClass();
        t.getClass();
        t.addCell(jLabel6, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.remarkTF, 1, row, 20, 0, 200, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.approveB, 3, row, -1, 0, 115, -1);
        t.addYSpace(15);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{370});
        t.getClass();
        t.getClass();
        t.addCell(this.listSL, 0, 0, -1, -1);
    }

    private void setEventHandler() {
        this.searchB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReceiptListDialog.this.onSearch(evt);
            }
        });
        this.addB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReceiptListDialog.this.onAdd(evt);
            }
        });
        this.modifyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReceiptListDialog.this.onModify(evt);
            }
        });
        this.approveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReceiptListDialog.this.onApprove(evt);
            }
        });
        this.listSL.getViewport().getView().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    ReceiptListDialog.this.onModify(null);
                }
            }
        });
        this.listSL.getViewport().getView().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    ReceiptListDialog.this.onModify(null);
                }
            }
        });
    }

    public void onSearch(ActionEvent evt) {
        RecordList r = Receipt.search(this.offer_fromTF.getText(), this.start_dateDT.getDate(), this.end_dateDT.getDate(), this.statusCN.getSelectedCode(), this.payment_methodCN.getSelectedCode(), this.remarkTF.getText(), true);
        this.listSL.refreshTable(r);
    }

    public void onAdd(ActionEvent evt) {
        ReceiptInfoDialog d = new ReceiptInfoDialog(this, -1, false, false);
    }

    private void onModify(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int receipt_seq = this.listSL.getTableData().getI("receipt_seq", selrow);
            ReceiptInfoDialog receiptInfoDialog = new ReceiptInfoDialog(this, receipt_seq, true, false);
        }
    }

    public void onNextApprove(boolean skipAll) {
        if (!skipAll && this.g_ApproveList.getCurrentRow() < this.g_ApproveList.size() - 1) {
            this.g_ApproveList.setCurrentRow(this.g_ApproveList.getCurrentRow() + 1);
            ReceiptInfoDialog d = new ReceiptInfoDialog(this, this.g_ApproveList.getI("receipt_seq"), false, true);
        } else {
            this.onSearch(null);
        }
    }

    private void onApprove(ActionEvent evt) {
        this.g_ApproveList = Receipt.search("", null, null, Receipt.STATUS__WA, "", "", false);
        if (this.g_ApproveList.isEmpty()) {
            WinUtil.showMessage(this, "\u6c92\u6709\u5f85\u6279\u6838\u7684\u6536\u64da");
            return;
        }
        this.g_ApproveList.setCurrentRow(-1);
        this.onNextApprove(false);
    }
}

