/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Account;
import java.util.ArrayList;
import printout.xls.ExcelFormat;
import printout.xls.ExcelPrintout;
import system.Config;
import system.Lang;
import system.SystemCode;
import util.ArrayUtil;

public class AccountReport {
    private ArrayList g_Accounts = Account.getAllAccounts();
    private ExcelPrintout g_Printout = null;
    private int g_Row = 0;
    private static final String INDENT = "  ";

    public AccountReport() {
        ArrayList ac_seqs = ArrayUtil.getCol(this.g_Accounts, "AC_SEQ");
        this.g_Printout = new ExcelPrintout(ExcelFormat.PA4R, new int[]{53, 25, 53, 30, 53, 10, 20, 30});
        this.g_Printout.addHeader(Config.getS(Config.companyName), Lang.set("\u6703\u8a08\u5e33\u6236\u5831\u8868"), new String[0]);
        this.g_Row = this.g_Printout.getRowNumAfterHeader();
        this.g_Printout.addCell(0, this.g_Row, Lang.set("\u5e33\u6236\u6392\u5217"), this.g_Printout.TL);
        this.g_Printout.addCell(1, this.g_Row, Lang.set("\u5e33\u6236\u7de8\u865f"), this.g_Printout.TL);
        this.g_Printout.addCell(2, this.g_Row, Lang.set("\u5e33\u6236\u540d\u7a31"), this.g_Printout.TL);
        this.g_Printout.addCell(3, this.g_Row, Lang.set("\u5e33\u6236\u985e\u578b"), this.g_Printout.TL);
        this.g_Printout.addCell(4, this.g_Row, Lang.set("\u4e0a\u5c64\u5e33\u6236"), this.g_Printout.TL);
        this.g_Printout.addCell(5, this.g_Row, Lang.set("\u7528\u65bc\u5206\u5c64"), this.g_Printout.TL);
        this.g_Printout.addCell(6, this.g_Row, Lang.set("\u73fe\u6cc1"), this.g_Printout.TL);
        this.g_Printout.addCell(7, this.g_Row, Lang.set("\u5099\u8a3b"), this.g_Printout.TL);
        this.printTypeAccounts(this.g_Accounts);
        this.g_Printout.genPrintout();
    }

    private void printTypeAccounts(ArrayList type_acs) {
        ArrayList first_level_acs = ArrayUtil.getGroupItems(type_acs, "PARENT_AC_SEQ", new Integer(-1));
        this.printGroupAccounts(0, first_level_acs, "");
    }

    private void printGroupAccounts(int level, ArrayList group_acs, String parent_ac_id_name) {
        int i = 0;
        while (i < group_acs.size()) {
            int ac_seq = ArrayUtil.getInt("AC_SEQ", i, group_acs);
            String is_parent = ArrayUtil.getString("IS_PARENT", i, group_acs);
            String id = ArrayUtil.getString("ID", i, group_acs);
            String name = ArrayUtil.getString("NAME", i, group_acs);
            String type = ArrayUtil.getString("TYPE", i, group_acs);
            String status = ArrayUtil.getString("STATUS", i, group_acs);
            String remark = ArrayUtil.getString("REMARK", i, group_acs);
            String id_name = String.valueOf(id) + " " + name;
            int row = ++this.g_Row;
            if (is_parent.equals("Y")) {
                ArrayList next_level_acs = ArrayUtil.getGroupItems(this.g_Accounts, "PARENT_AC_SEQ", new Integer(ac_seq));
                this.printGroupAccounts(level + 1, next_level_acs, id_name);
            }
            this.g_Printout.addCell(0, row, String.valueOf(this.getIndent(level)) + id_name);
            this.g_Printout.addCell(1, row, id);
            this.g_Printout.addCell(2, row, name);
            this.g_Printout.addCell(3, row, SystemCode.getAccount(type));
            this.g_Printout.addCell(4, row, parent_ac_id_name);
            this.g_Printout.addCell(5, row, is_parent.equals("Y") ? "Y" : "N");
            this.g_Printout.addCell(6, row, SystemCode.getStatus(status));
            this.g_Printout.addCell(7, row, remark);
            ++i;
        }
    }

    private String getIndent(int level) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < level) {
            b.append(INDENT);
            ++i;
        }
        return b.toString();
    }
}

