/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.AccountMonth;
import account.AccountMonthPostingDialog;
import account.AccountYearPostingDialog;
import account.BalanceSheetDialog;
import account.IncomeStatementDialog;
import account.TrialBalanceDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import system.Config;
import system.User;
import ui.DataDialog;
import ui.ListDialog;
import ui.ScrollList;
import ui.TableLayout;
import util.ArrayUtil;
import util.RecordList;
import util.WinUtil;

public class AccountPostingListDialog
extends ListDialog {
    private JButton new_month_postingB;
    private JButton month_postingB;
    private JButton year_postingB;
    private JButton trial_balanceB;
    private JButton profit_and_lossB;
    private JButton balance_sheetB;
    private ScrollList listSL;
    private ArrayList g_List = AccountMonth.search();

    public AccountPostingListDialog(JFrame frame) {
        super(frame, "\u6703\u8a08\u904e\u5e33\u5217\u8868", false);
        this.setLayout();
        this.setEventHandler();
        this.showDialog();
    }

    public void setLayout() {
        this.new_month_postingB = new JButton("\u65b0\u589e\u6708\u7d50\u904e\u5e33");
        this.month_postingB = new JButton("\u6708\u7d50\u904e\u5e33");
        this.year_postingB = new JButton("\u5e74\u7d50\u904e\u5e33");
        this.trial_balanceB = new JButton("\u8a66\u7b97\u8868");
        this.profit_and_lossB = new JButton("\u640d\u76ca\u8868");
        this.balance_sheetB = new JButton("\u8cc7\u7522\u8ca0\u50b5\u8868");
        boolean canModify = User.hasPrivilege("accountPeriodModify");
        boolean canRead = User.hasPrivilege("accountPeriodRead");
        this.new_month_postingB.setEnabled(canModify);
        this.month_postingB.setEnabled(canModify);
        this.year_postingB.setEnabled(canModify);
        this.trial_balanceB.setEnabled(canRead);
        this.profit_and_lossB.setEnabled(canRead);
        this.balance_sheetB.setEnabled(canRead);
        this.listSL = new ScrollList(560, 410, this.g_List, new int[]{100, 100, 100, 210, 50}, new String[]{"\u958b\u59cb\u65e5\u671f", "\u7d50\u675f\u65e5\u671f", "\u904e\u5e33\u65e5\u671f", "\u6703\u8a08\u5e74\u5ea6", "\u5df2\u9396"}, new String[]{"START_DATE", "END_DATE", "POSTING_DATE", "YEAR_NAME", "LOCK"}, new boolean[5]);
        this.listSL.setDateTextFieldColumn("START_DATE");
        this.listSL.setDateTextFieldColumn("END_DATE");
        this.listSL.setDateTextFieldColumn("POSTING_DATE");
        this.listSL.setSortCol("START_DATE", false);
        this.addResizeComp(this.listSL, true, true);
        TableLayout t = new TableLayout(this, 600, 570, 5, 10);
        int[] nArray = new int[3];
        nArray[0] = 320;
        nArray[1] = 130;
        t.getClass();
        nArray[2] = 0;
        t.addTable(nArray, new int[]{30, 30, 30});
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.trial_balanceB, 1, 0, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.new_month_postingB, 2, 0, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.profit_and_lossB, 1, 1, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.month_postingB, 2, 1, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.balance_sheetB, 1, 2, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.year_postingB, 2, 2, -1, 0, 115, -1);
        t.addYSpace(15);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{380});
        t.getClass();
        t.getClass();
        t.addCell(this.listSL, 0, 0, -1, -1);
    }

    public void setEventHandler() {
        this.new_month_postingB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountPostingListDialog.this.onNewMonthPosting(evt);
            }
        });
        this.month_postingB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountPostingListDialog.this.onMonthPosting(evt);
            }
        });
        this.year_postingB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountPostingListDialog.this.onYearPosting(evt);
            }
        });
        this.trial_balanceB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountPostingListDialog.this.onCreateTrialBalance(evt);
            }
        });
        this.profit_and_lossB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountPostingListDialog.this.onCreateIncomeAndExpense(evt);
            }
        });
        this.balance_sheetB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountPostingListDialog.this.onCreateBalanceSheet(evt);
            }
        });
    }

    public void onSearch(ActionEvent evt) {
        RecordList v = AccountMonth.search();
        this.listSL.refreshTable(v);
    }

    public void onNewMonthPosting(ActionEvent evt) {
        if (Config.getT(Config.startAcPeriod) != null) {
            AccountMonthPostingDialog f = new AccountMonthPostingDialog(this, -1);
        } else {
            WinUtil.showMessage(this, "\u5728\u958b\u59cb\u904e\u5e33\u524d\uff0c\u5fc5\u9808\u5148\u5728\u8a2d\u5b9a > \u6703\u8a08 > \u958b\u59cb\u5e74\u5ea6\u65e5\u671f\u5167\u8a2d\u5b9a\u9996\u500b\u6703\u8a08\u5e74\u5ea6\u65e5\u671f");
        }
    }

    public void onMonthPosting(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int ac_month_seq = ArrayUtil.getInt("AC_MONTH_SEQ", selrow, this.listSL.getTableData());
            AccountMonthPostingDialog accountMonthPostingDialog = new AccountMonthPostingDialog(this, ac_month_seq);
        }
    }

    public void onYearPosting(ActionEvent evt) {
        int[] selrows = this.listSL.getSelectedRows();
        if (selrows.length != 0) {
            Timestamp start_date1 = ArrayUtil.getTimestamp("START_DATE", selrows[0], this.listSL.getTableData());
            Timestamp start_date2 = ArrayUtil.getTimestamp("START_DATE", selrows[selrows.length - 1], this.listSL.getTableData());
            AccountYearPostingDialog accountYearPostingDialog = new AccountYearPostingDialog((DataDialog)this, start_date1, start_date2);
        }
    }

    public void onCreateTrialBalance(ActionEvent evt) {
        int[] selrows = this.listSL.getSelectedRows();
        if (selrows.length > 0) {
            int start_acm_seq = ArrayUtil.getInt("ac_month_seq", selrows[0], this.listSL.getTableData());
            int end_acm_seq = ArrayUtil.getInt("ac_month_seq", selrows[selrows.length - 1], this.listSL.getTableData());
            TrialBalanceDialog trialBalanceDialog = new TrialBalanceDialog((DataDialog)this, start_acm_seq, end_acm_seq);
        }
    }

    public void onCreateIncomeAndExpense(ActionEvent evt) {
        int[] selrows = this.listSL.getSelectedRows();
        if (selrows.length > 0) {
            int start_acm_seq = ArrayUtil.getInt("ac_month_seq", selrows[0], this.listSL.getTableData());
            int end_acm_seq = ArrayUtil.getInt("ac_month_seq", selrows[selrows.length - 1], this.listSL.getTableData());
            IncomeStatementDialog incomeStatementDialog = new IncomeStatementDialog((DataDialog)this, start_acm_seq, end_acm_seq);
        }
    }

    public void onCreateBalanceSheet(ActionEvent evt) {
        int[] selrows = this.listSL.getSelectedRows();
        if (selrows.length > 0) {
            int start_acm_seq = ArrayUtil.getInt("ac_month_seq", selrows[0], this.listSL.getTableData());
            int end_acm_seq = ArrayUtil.getInt("ac_month_seq", selrows[selrows.length - 1], this.listSL.getTableData());
            BalanceSheetDialog balanceSheetDialog = new BalanceSheetDialog((DataDialog)this, start_acm_seq, end_acm_seq);
        }
    }
}

