/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import snaq.db.CacheConnection;
import snaq.db.ConnectionPoolEvent;
import snaq.db.ConnectionPoolListener;
import snaq.db.ConnectionValidator;
import snaq.db.PasswordDecoder;
import snaq.util.ObjectPool;
import snaq.util.ObjectPoolEvent;
import snaq.util.ObjectPoolEventAdapter;
import snaq.util.Reusable;

public class ConnectionPool
extends ObjectPool
implements Comparable {
    private String url;
    private String user;
    private String pass;
    private Properties props;
    private ConnectionValidator validator = new DefaultValidator();
    private PasswordDecoder decoder;
    private boolean cacheSS;
    private boolean cachePS;
    private boolean cacheCS;
    private List listeners = new ArrayList();
    static /* synthetic */ Class class$snaq$db$CacheConnection;

    public ConnectionPool(String string, int n, int n2, long l, String string2, String string3, String string4) {
        super(string, n, n2, l);
        this.url = string2;
        this.user = string3;
        this.pass = string4;
        this.props = null;
        this.setCaching(true);
        this.addObjectPoolListener(new EventRelay());
    }

    public ConnectionPool(String string, int n, int n2, long l, String string2, Properties properties) {
        this(string, n, n2, l, string2, null, null);
        this.props = properties;
        this.pass = properties.getProperty("password");
        this.addObjectPoolListener(new EventRelay());
    }

    protected Reusable create() throws SQLException {
        Connection connection = null;
        CacheConnection cacheConnection = null;
        try {
            block13: {
                if (this.props != null) {
                    if (this.decoder != null) {
                        this.props.setProperty("password", new String(this.decoder.decode(this.pass)));
                    }
                    this.log("Getting connection (properties): " + this.url);
                    connection = DriverManager.getConnection(this.url, this.props);
                } else if (this.user != null) {
                    try {
                        if (this.decoder != null) {
                            this.log("Getting connection (user/enc.pass): " + this.url);
                            connection = DriverManager.getConnection(this.url, this.user, new String(this.decoder.decode(this.pass)));
                            break block13;
                        }
                        this.log("Getting connection (user/pass): " + this.url);
                        connection = DriverManager.getConnection(this.url, this.user, this.pass);
                    }
                    catch (SQLException sQLException) {
                        this.log("Failed to connect with standard authentication...trying with just JDBC URL");
                        this.log("Getting connection (URL only): " + this.url);
                        connection = DriverManager.getConnection(this.url);
                    }
                } else {
                    connection = DriverManager.getConnection(this.url);
                }
            }
            cacheConnection = new CacheConnection(this, connection);
            cacheConnection.setCacheStatements(this.cacheSS);
            cacheConnection.setCachePreparedStatements(this.cachePS);
            cacheConnection.setCacheCallableStatements(this.cacheCS);
            this.log("Created a new connection");
            for (SQLWarning sQLWarning = connection.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                this.log("Warning - " + sQLWarning.getMessage());
            }
        }
        catch (SQLException sQLException) {
            this.log(sQLException, "Can't create a new connection for " + this.url);
            try {
                connection.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
        return cacheConnection;
    }

    protected boolean isValid(Reusable reusable) {
        if (reusable == null) {
            return false;
        }
        if (this.validator == null) {
            return true;
        }
        try {
            boolean bl = this.validator.isValid((Connection)((Object)reusable));
            if (!bl) {
                this.fireValidationErrorEvent();
            }
            return bl;
        }
        catch (Exception exception) {
            this.log(exception, "Exception during validation");
            return false;
        }
    }

    public void setValidator(ConnectionValidator connectionValidator) {
        this.validator = connectionValidator;
    }

    public ConnectionValidator getValidator() {
        return this.validator;
    }

    public void setPasswordDecoder(PasswordDecoder passwordDecoder) {
        this.decoder = passwordDecoder;
    }

    public PasswordDecoder getPasswordDecoder() {
        return this.decoder;
    }

    protected void destroy(Reusable reusable) {
        if (reusable == null) {
            return;
        }
        try {
            ((CacheConnection)reusable).release();
            this.log("Destroyed connection");
        }
        catch (SQLException sQLException) {
            this.log(sQLException, "Can't destroy connection");
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            Reusable reusable = super.checkOut();
            if (reusable != null) {
                CacheConnection cacheConnection = (CacheConnection)reusable;
                cacheConnection.setOpen();
                return cacheConnection;
            }
            return null;
        }
        catch (Exception exception) {
            this.log(exception, "Error getting connection");
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            for (Throwable throwable = exception.getCause(); throwable != null; throwable = throwable.getCause()) {
                this.log(exception, "Error getting connection");
            }
            throw new SQLException(exception.getMessage());
        }
    }

    public Connection getConnection(long l) throws SQLException {
        try {
            Reusable reusable = super.checkOut(l);
            if (reusable != null) {
                CacheConnection cacheConnection = (CacheConnection)reusable;
                cacheConnection.setOpen();
                return cacheConnection;
            }
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            this.log(exception, "Error getting connection");
            throw new SQLException(exception.getMessage());
        }
    }

    protected void freeConnection(Connection connection) throws SQLException {
        if (connection == null || !(class$snaq$db$CacheConnection == null ? (class$snaq$db$CacheConnection = ConnectionPool.class$("snaq.db.CacheConnection")) : class$snaq$db$CacheConnection).isInstance(connection)) {
            this.log("Attempt to return invalid item");
        } else {
            CacheConnection cacheConnection = (CacheConnection)connection;
            super.checkIn((Reusable)((Object)connection));
        }
    }

    public void setCaching(boolean bl) {
        this.cachePS = this.cacheCS = bl;
        this.cacheSS = this.cacheCS;
    }

    public void setCaching(boolean bl, boolean bl2, boolean bl3) {
        this.cacheSS = bl;
        this.cachePS = bl2;
        this.cacheCS = bl3;
    }

    public String toString() {
        return this.getName();
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(((ConnectionPool)object).toString());
    }

    public final void addConnectionPoolListener(ConnectionPoolListener connectionPoolListener) {
        this.listeners.add(connectionPoolListener);
    }

    public final void removeConnectionPoolListener(ConnectionPoolListener connectionPoolListener) {
        this.listeners.remove(connectionPoolListener);
    }

    private final void fireValidationErrorEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(this, 9);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ConnectionPoolListener)iterator.next()).validationError(connectionPoolEvent);
        }
    }

    private final void firePoolCheckOutEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(this, 1);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ConnectionPoolListener)iterator.next()).poolCheckOut(connectionPoolEvent);
        }
    }

    private final void firePoolCheckInEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(this, 2);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ConnectionPoolListener)iterator.next()).poolCheckIn(connectionPoolEvent);
        }
    }

    private final void fireMaxPoolLimitReachedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(this, 3);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ConnectionPoolListener)iterator.next()).maxPoolLimitReached(connectionPoolEvent);
        }
    }

    private final void fireMaxPoolLimitExceededEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(this, 4);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ConnectionPoolListener)iterator.next()).maxPoolLimitExceeded(connectionPoolEvent);
        }
    }

    private final void fireMaxSizeLimitReachedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(this, 5);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ConnectionPoolListener)iterator.next()).maxSizeLimitReached(connectionPoolEvent);
        }
    }

    private final void fireMaxSizeLimitErrorEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(this, 6);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ConnectionPoolListener)iterator.next()).maxSizeLimitError(connectionPoolEvent);
        }
    }

    private final void fireParametersChangedEvent() {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(this, 7);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ConnectionPoolListener)iterator.next()).poolParametersChanged(connectionPoolEvent);
        }
    }

    private final void firePoolReleasedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(this, 8);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ConnectionPoolListener)iterator.next()).poolReleased(connectionPoolEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class DefaultValidator
    implements ConnectionValidator {
        DefaultValidator() {
        }

        public boolean isValid(Connection connection) {
            try {
                return !connection.isClosed();
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
    }

    private final class EventRelay
    extends ObjectPoolEventAdapter {
        private EventRelay() {
        }

        public void poolCheckOut(ObjectPoolEvent objectPoolEvent) {
            ConnectionPool.this.firePoolCheckOutEvent();
        }

        public void poolCheckIn(ObjectPoolEvent objectPoolEvent) {
            ConnectionPool.this.firePoolCheckInEvent();
        }

        public void maxPoolLimitReached(ObjectPoolEvent objectPoolEvent) {
            ConnectionPool.this.fireMaxPoolLimitReachedEvent();
        }

        public void maxPoolLimitExceeded(ObjectPoolEvent objectPoolEvent) {
            ConnectionPool.this.fireMaxPoolLimitExceededEvent();
        }

        public void maxSizeLimitReached(ObjectPoolEvent objectPoolEvent) {
            ConnectionPool.this.fireMaxSizeLimitReachedEvent();
        }

        public void maxSizeLimitError(ObjectPoolEvent objectPoolEvent) {
            ConnectionPool.this.fireMaxSizeLimitErrorEvent();
        }

        public void poolParametersChanged(ObjectPoolEvent objectPoolEvent) {
            ConnectionPool.this.fireParametersChangedEvent();
        }

        public void poolReleased(ObjectPoolEvent objectPoolEvent) {
            ConnectionPool.this.firePoolReleasedEvent();
            ConnectionPool.this.listeners.clear();
        }
    }
}

