/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import snaq.db.CachedStatement;

public class CachedPreparedStatement
extends CachedStatement
implements PreparedStatement {
    protected String sql;

    public CachedPreparedStatement(String string, PreparedStatement preparedStatement) {
        super(preparedStatement);
        this.sql = string;
    }

    String getSQLString() {
        return this.sql;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" [");
        stringBuffer.append(this.sql);
        stringBuffer.append(',');
        stringBuffer.append(this.getParametersString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void recycle() throws SQLException {
        super.recycle();
        PreparedStatement preparedStatement = (PreparedStatement)this.st;
        try {
            preparedStatement.clearParameters();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void release() throws SQLException {
        this.st.close();
    }

    public ResultSet executeQuery() throws SQLException {
        return ((PreparedStatement)this.st).executeQuery();
    }

    public int executeUpdate() throws SQLException {
        return ((PreparedStatement)this.st).executeUpdate();
    }

    public void setNull(int n, int n2) throws SQLException {
        ((PreparedStatement)this.st).setNull(n, n2);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        ((PreparedStatement)this.st).setBoolean(n, bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        ((PreparedStatement)this.st).setByte(n, by);
    }

    public void setShort(int n, short s) throws SQLException {
        ((PreparedStatement)this.st).setShort(n, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        ((PreparedStatement)this.st).setInt(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        ((PreparedStatement)this.st).setLong(n, l);
    }

    public void setFloat(int n, float f) throws SQLException {
        ((PreparedStatement)this.st).setFloat(n, f);
    }

    public void setDouble(int n, double d) throws SQLException {
        ((PreparedStatement)this.st).setDouble(n, d);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        ((PreparedStatement)this.st).setBigDecimal(n, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        ((PreparedStatement)this.st).setString(n, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        ((PreparedStatement)this.st).setBytes(n, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        ((PreparedStatement)this.st).setDate(n, date);
    }

    public void setTime(int n, Time time) throws SQLException {
        ((PreparedStatement)this.st).setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        ((PreparedStatement)this.st).setTimestamp(n, timestamp);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        ((PreparedStatement)this.st).setAsciiStream(n, inputStream, n2);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        ((PreparedStatement)this.st).setUnicodeStream(n, inputStream, n2);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        ((PreparedStatement)this.st).setBinaryStream(n, inputStream, n2);
    }

    public void clearParameters() throws SQLException {
        ((PreparedStatement)this.st).clearParameters();
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        ((PreparedStatement)this.st).setObject(n, object, n2, n3);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        ((PreparedStatement)this.st).setObject(n, object, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        ((PreparedStatement)this.st).setObject(n, object);
    }

    public boolean execute() throws SQLException {
        return ((PreparedStatement)this.st).execute();
    }

    public void addBatch() throws SQLException {
        ((PreparedStatement)this.st).addBatch();
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        ((PreparedStatement)this.st).setCharacterStream(n, reader, n2);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        ((PreparedStatement)this.st).setRef(n, ref);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        ((PreparedStatement)this.st).setBlob(n, blob);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        ((PreparedStatement)this.st).setClob(n, clob);
    }

    public void setArray(int n, Array array) throws SQLException {
        ((PreparedStatement)this.st).setArray(n, array);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return ((PreparedStatement)this.st).getMetaData();
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        ((PreparedStatement)this.st).setDate(n, date, calendar);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        ((PreparedStatement)this.st).setTime(n, time, calendar);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        ((PreparedStatement)this.st).setTimestamp(n, timestamp, calendar);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        ((PreparedStatement)this.st).setNull(n, n2, string);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return ((PreparedStatement)this.st).getParameterMetaData();
    }

    public void setURL(int n, URL uRL) throws SQLException {
        ((PreparedStatement)this.st).setURL(n, uRL);
    }
}

