/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class ExpressionArrayAggregate
extends Expression {
    boolean isDistinctAggregate;
    SortAndSlice sort;
    String separator = ",";
    ArrayType arrayDataType;
    Type exprType;
    Expression condition = Expression.EXPR_TRUE;

    ExpressionArrayAggregate(int n, boolean bl, Expression expression, SortAndSlice sortAndSlice, String string) {
        super(n);
        this.isDistinctAggregate = bl;
        this.sort = sortAndSlice;
        if (string != null) {
            this.separator = string;
        }
        if (n == 85) {
            this.nodes = new Expression[]{expression};
            return;
        }
        if (sortAndSlice == null) {
            this.nodes = new Expression[]{expression};
        } else {
            HsqlArrayList hsqlArrayList = sortAndSlice.getExpressionList();
            this.nodes = new Expression[hsqlArrayList.size() + 1];
            hsqlArrayList.toArray(this.nodes);
            this.nodes[hsqlArrayList.size()] = expression;
            sortAndSlice.prepare(1);
        }
    }

    @Override
    boolean isSelfAggregate() {
        return true;
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer(64);
        String string = ExpressionArrayAggregate.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        switch (this.opType) {
            case 82: {
                stringBuffer.append(' ').append("ARRAY_AGG").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 83: {
                stringBuffer.append(' ').append("GROUP_CONCAT").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            case 85: {
                stringBuffer.append(' ').append("MEDIAN").append('(');
                stringBuffer.append(string).append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionAggregate");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        switch (this.opType) {
            case 82: {
                stringBuffer.append("ARRAY_AGG").append(' ');
                break;
            }
            case 83: {
                stringBuffer.append("GROUP_CONCAT").append(' ');
                break;
            }
            case 85: {
                stringBuffer.append("MEDIAN").append(' ');
            }
        }
        if (this.getLeftNode() != null) {
            stringBuffer.append(" arg=[");
            stringBuffer.append(this.nodes[0].describe(session, n + 1));
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVariableArray, int n, HsqlList hsqlList, boolean bl) {
        HsqlList hsqlList2 = this.condition.resolveColumnReferences(session, rangeVariableArray, n, null, false);
        if (hsqlList2 != null) {
            ExpressionColumn.checkColumnsResolved(hsqlList2);
        }
        if (hsqlList == null) {
            hsqlList = new ArrayListIdentity();
        }
        hsqlList.add(this);
        return hsqlList;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        this.nodeDataTypes = new Type[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
            if (this.nodes[i].isUnresolvedParam()) {
                throw Error.error(5567);
            }
            if (this.nodes[i].dataType == null) {
                throw Error.error(5567);
            }
            this.nodeDataTypes[i] = this.nodes[i].dataType;
        }
        this.exprType = this.nodes[this.nodes.length - 1].dataType;
        if (this.exprType.isLobType()) {
            throw Error.error(5534);
        }
        if (this.exprType.isArrayType()) {
            throw Error.error(5534);
        }
        if (this.opType == 85 && !this.exprType.isNumberType()) {
            throw Error.error(5534);
        }
        RowType rowType = new RowType(this.nodeDataTypes);
        switch (this.opType) {
            case 82: {
                this.arrayDataType = new ArrayType(rowType, 1024);
                this.dataType = new ArrayType(this.exprType, 1024);
                break;
            }
            case 83: {
                this.arrayDataType = new ArrayType(rowType, 1024);
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 85: {
                this.arrayDataType = new ArrayType(this.nodeDataTypes[0], 1024);
                this.dataType = this.exprType;
            }
        }
        this.condition.resolveTypes(session, null);
    }

    @Override
    public boolean equals(Expression expression) {
        if (!(expression instanceof ExpressionArrayAggregate)) {
            return false;
        }
        ExpressionArrayAggregate expressionArrayAggregate = (ExpressionArrayAggregate)expression;
        if (this.opType == expression.opType && this.exprSubType == expression.exprSubType && this.isDistinctAggregate == expressionArrayAggregate.isDistinctAggregate && this.separator.equals(expressionArrayAggregate.separator) && this.condition.equals(expressionArrayAggregate.condition)) {
            return super.equals(expression);
        }
        return false;
    }

    @Override
    public Object updateAggregatingValue(Session session, Object object) {
        Object object2;
        if (!this.condition.testCondition(session)) {
            return object;
        }
        Object object3 = null;
        switch (this.opType) {
            case 82: 
            case 83: {
                object2 = new Object[this.nodes.length];
                for (int i = 0; i < this.nodes.length; ++i) {
                    object2[i] = this.nodes[i].getValue(session);
                }
                if (this.opType == 83 && object2[((Object[])object2).length - 1] == null) {
                    return object;
                }
                object3 = object2;
                break;
            }
            case 85: {
                object3 = this.nodes[0].getValue(session);
            }
        }
        object2 = (Object[])object;
        if (object2 == null) {
            object2 = new HsqlArrayList();
        }
        object2.add(object3);
        return object2;
    }

    @Override
    public Object getAggregatedValue(Session session, Object object) {
        int n;
        Object object2;
        if (object == null) {
            return null;
        }
        HsqlArrayList hsqlArrayList = (HsqlArrayList)object;
        Object[] objectArray = hsqlArrayList.toArray();
        if (this.isDistinctAggregate) {
            object2 = new SortAndSlice();
            ((SortAndSlice)object2).prepareSingleColumn(this.nodes.length - 1);
            this.arrayDataType.sort(session, objectArray, (SortAndSlice)object2);
            n = this.arrayDataType.deDuplicate(session, objectArray, (SortAndSlice)object2);
            objectArray = (Object[])ArrayUtil.resizeArrayIfDifferent(objectArray, n);
        }
        if (this.sort != null) {
            this.arrayDataType.sort(session, objectArray, this.sort);
        }
        switch (this.opType) {
            case 82: {
                object2 = new Object[objectArray.length];
                for (n = 0; n < hsqlArrayList.size(); ++n) {
                    Object[] objectArray2 = (Object[])objectArray[n];
                    object2[n] = objectArray2[objectArray2.length - 1];
                }
                return object2;
            }
            case 83: {
                object2 = new StringBuffer(16 * hsqlArrayList.size());
                for (n = 0; n < objectArray.length; ++n) {
                    if (n > 0) {
                        ((StringBuffer)object2).append(this.separator);
                    }
                    Object[] objectArray3 = (Object[])objectArray[n];
                    String string = this.exprType.convertToString(objectArray3[objectArray3.length - 1]);
                    ((StringBuffer)object2).append(string);
                }
                return ((StringBuffer)object2).toString();
            }
            case 85: {
                object2 = new SortAndSlice();
                ((SortAndSlice)object2).prepareSingleColumn(1);
                this.arrayDataType.sort(session, objectArray, (SortAndSlice)object2);
                int n2 = n = objectArray.length % 2 == 0 ? 1 : 0;
                if (n != 0) {
                    Object object3 = objectArray[objectArray.length / 2 - 1];
                    Object object4 = objectArray[objectArray.length / 2];
                    Object object5 = ((NumberType)this.exprType).add(object3, object4, this.exprType);
                    return ((NumberType)this.exprType).divide(session, object5, 2);
                }
                return objectArray[objectArray.length / 2];
            }
        }
        return null;
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public boolean hasCondition() {
        return this.condition != null && this.condition != Expression.EXPR_TRUE;
    }

    @Override
    public void setCondition(Expression expression) {
        this.condition = expression;
    }
}

