/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.util.java2d;

import de.javasoft.util.java2d.Synthetica2DUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class DropShadow {
    private boolean highQuality = true;
    private BufferedImage shadow = null;
    private BufferedImage originalImage = null;
    private float angle = 45.0f;
    private int distance = -5;
    private int shadowSize = 5;
    private float shadowOpacity = 0.8f;
    private Color shadowColor = new Color(0);
    private int distance_x = 0;
    private int distance_y = 0;

    protected DropShadow() {
        this.computeShadowPosition();
    }

    public DropShadow(BufferedImage bufferedImage) {
        this();
        this.setImage(bufferedImage);
    }

    public void setImage(BufferedImage bufferedImage) {
        this.originalImage = bufferedImage;
        this.refreshShadow();
    }

    public BufferedImage getImage() {
        return this.originalImage;
    }

    public boolean getHighQuality() {
        return this.highQuality;
    }

    public void setQuality(boolean bl) {
        this.highQuality = bl;
        this.refreshShadow();
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f) {
        this.angle = f;
        this.computeShadowPosition();
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int n) {
        this.distance = n;
        this.computeShadowPosition();
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color color) {
        this.shadowColor = color;
        this.refreshShadow();
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public void setShadowOpacity(float f) {
        this.shadowOpacity = f;
        this.refreshShadow();
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public void setShadowSize(int n) {
        this.shadowSize = n;
        this.refreshShadow();
    }

    private void refreshShadow() {
        if (this.originalImage != null) {
            this.shadow = this.createDropShadow(this.originalImage);
        }
    }

    private void computeShadowPosition() {
        double d = Math.toRadians(this.angle);
        this.distance_x = (int)(Math.cos(d) * (double)this.distance);
        this.distance_y = (int)(Math.sin(d) * (double)this.distance);
    }

    private BufferedImage createDropShadow(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth() + this.shadowSize * 2, bufferedImage.getHeight() + this.shadowSize * 2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, null, this.shadowSize, this.shadowSize);
        graphics2D.dispose();
        if (this.highQuality) {
            BufferedImage bufferedImage3 = this.createShadowMask(bufferedImage2);
            Synthetica2DUtils.createBlurOp(this.shadowSize).filter(bufferedImage3, bufferedImage2);
        } else {
            this.applyShadow(bufferedImage2);
        }
        return bufferedImage2;
    }

    private void applyShadow(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        int n6 = this.shadowSize - 1 >> 1;
        int n7 = this.shadowSize - n6;
        int n8 = n6;
        int n9 = n4 - n7;
        int n10 = n6;
        int n11 = n5 - n7;
        int n12 = this.shadowColor.getRGB() & 0xFFFFFF;
        int[] nArray = new int[this.shadowSize];
        int n13 = 0;
        int[] nArray2 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n14 = n7 * n4;
        float f = this.shadowOpacity / (float)this.shadowSize;
        int n15 = 0;
        int n16 = 0;
        while (n15 < n5) {
            n3 = 0;
            n13 = 0;
            n2 = 0;
            while (n2 < this.shadowSize) {
                nArray[n2] = n = nArray2[n16] >>> 24;
                n3 += n;
                ++n2;
                ++n16;
            }
            n16 -= n7;
            n2 = n8;
            while (n2 < n9) {
                n = (int)((float)n3 * f);
                nArray2[n16] = n << 24 | n12;
                n3 -= nArray[n13];
                nArray[n13] = n = nArray2[n16 + n7] >>> 24;
                n3 += n;
                if (++n13 >= this.shadowSize) {
                    n13 -= this.shadowSize;
                }
                ++n2;
                ++n16;
            }
            n16 = ++n15 * n4;
        }
        n15 = 0;
        n16 = 0;
        while (n15 < n4) {
            n3 = 0;
            n13 = 0;
            n2 = 0;
            while (n2 < this.shadowSize) {
                nArray[n2] = n = nArray2[n16] >>> 24;
                n3 += n;
                ++n2;
                n16 += n4;
            }
            n16 -= n14;
            n2 = n10;
            while (n2 < n11) {
                n = (int)((float)n3 * f);
                nArray2[n16] = n << 24 | n12;
                n3 -= nArray[n13];
                nArray[n13] = n = nArray2[n16 + n14] >>> 24;
                n3 += n;
                if (++n13 >= this.shadowSize) {
                    n13 -= this.shadowSize;
                }
                ++n2;
                n16 += n4;
            }
            n16 = ++n15;
        }
    }

    private BufferedImage createShadowMask(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.getInstance(5, this.shadowOpacity));
        graphics2D.setColor(this.shadowColor);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.dispose();
        return bufferedImage2;
    }

    public void paintShadow(Graphics graphics, int n, int n2) {
        if (this.shadow != null) {
            graphics.drawImage(this.shadow, n + this.distance_x, n2 + this.distance_y, null);
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        this.paint(graphics, n, n2, true);
    }

    public void paint(Graphics graphics, int n, int n2, boolean bl) {
        if (bl) {
            this.paintShadow(graphics, n, n2);
        }
        if (this.originalImage != null) {
            graphics.drawImage(this.originalImage, n, n2, null);
        }
    }
}

