/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollBar;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class ScrollBarPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.ScrollBarPainter";
    private static final boolean JAVA5 = System.getProperty("java.version").startsWith("1.5.");
    private static HashMap<String, Image> imgCache = new HashMap();

    protected ScrollBarPainter() {
    }

    public static ScrollBarPainter getInstance() {
        return ScrollBarPainter.getInstance(null);
    }

    public static ScrollBarPainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(ScrollBarPainter.getPainterClassName(synthContext, ScrollBarPainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = ScrollBarPainter.getInstance(synthContext, ScrollBarPainter.class, UI_KEY);
        }
        return (ScrollBarPainter)syntheticaComponentPainter;
    }

    public void paintScrollBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintScrollBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintScrollBarThumbBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    public void paintScrollBarTrackBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintScrollBarThumbBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Insets insets;
        if (n3 < 4 || n4 < 4) {
            return;
        }
        JScrollBar jScrollBar = (JScrollBar)synthContext.getComponent();
        int n6 = synthContext.getComponentState();
        boolean bl = (n6 & 2) > 0;
        boolean bl2 = jScrollBar.getClientProperty("Synthetica.MOUSE_PRESSED") == null ? false : (Boolean)jScrollBar.getClientProperty("Synthetica.MOUSE_PRESSED") & bl;
        Rectangle rectangle = (Rectangle)jScrollBar.getClientProperty("Synthetica.scrollBarTrack.bounds");
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        SynthStyle synthStyle = SynthLookAndFeel.getStyle(jScrollBar, Region.SCROLL_BAR);
        SynthContext synthContext2 = new SynthContext(jScrollBar, Region.SCROLL_BAR, synthStyle, 1024);
        Dimension dimension = (Dimension)synthStyle.get(synthContext2, "ScrollBar.minimumThumbSize");
        if (n5 == 1 && rectangle.height < dimension.height || n5 == 0 && rectangle.width < dimension.width) {
            return;
        }
        UIKey uIKey = new UIKey("scrollBarThumb." + (n5 == 0 ? "x" : "y"), new SyntheticaState(n6));
        Insets insets2 = insets = (Insets)uIKey.findProperty(synthContext, "background.insets", true, 2);
        String string = null;
        String string2 = "Synthetica.scrollBarThumb";
        if (n5 == 0) {
            string = String.valueOf(string2) + ".x.grip";
            string2 = String.valueOf(string2) + ".x.background";
            if (JAVA5 && n3 < insets.left + insets.right) {
                insets2 = insets = new Insets(4, 4, 4, 4);
            }
        } else {
            string = String.valueOf(string2) + ".y.grip";
            string2 = String.valueOf(string2) + ".y.background";
            if (JAVA5 && n4 < insets.top + insets.bottom) {
                insets2 = insets = new Insets(4, 4, 4, 4);
            }
        }
        if (bl2 && SyntheticaLookAndFeel.get(String.valueOf(string2) + ".pressed", jScrollBar) != null) {
            string2 = String.valueOf(string2) + ".pressed";
            if (SyntheticaLookAndFeel.get(String.valueOf(string) + ".pressed", jScrollBar) != null) {
                string = String.valueOf(string) + ".pressed";
            }
        } else if (bl) {
            string2 = String.valueOf(string2) + ".hover";
            if (SyntheticaLookAndFeel.get(String.valueOf(string) + ".hover", jScrollBar) != null) {
                string = String.valueOf(string) + ".hover";
            }
        }
        string2 = SyntheticaLookAndFeel.getString(string2, jScrollBar);
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (bl) {
            n7 = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.hover.animation.cycles", jScrollBar, 1);
            n8 = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.hover.animation.delay", jScrollBar, 50);
            n9 = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.hover.animation.type", jScrollBar, 1);
        } else {
            n7 = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.animation.cycles", jScrollBar, 1);
            n8 = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.animation.delay", jScrollBar, 50);
            n9 = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.animation.type", jScrollBar, 2);
        }
        ImagePainter imagePainter = new ImagePainter(jScrollBar, "thumb", n7, n8, n9, n6, graphics, n, n2, n3, n4, string2, insets, insets2, 0, 0);
        imagePainter.draw();
        string = SyntheticaLookAndFeel.getString(string, jScrollBar);
        if (string == null) {
            return;
        }
        Image image = imgCache.get(string);
        if (image == null) {
            image = new ImageIcon(SyntheticaLookAndFeel.class.getResource(string)).getImage();
            imgCache.put(string, image);
        }
        int n10 = image.getWidth(null);
        int n11 = image.getHeight(null);
        int n12 = n + (n3 - n10) / 2;
        int n13 = n2 + (n4 - n11) / 2;
        if (n5 == 0 && n3 - 4 <= n10) {
            return;
        }
        if (n5 == 1 && n4 - 4 <= n11) {
            return;
        }
        graphics.drawImage(image, n12, n13, null);
    }

    public void paintScrollBarTrackBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl;
        Insets insets;
        JScrollBar jScrollBar = (JScrollBar)synthContext.getComponent();
        UIKey uIKey = new UIKey("scrollBarTrack." + (jScrollBar.getOrientation() == 0 ? "x" : "y"), new SyntheticaState(synthContext.getComponentState()));
        Insets insets2 = insets = (Insets)uIKey.findProperty(synthContext, "background.insets", true, 2);
        jScrollBar.putClientProperty("Synthetica.scrollBarTrack.bounds", new Rectangle(n, n2, n3, n4));
        String string = "Synthetica.scrollBarTrack";
        string = jScrollBar.getOrientation() == 0 ? String.valueOf(string) + ".x.background" : String.valueOf(string) + ".y.background";
        if (!SyntheticaLookAndFeel.getBoolean("Synthetica.scrollBarTrack.hoverAndPressed.enabled", jScrollBar)) {
            string = SyntheticaLookAndFeel.getString(string, jScrollBar);
            ImagePainter imagePainter = new ImagePainter(graphics, n, n2, n3, n4, string, insets, insets2, 0, 0);
            imagePainter.draw();
            return;
        }
        boolean bl2 = bl = jScrollBar.getClientProperty("Synthetica.MOUSE_OVER") == null ? false : (Boolean)jScrollBar.getClientProperty("Synthetica.MOUSE_OVER");
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.scrollBarTrack.hoverOnButtons.enabled", jScrollBar)) {
            n = 0;
            n2 = 0;
            n3 = jScrollBar.getWidth();
            n4 = jScrollBar.getHeight();
            ArrayList<Component> arrayList = new ArrayList<Component>();
            SyntheticaLookAndFeel.findComponents("ScrollBar.button", (Container)jScrollBar, arrayList);
            for (Component component : arrayList) {
                bl |= ((JButton)component).getModel().isRollover();
            }
        }
        if (bl &= jScrollBar.getModel().getMaximum() > jScrollBar.getModel().getExtent()) {
            string = String.valueOf(string) + ".hover";
        }
        string = SyntheticaLookAndFeel.getString(string, jScrollBar);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (bl) {
            n5 = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarTrack.hover.animation.cycles", jScrollBar, 1);
            n6 = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarTrack.hover.animation.delay", jScrollBar, 50);
            n7 = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarTrack.hover.animation.type", jScrollBar, 1);
        } else {
            n5 = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarTrack.animation.cycles", jScrollBar, 1);
            n6 = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarTrack.animation.delay", jScrollBar, 50);
            n7 = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarTrack.animation.type", jScrollBar, 2);
        }
        int n8 = synthContext.getComponentState();
        if (bl) {
            n8 |= 2;
        }
        ImagePainter imagePainter = new ImagePainter(jScrollBar, "track", n5, n6, n7, n8, graphics, n, n2, n3, n4, string, insets, insets2, 0, 0);
        imagePainter.draw();
    }

    public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
        JScrollBar jScrollBar = (JScrollBar)synthContext.getComponent();
        int n4 = jScrollBar.getOrientation();
        int n5 = super.getCacheHash(synthContext, n, n2, n3, string);
        n5 = 31 * n5 + n4;
        return n5;
    }
}

