/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.SynthContext;

public class PanelPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.PanelPainter";

    protected PanelPainter() {
    }

    public static PanelPainter getInstance() {
        return PanelPainter.getInstance(null);
    }

    public static PanelPainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(PanelPainter.getPainterClassName(synthContext, PanelPainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = PanelPainter.getInstance(synthContext, PanelPainter.class, UI_KEY);
        }
        return (PanelPainter)syntheticaComponentPainter;
    }

    public void paintPanelBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintPanelBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JComponent jComponent = synthContext.getComponent();
        Color color = jComponent.getBackground();
        if (jComponent.isOpaque()) {
            String string = SyntheticaLookAndFeel.getString("Synthetica.panel.background.image", jComponent);
            boolean bl = SyntheticaLookAndFeel.getBoolean("Synthetica.panel.background.image.enabled", jComponent, true);
            if (!(bl && string != null || color == null || color instanceof ColorUIResource)) {
                graphics.setColor(color);
                graphics.fillRect(n, n2, n3, n4);
            } else if (bl && string != null && (color == null || color != null && color instanceof ColorUIResource)) {
                Insets insets;
                int n5 = SyntheticaLookAndFeel.getBoolean("Synthetica.panel.background.horizontalTiled", jComponent, false) ? 1 : 0;
                int n6 = SyntheticaLookAndFeel.getBoolean("Synthetica.panel.background.verticalTiled", jComponent, false) ? 1 : 0;
                Insets insets2 = insets = SyntheticaLookAndFeel.getInsets("Synthetica.panel.background.image.insets", (Component)jComponent, false);
                String string2 = SyntheticaLookAndFeel.getString("Synthetica.panel.background.image.origin", jComponent);
                if (string2 != null && string2.equals("PANEL")) {
                    ImagePainter imagePainter = new ImagePainter(graphics, n, n2, n3, n4, string, insets, insets2, n5, n6);
                    imagePainter.draw();
                } else {
                    Object object;
                    JRootPane jRootPane = string2 != null && string2.equals("CONTENT_PANE") ? jComponent.getRootPane().getContentPane() : jComponent.getRootPane();
                    Rectangle rectangle = jRootPane.getBounds();
                    rectangle.width = Math.max(rectangle.width, SyntheticaLookAndFeel.getInt("Synthetica.panel.minimumBackgroundWidth", jComponent, rectangle.width));
                    rectangle.height = Math.max(rectangle.height, SyntheticaLookAndFeel.getInt("Synthetica.panel.minimumBackgroundHeight", jComponent, rectangle.height));
                    Component component = this.findRelevantParent(jComponent);
                    Rectangle rectangle2 = SwingUtilities.convertRectangle(component, new Rectangle(n, n2, n3, n4), jRootPane);
                    if (component instanceof JViewport) {
                        object = (JViewport)component;
                        Point point = SwingUtilities.convertPoint(jComponent, new Point(), (Component)object);
                        Point point2 = ((JViewport)object).getViewPosition();
                        rectangle2.x += point.x + point2.x;
                        rectangle2.y += point.y + point2.y;
                        Point point3 = SwingUtilities.convertPoint((Component)object, new Point(), jRootPane);
                        Dimension dimension = ((JViewport)object).getViewSize();
                        rectangle.width = dimension.width + point3.x;
                        rectangle.height = dimension.height + point3.y;
                    }
                    object = new ImagePainter(graphics, n - rectangle2.x, n2 - rectangle2.y, rectangle.width, rectangle.height, string, insets, insets2, n5, n6);
                    ((ImagePainter)object).draw();
                }
            }
        }
    }

    private Component findRelevantParent(Component component) {
        Container container = null;
        Container container2 = component.getParent();
        while (container2 != null) {
            if (container2 instanceof JViewport) {
                container = container2;
            }
            container2 = container2.getParent();
        }
        return container == null ? component : container;
    }

    public Cacheable.ScaleType getCacheScaleType(String string) {
        return Cacheable.ScaleType.NINE_SQUARE;
    }

    public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
        return -1;
    }
}

