/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.util.OS;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.security.AccessControlException;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Popup
extends javax.swing.Popup {
    public static final String POPUP_BACKGROUND = "POPUP_BACKGROUND";
    public static final String POPUP_LIGHTWEIGHT = "POPUP_LIGHTWEIGHT";
    private static final boolean JAVA5 = System.getProperty("java.version").startsWith("1.5.");
    private Component contents;
    private int x;
    private int y;
    private javax.swing.Popup popup;
    private Container heavyWeightContainer;
    private boolean lightWeight;

    public Popup(Component component, Component component2, int n, int n2, javax.swing.Popup popup) {
        this.contents = component2;
        this.popup = popup;
        this.x = n;
        this.y = n2;
        Container container = component2.getParent();
        ((JComponent)container).putClientProperty(POPUP_BACKGROUND, null);
        ((JComponent)container).putClientProperty(POPUP_LIGHTWEIGHT, null);
        if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(null)) {
            ((JComponent)container).setDoubleBuffered(false);
        }
        this.lightWeight = true;
        while (container != null) {
            if (container instanceof JWindow || container instanceof Panel || container instanceof Window) {
                this.heavyWeightContainer = container;
                this.lightWeight = false;
                break;
            }
            container = container.getParent();
        }
        this.internalFrameCursorBugfix(component);
        if (this.heavyWeightContainer != null && OS.getCurrentOS() == OS.Mac && !UIManager.getBoolean("Synthetica.popup.osShadow.enabled")) {
            this.heavyWeightContainer.setBackground(new Color(0x1000000, true));
            this.heavyWeightContainer.setBackground(new Color(0, true));
            if (this.heavyWeightContainer instanceof JWindow) {
                ((JWindow)this.heavyWeightContainer).getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
            }
        }
    }

    private void internalFrameCursorBugfix(Component component) {
        if (component != null && component instanceof JInternalFrame) {
            Container container = ((JInternalFrame)component).getTopLevelAncestor();
            Cursor cursor = Cursor.getPredefinedCursor(0);
            if (container instanceof JFrame) {
                ((JFrame)container).getGlassPane().setCursor(cursor);
                ((JFrame)container).getGlassPane().setVisible(false);
            } else if (container instanceof JWindow) {
                ((JWindow)container).getGlassPane().setCursor(cursor);
                ((JWindow)container).getGlassPane().setVisible(false);
            } else if (container instanceof JDialog) {
                ((JDialog)container).getGlassPane().setCursor(cursor);
                ((JDialog)container).getGlassPane().setVisible(false);
            } else if (container instanceof JApplet) {
                ((JApplet)container).getGlassPane().setCursor(cursor);
                ((JApplet)container).getGlassPane().setVisible(false);
            }
        }
    }

    public void hide() {
        Container container = this.contents.getParent();
        this.popup.hide();
        if (container instanceof JComponent) {
            ((JComponent)container).putClientProperty(POPUP_BACKGROUND, null);
        }
        if (this.heavyWeightContainer != null) {
            this.heavyWeightContainer = null;
            if (JAVA5) {
                while (container != null) {
                    if (container instanceof JFrame) {
                        ((JFrame)container).update(container.getGraphics());
                    }
                    container = container.getParent();
                }
            }
        }
        this.contents = null;
        this.popup = null;
    }

    public javax.swing.Popup getDelegate() {
        return this.popup;
    }

    public void show() {
        boolean bl;
        boolean bl2 = bl = this.contents instanceof JPopupMenu && SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.blur.enabled", this.contents);
        if (bl && this.heavyWeightContainer == null) {
            this.heavyWeightContainer = this.contents.getParent();
        }
        if (this.heavyWeightContainer == null || !SyntheticaLookAndFeel.getBoolean("Synthetica.popupRobot.enabled", this.contents.getParent(), true)) {
            this.popup.show();
            return;
        }
        if (this.contents instanceof JPopupMenu && ((JPopupMenu)this.contents).getComponentCount() > 0 && !(((JPopupMenu)this.contents).getComponent(0) instanceof JMenuItem) && ((JPopupMenu)this.contents).getComponent(0).isFocusable()) {
            this.showPopup(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Popup.this.showPopup(bl);
                }
            });
        }
    }

    private void showPopup(boolean bl) {
        if (this.heavyWeightContainer == null) {
            return;
        }
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.popupRobot.enabled", this.contents.getParent(), true) && (SyntheticaLookAndFeel.isWindowOpacityEnabled(null) || bl)) {
            ((JComponent)this.contents.getParent()).putClientProperty(POPUP_BACKGROUND, this.snapshot());
            ((JComponent)this.contents.getParent()).putClientProperty(POPUP_LIGHTWEIGHT, this.lightWeight);
        }
        this.popup.show();
        if (this.heavyWeightContainer instanceof Window && !SyntheticaLookAndFeel.isWindowOpacityEnabled(null) && !bl) {
            SyntheticaLookAndFeel.setWindowOpaque((Window)this.heavyWeightContainer, false);
        }
    }

    private BufferedImage snapshot() {
        BufferedImage bufferedImage = null;
        try {
            Robot robot = new Robot();
            Dimension dimension = this.heavyWeightContainer.getPreferredSize();
            if (dimension.width > 0 && dimension.height > 0) {
                Rectangle rectangle = new Rectangle(this.x, this.y, dimension.width, dimension.height);
                bufferedImage = robot.createScreenCapture(rectangle);
            }
        }
        catch (AccessControlException accessControlException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bufferedImage;
    }
}

