/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfMapper;
import com.lowagie.text.rtf.document.RtfDocumentHeader;
import com.lowagie.text.rtf.document.RtfInfoElement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfDocument
extends RtfElement {
    private ByteArrayOutputStream data = new ByteArrayOutputStream();
    private RtfMapper mapper = new RtfMapper(this);
    private RtfDocumentHeader documentHeader = new RtfDocumentHeader(this);
    private ArrayList previousRandomInts = null;
    private boolean autogenerateTOCEntries = false;
    private static final byte[] RTF_DOCUMENT = "\\rtf1".getBytes();

    public RtfDocument() {
        super(null);
        this.documentHeader.init();
        this.previousRandomInts = new ArrayList();
    }

    public byte[] writeDocument() {
        ByteArrayOutputStream docStream = new ByteArrayOutputStream();
        try {
            docStream.write(RtfBasicElement.OPEN_GROUP);
            docStream.write(RTF_DOCUMENT);
            docStream.write(this.documentHeader.write());
            this.data.writeTo(docStream);
            docStream.write(RtfBasicElement.CLOSE_GROUP);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return docStream.toByteArray();
    }

    public void add(RtfBasicElement element) {
        try {
            if (element instanceof RtfInfoElement) {
                this.documentHeader.addInfoElement((RtfInfoElement)element);
            } else {
                this.data.write(element.write());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public RtfMapper getMapper() {
        return this.mapper;
    }

    public int getRandomInt() {
        Integer newInt = null;
        while (this.previousRandomInts.contains(newInt = new Integer((int)(Math.random() * 2.147483647E9)))) {
        }
        this.previousRandomInts.add(newInt);
        return newInt;
    }

    public RtfDocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    public String filterSpecialChar(String str, boolean useHex) {
        int length = str.length();
        char z = 'z';
        StringBuffer ret = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\') {
                ret.append("\\\\");
                continue;
            }
            if (ch == '\n') {
                ret.append("\\par ");
                continue;
            }
            if (ch == '\t') {
                ret.append("\\tab");
                continue;
            }
            if (ch > z) {
                if (useHex) {
                    ret.append("\\'").append(Long.toHexString(ch));
                    continue;
                }
                ret.append("\\u").append((long)ch).append('?');
                continue;
            }
            ret.append(ch);
        }
        String s = ret.toString();
        if (s.indexOf("$newpage$") >= 0) {
            String before = s.substring(0, s.indexOf("$newpage$"));
            String after = s.substring(s.indexOf("$newpage$") + 9);
            ret = new StringBuffer(before);
            ret.append("\\page\\par ");
            ret.append(after);
            return ret.toString();
        }
        return s;
    }

    public void setAutogenerateTOCEntries(boolean autogenerate) {
        this.autogenerateTOCEntries = autogenerate;
    }

    public boolean getAutogenerateTOCEntries() {
        return this.autogenerateTOCEntries;
    }
}

