/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html.simpleparser;

import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class IncTable {
    public HashMap props = new HashMap();
    public ArrayList rows = new ArrayList();
    public ArrayList cols;

    public IncTable(HashMap props) {
        this.props.putAll(props);
    }

    public void addCol(PdfPCell cell) {
        if (this.cols == null) {
            this.cols = new ArrayList();
        }
        this.cols.add(cell);
    }

    public void addCols(ArrayList ncols) {
        if (this.cols == null) {
            this.cols = new ArrayList(ncols);
        } else {
            this.cols.addAll(ncols);
        }
    }

    public void endRow() {
        if (this.cols != null) {
            Collections.reverse(this.cols);
            this.rows.add(this.cols);
            this.cols = null;
        }
    }

    public ArrayList getRows() {
        return this.rows;
    }

    public PdfPTable buildTable() {
        if (this.rows.size() == 0) {
            return new PdfPTable(1);
        }
        int ncol = 0;
        ArrayList c0 = (ArrayList)this.rows.get(0);
        for (int k = 0; k < c0.size(); ++k) {
            ncol += ((PdfPCell)c0.get(k)).getColspan();
        }
        PdfPTable table = new PdfPTable(ncol);
        String width = (String)this.props.get("width");
        if (width == null) {
            table.setWidthPercentage(100.0f);
        } else if (width.endsWith("%")) {
            table.setWidthPercentage(Float.valueOf(width.substring(0, width.length() - 1)).floatValue());
        } else {
            table.setTotalWidth(Float.valueOf(width).floatValue());
            table.setLockedWidth(true);
        }
        for (int row = 0; row < this.rows.size(); ++row) {
            ArrayList col = (ArrayList)this.rows.get(row);
            for (int k = 0; k < col.size(); ++k) {
                table.addCell((PdfPCell)col.get(k));
            }
        }
        return table;
    }
}

