/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import snaq.db.CachedCallableStatement;
import snaq.db.CachedPreparedStatement;
import snaq.db.CachedStatement;
import snaq.db.ConnectionPool;
import snaq.db.StatementListener;
import snaq.util.Reusable;

public final class CacheConnection
implements Connection,
StatementListener,
Reusable {
    private static int DEFAULT_RESULTSET_TYPE = 1003;
    private static int DEFAULT_RESULTSET_CONCURRENCY = 1007;
    private static int DEFAULT_RESULTSET_HOLDABILITY = 1;
    protected ConnectionPool pool;
    protected Connection con;
    protected List ss = new ArrayList();
    protected List ssUsed = new ArrayList();
    protected Map ps = new HashMap();
    protected List psUsed = new ArrayList();
    protected Map cs = new HashMap();
    protected List csUsed = new ArrayList();
    protected List nonCachable = new ArrayList();
    private boolean cacheS;
    private boolean cacheP;
    private boolean cacheC;
    private int ssReq;
    private int ssHit;
    private int psReq;
    private int psHit;
    private int csReq;
    private int csHit;
    private boolean open = true;

    public CacheConnection(ConnectionPool connectionPool, Connection connection) {
        this.pool = connectionPool;
        this.con = connection;
        this.setCacheAll(true);
        this.csHit = 0;
        this.csReq = 0;
        this.psHit = 0;
        this.psReq = 0;
        this.ssHit = 0;
        this.ssReq = 0;
    }

    void setOpen() {
        this.open = true;
    }

    boolean isOpen() {
        return this.open;
    }

    public void setCacheStatements(boolean bl) {
        if (this.cacheS && !bl) {
            try {
                this.flushSpareStatements();
            }
            catch (SQLException sQLException) {
                this.pool.log(sQLException);
            }
        }
        this.cacheS = bl;
    }

    public void setCachePreparedStatements(boolean bl) {
        if (this.cacheP && !bl) {
            try {
                this.flushSparePreparedStatements();
            }
            catch (SQLException sQLException) {
                this.pool.log(sQLException);
            }
        }
        this.cacheP = bl;
    }

    public void setCacheCallableStatements(boolean bl) {
        if (this.cacheC && !bl) {
            try {
                this.flushSpareCallableStatements();
            }
            catch (SQLException sQLException) {
                this.pool.log(sQLException);
            }
        }
        this.cacheC = bl;
    }

    public void setCacheAll(boolean bl) {
        this.setCacheStatements(bl);
        this.setCachePreparedStatements(bl);
        this.setCacheCallableStatements(bl);
    }

    public boolean isCachingAllStatements() {
        return this.cacheS && this.cacheP && this.cacheC;
    }

    public boolean isCachingStatements() {
        return this.cacheS;
    }

    public boolean isCachingPreparedStatements() {
        return this.cacheP;
    }

    public boolean isCachingCallableStatements() {
        return this.cacheC;
    }

    public Connection getRawConnection() {
        return this.con;
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(DEFAULT_RESULTSET_TYPE, DEFAULT_RESULTSET_CONCURRENCY, DEFAULT_RESULTSET_HOLDABILITY);
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, DEFAULT_RESULTSET_HOLDABILITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        CachedStatement cachedStatement = null;
        if (!this.cacheS) {
            cachedStatement = new CachedStatement(this.con.createStatement(n, n2, n3));
            cachedStatement.setStatementListener(this);
            cachedStatement.setOpen();
        } else {
            List list = this.ss;
            synchronized (list) {
                ++this.ssReq;
                Iterator iterator = this.ss.iterator();
                while (iterator.hasNext()) {
                    CachedStatement cachedStatement2 = (CachedStatement)iterator.next();
                    if (cachedStatement2.getResultSetType() != n || cachedStatement2.getResultSetConcurrency() != n2 || cachedStatement2.getResultSetHoldability() != n3) continue;
                    cachedStatement = cachedStatement2;
                    iterator.remove();
                }
                if (cachedStatement != null) {
                    cachedStatement.setOpen();
                    ++this.ssHit;
                    if (this.pool.isDebug()) {
                        this.pool.log("Statement cache hit [" + cachedStatement.getParametersString() + "] - " + this.calcHitRate(this.ssHit, this.ssReq));
                    }
                } else {
                    cachedStatement = new CachedStatement(this.con.createStatement(n, n2, n3));
                    cachedStatement.setStatementListener(this);
                    cachedStatement.setOpen();
                    if (this.pool.isDebug()) {
                        this.pool.log("Statement cache miss [" + cachedStatement.getParametersString() + "] - " + this.calcHitRate(this.ssHit, this.ssReq));
                    }
                }
            }
        }
        this.ssUsed.add(cachedStatement);
        return cachedStatement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, DEFAULT_RESULTSET_TYPE, DEFAULT_RESULTSET_CONCURRENCY, DEFAULT_RESULTSET_HOLDABILITY);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, DEFAULT_RESULTSET_HOLDABILITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        CachedPreparedStatement cachedPreparedStatement = null;
        if (!this.cacheP) {
            cachedPreparedStatement = new CachedPreparedStatement(string, this.con.prepareStatement(string, n, n2, n3));
            cachedPreparedStatement.setStatementListener(this);
            cachedPreparedStatement.setOpen();
        } else {
            Map map = this.ps;
            synchronized (map) {
                ++this.psReq;
                List list = (List)this.ps.get(string);
                if (list != null && !list.isEmpty()) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        CachedPreparedStatement cachedPreparedStatement2 = (CachedPreparedStatement)iterator.next();
                        if (cachedPreparedStatement2.getResultSetType() != n || cachedPreparedStatement2.getResultSetConcurrency() != n2 || cachedPreparedStatement2.getResultSetHoldability() != n3) continue;
                        cachedPreparedStatement = cachedPreparedStatement2;
                        iterator.remove();
                    }
                    if (list.isEmpty()) {
                        this.ps.remove(string);
                    }
                }
                if (cachedPreparedStatement != null) {
                    cachedPreparedStatement.setOpen();
                    ++this.psHit;
                    if (this.pool.isDebug()) {
                        this.pool.log("PreparedStatement cache hit [" + string + "," + cachedPreparedStatement.getParametersString() + "] - " + this.calcHitRate(this.psHit, this.psReq));
                    }
                } else {
                    cachedPreparedStatement = new CachedPreparedStatement(string, this.con.prepareStatement(string, n, n2, n3));
                    cachedPreparedStatement.setStatementListener(this);
                    cachedPreparedStatement.setOpen();
                    if (this.pool.isDebug()) {
                        this.pool.log("PreparedStatement cache miss [" + string + "," + cachedPreparedStatement.getParametersString() + "] - " + this.calcHitRate(this.psHit, this.psReq));
                    }
                }
            }
        }
        this.psUsed.add(cachedPreparedStatement);
        return cachedPreparedStatement;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, DEFAULT_RESULTSET_TYPE, DEFAULT_RESULTSET_CONCURRENCY, DEFAULT_RESULTSET_HOLDABILITY);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string, n, n2, DEFAULT_RESULTSET_HOLDABILITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        CachedCallableStatement cachedCallableStatement = null;
        if (!this.cacheC) {
            cachedCallableStatement = new CachedCallableStatement(string, this.con.prepareCall(string));
            cachedCallableStatement.setStatementListener(this);
            cachedCallableStatement.setOpen();
        } else {
            Map map = this.cs;
            synchronized (map) {
                Object object;
                ++this.csReq;
                List list = (List)this.cs.get(string);
                if (list != null && !list.isEmpty()) {
                    object = list.iterator();
                    while (object.hasNext()) {
                        CachedCallableStatement cachedCallableStatement2 = (CachedCallableStatement)object.next();
                        if (cachedCallableStatement2.getResultSetType() != n || cachedCallableStatement2.getResultSetConcurrency() != n2 || cachedCallableStatement2.getResultSetHoldability() != n3) continue;
                        cachedCallableStatement = cachedCallableStatement2;
                        object.remove();
                    }
                    if (list.isEmpty()) {
                        this.cs.remove(string);
                    }
                }
                if (cachedCallableStatement != null) {
                    cachedCallableStatement.setOpen();
                    ++this.csHit;
                    if (this.pool.isDebug()) {
                        this.pool.log("CallableStatement cache hit [" + string + "," + cachedCallableStatement.getParametersString() + "] - " + this.calcHitRate(this.csHit, this.csReq));
                    }
                } else {
                    object = this.con.prepareCall(string);
                    cachedCallableStatement = new CachedCallableStatement(string, (CallableStatement)object);
                    cachedCallableStatement.setStatementListener(this);
                    cachedCallableStatement.setOpen();
                    if (this.pool.isDebug()) {
                        this.pool.log("CallableStatement cache miss [" + string + "," + cachedCallableStatement.getParametersString() + "] - " + this.calcHitRate(this.csHit, this.csReq));
                    }
                }
            }
        }
        this.csUsed.add(cachedCallableStatement);
        return cachedCallableStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statementClosed(CachedStatement cachedStatement) throws SQLException {
        if (cachedStatement instanceof CachedPreparedStatement) {
            Map map = this.ps;
            synchronized (map) {
                String string = ((CachedPreparedStatement)cachedStatement).getSQLString();
                this.psUsed.remove(cachedStatement);
                if (!this.cacheP) {
                    cachedStatement.release();
                } else {
                    try {
                        cachedStatement.recycle();
                        ArrayList<CachedStatement> arrayList = (ArrayList<CachedStatement>)this.ps.get(string);
                        if (arrayList == null) {
                            arrayList = new ArrayList<CachedStatement>();
                            this.ps.put(string, arrayList);
                        }
                        arrayList.add(cachedStatement);
                    }
                    catch (SQLException sQLException) {
                        cachedStatement.release();
                    }
                }
            }
        }
        if (cachedStatement instanceof CachedCallableStatement) {
            Map map = this.cs;
            synchronized (map) {
                String string = ((CachedCallableStatement)cachedStatement).getSQLString();
                this.csUsed.remove(cachedStatement);
                if (!this.cacheC) {
                    cachedStatement.release();
                } else {
                    try {
                        cachedStatement.recycle();
                        ArrayList<CachedStatement> arrayList = (ArrayList<CachedStatement>)this.cs.get(string);
                        if (arrayList == null) {
                            arrayList = new ArrayList<CachedStatement>();
                            this.cs.put(string, arrayList);
                        }
                        arrayList.add(cachedStatement);
                    }
                    catch (SQLException sQLException) {
                        cachedStatement.release();
                    }
                }
            }
        }
        if (cachedStatement instanceof CachedStatement) {
            List list = this.ss;
            synchronized (list) {
                this.ssUsed.remove(cachedStatement);
                if (!this.cacheS) {
                    cachedStatement.release();
                } else {
                    try {
                        cachedStatement.recycle();
                        this.ss.add(cachedStatement);
                    }
                    catch (SQLException sQLException) {
                        cachedStatement.release();
                    }
                }
            }
        }
    }

    private String calcHitRate(int n, int n2) {
        return n2 == 0 ? "" : (float)n / (float)n2 * 100.0f + "% hit rate";
    }

    public String nativeSQL(String string) throws SQLException {
        return this.con.nativeSQL(string);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.con.setAutoCommit(bl);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.con.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.con.commit();
    }

    public void rollback() throws SQLException {
        this.con.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() throws SQLException {
        List list;
        int n;
        if (this.cacheS) {
            int n2 = n = this.ssUsed != null ? this.ssUsed.size() : 0;
            if (n > 0) {
                if (this.pool.isDebug()) {
                    this.pool.log("Cleaning " + n + " cached Statement" + (n > 1 ? "s" : ""));
                }
                list = this.ssUsed;
                synchronized (list) {
                    while (!this.ssUsed.isEmpty()) {
                        ((Statement)this.ssUsed.remove(0)).close();
                    }
                }
            }
        } else {
            this.flushOpenStatements();
            this.flushSpareStatements();
        }
        if (this.cacheP) {
            int n3 = n = this.psUsed != null ? this.psUsed.size() : 0;
            if (n > 0) {
                if (this.pool.isDebug()) {
                    this.pool.log("Cleaning " + n + " cached PreparedStatement" + (n > 1 ? "s" : ""));
                }
                list = this.psUsed;
                synchronized (list) {
                    while (!this.psUsed.isEmpty()) {
                        ((CachedPreparedStatement)this.psUsed.remove(0)).close();
                    }
                }
            }
        } else {
            this.flushOpenPreparedStatements();
            this.flushSparePreparedStatements();
        }
        if (this.cacheC) {
            int n4 = n = this.csUsed != null ? this.csUsed.size() : 0;
            if (n > 0) {
                if (this.pool.isDebug()) {
                    this.pool.log("Cleaning " + n + " cached CallableStatement" + (n > 1 ? "s" : ""));
                }
                list = this.csUsed;
                synchronized (list) {
                    while (!this.csUsed.isEmpty()) {
                        ((CachedCallableStatement)this.csUsed.remove(0)).close();
                    }
                }
            }
        } else {
            this.flushOpenCallableStatements();
            this.flushSpareCallableStatements();
        }
        this.flushOpenNonCachableStatements();
        if (!this.getAutoCommit()) {
            try {
                this.rollback();
            }
            catch (SQLException sQLException) {
                this.pool.log(sQLException);
            }
            this.setAutoCommit(true);
        }
        this.clearWarnings();
        Map map = this.getTypeMap();
        if (map != null) {
            map.clear();
        }
    }

    public void close() throws SQLException {
        if (!this.open) {
            throw new SQLException("Connection already closed");
        }
        this.open = false;
        this.pool.freeConnection(this);
    }

    public int getSpareStatementCount() {
        return this.ss.size();
    }

    public int getOpenStatementCount() {
        return this.ssUsed.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSparePreparedStatementCount() {
        int n = 0;
        Map map = this.ps;
        synchronized (map) {
            Iterator iterator = this.ps.values().iterator();
            while (iterator.hasNext()) {
                n += ((List)iterator.next()).size();
            }
        }
        return n;
    }

    public int getOpenPreparedStatementCount() {
        return this.psUsed.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSpareCallableStatementCount() {
        int n = 0;
        Map map = this.cs;
        synchronized (map) {
            Iterator iterator = this.cs.values().iterator();
            while (iterator.hasNext()) {
                n += ((List)iterator.next()).size();
            }
        }
        return n;
    }

    public int getOpenCallableStatementCount() {
        return this.csUsed.size();
    }

    public int getOpenNonCachableStatementCount() {
        return this.nonCachable.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushSpareStatements() throws SQLException {
        int n;
        int n2 = n = this.ss != null ? this.ss.size() : 0;
        if (n > 0) {
            if (this.pool.isDebug()) {
                this.pool.log("Closing " + n + " cached Statement" + (n > 1 ? "s" : ""));
            }
            List list = this.ss;
            synchronized (list) {
                while (!this.ss.isEmpty()) {
                    ((CachedStatement)this.ss.remove(0)).release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushOpenStatements() throws SQLException {
        int n;
        int n2 = n = this.ssUsed != null ? this.ssUsed.size() : 0;
        if (n > 0) {
            if (this.pool.isDebug()) {
                this.pool.log("Closing " + n + " open Statement" + (n > 1 ? "s" : ""));
            }
            List list = this.ssUsed;
            synchronized (list) {
                while (!this.ssUsed.isEmpty()) {
                    ((CachedStatement)this.ssUsed.remove(0)).release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushSparePreparedStatements() throws SQLException {
        int n;
        int n2 = n = this.ps != null ? this.ps.size() : 0;
        if (n > 0) {
            if (this.pool.isDebug()) {
                this.pool.log("Closing " + n + " cached PreparedStatement" + (n > 1 ? "s" : ""));
            }
            Map map = this.ps;
            synchronized (map) {
                Iterator iterator = this.ps.values().iterator();
                while (iterator.hasNext()) {
                    List list = (List)iterator.next();
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        ((CachedPreparedStatement)iterator2.next()).release();
                    }
                }
                this.ps.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushOpenPreparedStatements() throws SQLException {
        int n;
        int n2 = n = this.psUsed != null ? this.psUsed.size() : 0;
        if (n > 0) {
            if (this.pool.isDebug()) {
                this.pool.log("Closing " + n + " open PreparedStatement" + (n > 1 ? "s" : ""));
            }
            List list = this.psUsed;
            synchronized (list) {
                while (!this.psUsed.isEmpty()) {
                    ((CachedPreparedStatement)this.psUsed.remove(0)).release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushSpareCallableStatements() throws SQLException {
        int n;
        int n2 = n = this.cs != null ? this.cs.size() : 0;
        if (n > 0) {
            if (this.pool.isDebug()) {
                this.pool.log("Closing " + n + " cached CallableStatement" + (n > 1 ? "s" : ""));
            }
            Map map = this.cs;
            synchronized (map) {
                Iterator iterator = this.cs.values().iterator();
                while (iterator.hasNext()) {
                    List list = (List)iterator.next();
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        ((CachedCallableStatement)iterator2.next()).release();
                    }
                }
                this.cs.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushOpenCallableStatements() throws SQLException {
        int n;
        int n2 = n = this.csUsed != null ? this.csUsed.size() : 0;
        if (n > 0) {
            if (this.pool.isDebug()) {
                this.pool.log("Closing " + n + " open CallableStatement" + (n > 1 ? "s" : ""));
            }
            List list = this.csUsed;
            synchronized (list) {
                while (!this.csUsed.isEmpty()) {
                    ((CachedCallableStatement)this.csUsed.remove(0)).release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushOpenNonCachableStatements() throws SQLException {
        int n;
        int n2 = n = this.nonCachable != null ? this.nonCachable.size() : 0;
        if (n > 0) {
            if (this.pool.isDebug()) {
                this.pool.log("Closing " + n + " open non-cachable Statement" + (n > 1 ? "s" : ""));
            }
            List list = this.nonCachable;
            synchronized (list) {
                while (!this.nonCachable.isEmpty()) {
                    try {
                        ((Statement)this.nonCachable.remove(0)).close();
                    }
                    catch (SQLException sQLException) {
                        this.pool.log(sQLException);
                    }
                }
            }
        }
    }

    public void release() throws SQLException {
        this.open = false;
        ArrayList<SQLException> arrayList = new ArrayList<SQLException>();
        try {
            this.flushSpareStatements();
            this.flushOpenStatements();
        }
        catch (SQLException sQLException) {
            arrayList.add(sQLException);
        }
        try {
            this.flushSparePreparedStatements();
            this.flushOpenPreparedStatements();
        }
        catch (SQLException sQLException) {
            arrayList.add(sQLException);
        }
        try {
            this.flushSpareCallableStatements();
            this.flushOpenCallableStatements();
        }
        catch (SQLException sQLException) {
            arrayList.add(sQLException);
        }
        try {
            this.flushOpenNonCachableStatements();
        }
        catch (SQLException sQLException) {
            arrayList.add(sQLException);
        }
        try {
            this.con.close();
        }
        catch (SQLException sQLException) {
            arrayList.add(sQLException);
        }
        if (!arrayList.isEmpty()) {
            SQLException sQLException = new SQLException("Problem releasing connection resources");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                SQLException sQLException2 = (SQLException)iterator.next();
                sQLException.setNextException(sQLException2);
                sQLException = sQLException2;
            }
            throw sQLException;
        }
    }

    public boolean isClosed() throws SQLException {
        return this.con.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.con.getMetaData();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.con.setReadOnly(bl);
    }

    public boolean isReadOnly() throws SQLException {
        return this.con.isReadOnly();
    }

    public void setCatalog(String string) throws SQLException {
        this.con.setCatalog(string);
    }

    public String getCatalog() throws SQLException {
        return this.con.getCatalog();
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.con.setTransactionIsolation(n);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.con.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.con.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.con.clearWarnings();
    }

    public Map getTypeMap() throws SQLException {
        return this.con.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.con.setTypeMap(map);
    }

    public void setHoldability(int n) throws SQLException {
        this.con.setHoldability(n);
    }

    public int getHoldability() throws SQLException {
        return this.con.getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.con.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        return this.con.setSavepoint(string);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.con.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.con.releaseSavepoint(savepoint);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        PreparedStatement preparedStatement = this.con.prepareStatement(string, n);
        this.nonCachable.add(preparedStatement);
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        PreparedStatement preparedStatement = this.con.prepareStatement(string, nArray);
        this.nonCachable.add(preparedStatement);
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        PreparedStatement preparedStatement = this.con.prepareStatement(string, stringArray);
        this.nonCachable.add(preparedStatement);
        return preparedStatement;
    }
}

