/*
 * Decompiled with CFR 0.152.
 */
package venue;

import database.DBUtil;
import database.SQLWhereClause;
import java.sql.Timestamp;
import member.Member;
import printout.xls.ExcelCellFormat;
import printout.xls.ExcelFormat;
import printout.xls.ExcelPrintout;
import system.Lang;
import util.RecordList;
import util.TimeUtil;
import venue.Venue;
import venue.VenueRequest;
import venue.VenueRequestEquipment;

public class VenueRequestReport {
    public ExcelCellFormat FORMAT_AC15 = new ExcelCellFormat(ExcelCellFormat.STRING, String.valueOf(ExcelFormat.AC) + ExcelFormat.FS15);
    private Timestamp gStartDate;
    private Timestamp gEndDate;
    private int gVenueSeq;
    private boolean gGroupByDate;
    private boolean gGroupByMonth;

    public VenueRequestReport(Timestamp start_date, Timestamp end_date, int venue_seq, boolean group_by_date, boolean group_by_month) {
        this.gStartDate = start_date;
        this.gEndDate = end_date;
        this.gVenueSeq = venue_seq;
        this.gGroupByDate = group_by_date;
        this.gGroupByMonth = group_by_month;
        RecordList vnrs = this.getVenueRequests();
        RecordList vnres = this.getVenueRequestEquipments();
        ExcelPrintout p = new ExcelPrintout(ExcelFormat.PA4, new int[]{32, 19, 19, 24, 26, 12, 22, 23});
        p.addHeader(Lang.set("\u5834\u5730\u7533\u8acb\u5831\u8868"), new String[]{String.valueOf(Lang.set("\u4f7f\u7528\u65e5\u671f: ")) + TimeUtil.getStringByDate(start_date) + Lang.set(" \u81f3 ") + TimeUtil.getStringByDate(end_date), String.valueOf(Lang.set("\u5834\u5730: ")) + (this.gVenueSeq == -1 ? Lang.set("\u5168\u90e8") : new Venue(this.gVenueSeq).getName())});
        int row = p.getRowNumAfterHeader();
        p.addCell(0, row, Lang.set("\u4f7f\u7528\u65e5\u671f"), p.TL);
        p.addCell(1, row, Lang.set("\u958b\u59cb"), p.TL);
        p.addCell(2, row, Lang.set("\u7d50\u675f"), p.TL);
        p.addCell(3, row, Lang.set("\u5834\u5730"), p.TL);
        p.addCell(4, row, Lang.set("\u4f7f\u7528\u7fa4\u7d44"), p.TL);
        p.addCell(5, row, Lang.set("\u4eba\u6578"), p.TL);
        p.addCell(6, row, Lang.set("\u7528\u9014"), p.TL);
        p.addCell(7, row, Lang.set("\u7533\u8acb\u4eba"), p.TL);
        int prev_year = -1;
        int prev_month = -1;
        int prev_day = -1;
        int this_year = -1;
        int this_month = -1;
        int this_day = -1;
        int i = 0;
        while (i < vnrs.size()) {
            vnrs.setCurrentRow(i);
            this_year = TimeUtil.getYear(vnrs.getT("start_time"));
            this_month = TimeUtil.getMonth(vnrs.getT("start_time"));
            this_day = TimeUtil.getDay(vnrs.getT("start_time"));
            if (this.gGroupByMonth && (this_year != prev_year || this_month != prev_month)) {
                p.addCell(0, ++row, 8, 1, String.valueOf(this_month) + "/" + this_year, this.FORMAT_AC15);
            }
            ++row;
            if (!this.gGroupByDate || this_year != prev_year || this_month != prev_month || this_day != prev_day) {
                p.addCell(0, row, String.valueOf(TimeUtil.getStringByDate(vnrs.getT("start_time"))) + " " + TimeUtil.getWeekByDate(vnrs.getT("start_time")));
            }
            p.addCell(1, row, TimeUtil.getStringByTime12(vnrs.getT("start_time")));
            p.addCell(2, row, TimeUtil.getStringByTime12(vnrs.getT("end_time")));
            p.addCell(3, row, vnrs.getS("venue"));
            p.addCell(4, row, vnrs.getS("mg_name"));
            p.addCell(5, row, vnrs.getI("user_num"));
            p.addCell(6, row, vnrs.getS("purpose"));
            p.addCell(7, row, vnrs.getS(Member.DISPLAY_NAME));
            RecordList eqs = vnres.getGroupItems(VenueRequestEquipment.VENUE_REQUEST_SEQ, vnrs.getI(VenueRequestEquipment.VENUE_REQUEST_SEQ));
            String eq_row = "";
            int j = 0;
            while (j < eqs.size()) {
                eqs.setCurrentRow(j);
                eq_row = String.valueOf(eq_row) + (j == 0 ? Lang.set("\u4f7f\u7528\u8a2d\u5099: ") : "");
                eq_row = String.valueOf(eq_row) + eqs.getS("name") + "(" + eqs.getDStr("qty") + eqs.getS("unit") + ")";
                eq_row = String.valueOf(eq_row) + (j == eqs.size() - 1 ? "" : ", ");
                ++j;
            }
            if (!eq_row.equals("")) {
                p.addCell(2, ++row, 6, 1, eq_row, p.FORMAT_STRING);
            }
            String remark_row = "";
            if (!vnrs.getS("remark").equals("")) {
                remark_row = String.valueOf(remark_row) + (remark_row.equals("") ? "" : " ");
                remark_row = String.valueOf(remark_row) + Lang.set("\u5099\u8a3b: ") + vnrs.getS("remark");
            }
            if (!remark_row.equals("")) {
                p.addCell(2, ++row, 6, 1, remark_row, p.FORMAT_STRING);
            }
            prev_year = this_year;
            prev_month = this_month;
            prev_day = this_day;
            ++i;
        }
        p.genPrintout();
    }

    private RecordList getVenueRequests() {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"trunc(vnr.start_time,'DD')>=?", "trunc(vnr.end_time,'DD')<=?", "vnr.venue_seq=?"}, new Object[]{this.gStartDate, this.gEndDate, this.gVenueSeq});
        String sql = "select vnr.venue_request_seq,vnr.start_time,vnr.end_time,vnr.user_num,vnr.remark,vn.name as venue,mg.name as mg_name,mc.name as purpose" + Member.getSelectDisplayNameShortSQL() + " from" + " venue_request vnr" + ",venue vn" + ",member_group mg" + ",master_code mc" + ",member mb" + " where" + " vnr.venue_seq=vn.venue_seq" + " and vnr.member_group_seq=mg.member_group_seq" + " and vnr.purpose=mc.code" + " and vnr.member_seq=mb.member_seq" + " and vnr.status='" + VenueRequest.STATUS__AP + "'" + clause.getConds() + " order by vnr.start_time,vn.name";
        return DBUtil.run(sql, clause.getPrepValues());
    }

    private RecordList getVenueRequestEquipments() {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"trunc(vnr.start_time,'DD')>=?", "trunc(vnr.end_time,'DD')<=?", "vnr.venue_seq=?"}, new Object[]{this.gStartDate, this.gEndDate, this.gVenueSeq});
        String sql = "select vnre.venue_request_seq,vnre.qty,vne.name,vne.unit from venue_request vnr,venue_request_equipment vnre,venue_equipment vne where vnr.venue_request_seq=vnre.venue_request_seq and vnre.venue_equipment_seq=vne.venue_equipment_seq and vnr.status='" + VenueRequest.STATUS__AP + "'" + clause.getConds();
        return DBUtil.run(sql, clause.getPrepValues());
    }
}

