/*
 * Decompiled with CFR 0.152.
 */
package account;

import database.DBConn;
import database.DBUtil;
import java.math.BigDecimal;
import util.RecordList;
import util.RecordListSet;

public class VouTemplateItem {
    private int g_Vou_template_seq = -1;
    private RecordList g_Items = null;
    public static String VOU_TEMPLATE_ITEM_SEQ = "vou_template_item_seq";
    public static String VOU_TEMPLATE_SEQ = "vou_template_seq";
    public static String AC_SEQ = "ac_seq";
    public static String DEBIT = "debit";
    public static String CREDIT = "credit";
    public static String CHEQUE_NO = "cheque_no";
    public static String REMARK = "remark";

    public VouTemplateItem(int vou_template_seq) {
        this.g_Vou_template_seq = vou_template_seq;
        DBConn conn = new DBConn();
        this.g_Items = VouTemplateItem.load(this.g_Vou_template_seq, conn);
        conn.commit();
    }

    public RecordList getItems() {
        return this.g_Items;
    }

    private static RecordList load(int vou_template_seq, DBConn conn) {
        String sql = "select vou_template_item_seq,vou_template_seq,ac_seq,debit,credit,cheque_no,remark from vou_template_item where vou_template_seq=?";
        return DBUtil.run(sql, vou_template_seq, conn);
    }

    public static void update(int vou_template_seq, RecordList items, DBConn conn) {
        RecordList old_items = VouTemplateItem.load(vou_template_seq, conn);
        RecordListSet set = new RecordListSet(old_items, items, new String[]{VOU_TEMPLATE_ITEM_SEQ});
        RecordList r = set.getLeftOnly();
        int i = 0;
        while (i < r.size()) {
            int vou_template_item_seq = r.getI(VOU_TEMPLATE_ITEM_SEQ, i);
            VouTemplateItem.delete(vou_template_item_seq, conn);
            ++i;
        }
        r = set.getIntersectOfRight();
        i = 0;
        while (i < r.size()) {
            r.setCurrentRow(i);
            VouTemplateItem.update(r.getI(VOU_TEMPLATE_ITEM_SEQ), r.getI(AC_SEQ), r.getD(DEBIT), r.getD(CREDIT), r.getS(CHEQUE_NO), r.getS(REMARK), conn);
            ++i;
        }
        r = set.getRightOnly();
        i = 0;
        while (i < r.size()) {
            r.setCurrentRow(i);
            VouTemplateItem.insert(vou_template_seq, r.getI(AC_SEQ), r.getD(DEBIT), r.getD(CREDIT), r.getS(CHEQUE_NO), r.getS(REMARK), conn);
            ++i;
        }
    }

    private static void insert(int vou_template_seq, int ac_seq, double debit, double credit, String cheque_no, String remark, DBConn conn) {
        String sql = "insert into vou_template_item( vou_template_item_seq,vou_template_seq,ac_seq,debit,credit,cheque_no,remark)values(?,?,?,?,?,?,?)";
        int vou_template_item_seq = DBUtil.getNextValueFor(VOU_TEMPLATE_ITEM_SEQ, conn);
        DBUtil.run(sql, new Object[]{new Integer(vou_template_item_seq), new Integer(vou_template_seq), new Integer(ac_seq), new BigDecimal(debit), new BigDecimal(credit), cheque_no, remark}, conn);
    }

    private static void update(int vou_template_item_seq, int ac_seq, double debit, double credit, String cheque_no, String remark, DBConn conn) {
        String sql = "update vou_template_item set ac_seq=?,debit=?,credit=?,cheque_no=?,remark=? where vou_template_item_seq=?";
        DBUtil.run(sql, new Object[]{new Integer(ac_seq), new BigDecimal(debit), new BigDecimal(credit), cheque_no, remark, new Integer(vou_template_item_seq)}, conn);
    }

    private static void delete(int vou_template_item_seq, DBConn conn) {
        String sql = "delete from vou_template_item where vou_template_item_seq=?";
        DBUtil.run(sql, vou_template_item_seq, conn);
    }
}

