/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.ReceiptItem;
import database.DBConn;
import database.DBUtil;
import database.SQLWhereClause;
import java.sql.Timestamp;
import member.Member;
import system.Config;
import system.Lang;
import system.SystemCode;
import util.RecordList;
import util.TimeUtil;
import util.Tools;

public class Receipt {
    private int g_Receipt_seq = -1;
    private String g_Id = "";
    private Timestamp g_Date = null;
    private String g_Status = "";
    private String g_Offer_from = "";
    private String g_Payment_method = "";
    private String g_Cheque_no = "";
    private int g_Member_seq = -1;
    private String g_Remark = "";
    private String g_Require_receipt = "";
    private String g_Email_status = "";
    private Timestamp g_Email_time = null;
    public static String TYPE__OFFERING = "OF";
    public static String TYPE__CHARGE = "CH";
    public static Object[] TYPE_MAP = new Object[]{new String[]{TYPE__OFFERING, Lang.set("\u5949\u737b")}, new String[]{TYPE__CHARGE, Lang.set("\u6536\u8cbb")}};
    public static String STATUS__WA = "WA";
    public static String STATUS__CP = "CP";
    public static String STATUS__CL = "CL";
    public static Object[] STATUS_MAP = new Object[]{new String[]{STATUS__WA, Lang.set("\u5f85\u6279\u6838")}, new String[]{STATUS__CP, Lang.set("\u5df2\u78ba\u5b9a")}, new String[]{STATUS__CL, Lang.set("\u5df2\u53d6\u6d88")}};
    public static String EMAIL_STATUS__NA = "NA";
    public static String EMAIL_STATUS__TBS = "TBS";
    public static String EMAIL_STATUS__SENT = "SENT";
    public static Object[] EMAIL_STATUS_MAP = new Object[]{new String[]{EMAIL_STATUS__NA, Lang.set("\u7121")}, new String[]{EMAIL_STATUS__TBS, Lang.set("\u5f85\u767c\u9001")}, new String[]{EMAIL_STATUS__SENT, Lang.set("\u5df2\u767c\u9001")}};

    public Receipt() {
    }

    public Receipt(int receipt_seq) {
        this(receipt_seq, null);
    }

    public Receipt(int receipt_seq, DBConn conn) {
        this.g_Receipt_seq = receipt_seq;
        this.load(conn);
    }

    public int getReceipt_seq() {
        return this.g_Receipt_seq;
    }

    public String getId() {
        return this.g_Id;
    }

    public Timestamp getDate() {
        return this.g_Date;
    }

    public String getStatus() {
        return this.g_Status;
    }

    public String getOffer_from() {
        return this.g_Offer_from;
    }

    public String getPayment_method() {
        return this.g_Payment_method;
    }

    public String getCheque_no() {
        return this.g_Cheque_no;
    }

    public int getMember_seq() {
        return this.g_Member_seq;
    }

    public String getRemark() {
        return this.g_Remark;
    }

    public String getRequire_receipt() {
        return this.g_Require_receipt;
    }

    public String getEmail_status() {
        return this.g_Email_status;
    }

    public Timestamp getEmail_time() {
        return this.g_Email_time;
    }

    private void load(DBConn conn) {
        String sql = "select * from receipt where receipt_seq=?";
        RecordList r = DBUtil.run(sql, this.g_Receipt_seq, conn);
        if (!r.isEmpty()) {
            r.setCurrentRow(0);
            this.g_Id = r.getS("id");
            this.g_Date = r.getT("date");
            this.g_Status = r.getS("status");
            this.g_Offer_from = r.getS("offer_from");
            this.g_Payment_method = r.getS("payment_method");
            this.g_Cheque_no = r.getS("cheque_no");
            this.g_Member_seq = r.getI("member_seq");
            this.g_Remark = r.getS("remark");
            this.g_Require_receipt = r.getS("require_receipt");
            this.g_Email_status = r.getS("email_status");
            this.g_Email_time = r.getT("email_time");
        }
    }

    public static int insert(String id, Timestamp date, String status, String offer_from, String payment_method, String cheque_no, int member_seq, String remark, String require_receipt, RecordList items) {
        String sql = "insert into receipt( receipt_seq,id,date,status,offer_from,payment_method,cheque_no,member_seq,remark,require_receipt,email_status)values(?,?,?,?,?,?,?,?,?,?,?)";
        DBConn conn = new DBConn();
        int receipt_seq = DBUtil.getNextValueFor("receipt_seq", conn);
        Member m = new Member(member_seq, conn);
        String email_status = EMAIL_STATUS__NA;
        if (status.equals(STATUS__CP) && require_receipt.equals(SystemCode.YN__Y) && m.getReceipt_type().equals(Member.RECEIPT_TYPE__EMAIL) && Config.getS(Config.enableEmail).equals(SystemCode.YN__Y)) {
            email_status = EMAIL_STATUS__TBS;
        }
        DBUtil.run(sql, new Object[]{new Integer(receipt_seq), id, date, status, offer_from, payment_method, cheque_no, new Integer(member_seq), remark, require_receipt, email_status}, conn);
        ReceiptItem.update(receipt_seq, items, conn);
        conn.commit();
        return conn.isSuccessful() ? receipt_seq : -1;
    }

    public static int update(int receipt_seq, String id, Timestamp date, String status, String offer_from, String payment_method, String cheque_no, int member_seq, String remark, String require_receipt, RecordList items) {
        String sql = "update receipt set id=?,date=?,status=?,offer_from=?,payment_method=?,cheque_no=?,member_seq=?,remark=?,require_receipt=?,email_status=?,email_time=? where receipt_seq=?";
        DBConn conn = new DBConn();
        Member m = new Member(member_seq, conn);
        Receipt rc = new Receipt(receipt_seq, conn);
        String email_status = rc.getEmail_status();
        Timestamp email_time = rc.getEmail_time();
        if (status.equals(STATUS__CP) && require_receipt.equals(SystemCode.YN__N) || Config.getS(Config.enableEmail).equals(SystemCode.YN__N)) {
            email_status = EMAIL_STATUS__NA;
            email_time = null;
        } else if (status.equals(STATUS__CP) && require_receipt.equals(SystemCode.YN__Y) && m.getReceipt_type().equals(Member.RECEIPT_TYPE__EMAIL) && !rc.getEmail_status().equals(EMAIL_STATUS__SENT)) {
            email_status = EMAIL_STATUS__TBS;
            email_time = null;
        } else if (status.equals(STATUS__CL)) {
            email_status = EMAIL_STATUS__NA;
            email_time = null;
        }
        DBUtil.run(sql, new Object[]{id, date, status, offer_from, payment_method, cheque_no, new Integer(member_seq), remark, require_receipt, email_status, email_time, new Integer(receipt_seq)}, conn);
        ReceiptItem.update(receipt_seq, items, conn);
        conn.commit();
        return conn.isSuccessful() ? receipt_seq : -1;
    }

    public static boolean existID(String id, int receipt_seq) {
        String sql = "select 1 from receipt where id=? and receipt_seq<>?";
        RecordList r = DBUtil.run(sql, new Object[]{id, new Integer(receipt_seq)});
        return !r.isEmpty();
    }

    public static RecordList search(String offer_form, Timestamp start_date, Timestamp end_date, String status, String payment_method, String remark, boolean orderDesc) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"lower(rc.offer_from) like lower(?)", "rc.date>=?", "rc.date<?", "status=?", "payment_method=?", "lower(coalesce(rc.remark,'')||'\n'||coalesce(ri.note,'')) like lower(?)"}, new Object[]{Tools.pad(offer_form), start_date, TimeUtil.adjustDate(end_date, 1), status, payment_method, Tools.pad(remark)});
        String sql = "select rc.receipt_seq,rc.id,rc.date,rc.status,rc.offer_from,sum(ri.amount) as total,rc.email_status,'N' as selected from receipt rc,receipt_item ri where rc.receipt_seq=ri.receipt_seq" + clause.getConds() + " group by rc.receipt_seq,rc.id,rc.date,rc.status,rc.offer_from,rc.email_status,rc.email_time" + " order by rc.id " + (orderDesc ? "desc" : "") + " limit 1000";
        RecordList r = DBUtil.run(sql, clause.getPrepValues());
        int i = 0;
        while (i < r.size()) {
            r.setCurrentRow(i);
            r.setS("status", Tools.getStatusName(STATUS_MAP, r.getS("status")));
            r.setS("email_status", Tools.getStatusName(EMAIL_STATUS_MAP, r.getS("email_status")));
            ++i;
        }
        return r;
    }

    public static RecordList getMemberReceipts(int member_seq, String sub_type, Timestamp start_date, Timestamp end_date) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"rci.sub_type=?", "rc.date>=?", "rc.date<?"}, new Object[]{sub_type, start_date, TimeUtil.adjustDate(end_date, 1)});
        String sql = "select rc.id,rc.date,mc.name as sub_type,rci.type,rci.target_date,rci.note,rci.amount from receipt rc,receipt_item rci,master_code mc where rc.receipt_seq=rci.receipt_seq and rci.sub_type=mc.code and rc.member_seq=" + member_seq + " and rc.status='" + STATUS__CP + "'" + clause.getConds() + " order by rc.id desc";
        RecordList r = DBUtil.run(sql, clause.getPrepValues());
        r.replaceColValue("type", TYPE__OFFERING, Tools.getStatusName(TYPE_MAP, TYPE__OFFERING));
        r.replaceColValue("type", TYPE__CHARGE, Tools.getStatusName(TYPE_MAP, TYPE__CHARGE));
        return r;
    }
}

