package test.org.seasar.framework.container.factory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import junit.framework.TestCase;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ContainerConstants;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;

/**
 * @author higa
 *
 */
public class ComponentTagHandlerTest extends TestCase {

	private static final String PATH =
		"test/org/seasar/framework/container/factory/ComponentTagHandlerTest.xml";
	public ComponentTagHandlerTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(ComponentTagHandlerTest.class);
	}

	public void testComponent() throws Exception {
		S2Container container = S2ContainerFactory.create(PATH);
		container.init();
		assertNotNull("1", container.getComponent(List.class));
		assertNotNull("2", container.getComponent("aaa"));
		assertEquals("3", new Integer(1), container.getComponent("bbb"));
		assertEquals(
			"4",
			true,
			container.getComponent("ccc") != container.getComponent("ccc"));
		ComponentDef cd =
			container.getComponentDef("ddd");
		assertEquals(
			"5",
			ContainerConstants.AUTO_BINDING_NONE,
			cd.getAutoBindingMode());
		Map map = new HashMap();
		container.injectDependency(map, "eee");
		assertEquals("6", "111", map.get("aaa"));
		assertNotNull("7", container.getComponent("fff"));
		assertNotNull("8", container.getComponent("ggg"));
	}
}
