package org.seasar.framework.util;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.seasar.framework.exception.SQLRuntimeException;

/**
 * @author higa
 *
 */
public final class DatabaseMetaDataUtil {

	private DatabaseMetaDataUtil() {
	}

	public static String[] getPrimaryKeys(
		DatabaseMetaData dbMetaData,
		String tableName) {

		List list = getPrimaryKeyList(dbMetaData, tableName);
		return (String[]) list.toArray(new String[list.size()]);
	}

	public static List getPrimaryKeyList(
		DatabaseMetaData dbMetaData,
		String tableName) {

		List list = new ArrayList();
		try {
			ResultSet rs =
				dbMetaData.getPrimaryKeys(
					"",
					dbMetaData.getUserName(),
					tableName.toUpperCase());

			while (rs.next()) {
				list.add(rs.getString(4));
			}
			rs.close();
		} catch (SQLException ex) {
			throw new SQLRuntimeException(ex);
		}
		return list;
	}
	
	public static String[] getColumns(
		DatabaseMetaData dbMetaData,
		String tableName) {

		List list = getColumnList(dbMetaData, tableName);
		return (String[]) list.toArray(new String[list.size()]);
	}

	public static List getColumnList(
		DatabaseMetaData dbMetaData,
		String tableName) {

		List list = new ArrayList();
		try {
			ResultSet rs =
				dbMetaData.getColumns(
					"",
					dbMetaData.getUserName(),
					tableName.toUpperCase(),
					null);
			while (rs.next()) {
				list.add(rs.getString(4));
			}
			rs.close();
		} catch (SQLException ex) {
			throw new SQLRuntimeException(ex);
		}
		return list;
	}
}