package org.seasar.framework.sel.boolexps;

import org.seasar.framework.sel.BoolExpression;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

public final class IsFalseExp implements BoolExpression {

	private Expression targetExp_;

	public IsFalseExp(Expression targetExp) {
		targetExp_ = targetExp;
	}

	public boolean evaluate(SelContext context) {
		Object target = targetExp_.evaluateValue(context);
		if (target instanceof Boolean) {
			return ((Boolean) target).equals(Boolean.FALSE);
		} else {
			return false;
		}
	}
}