package org.seasar.extension.jdbc.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.seasar.extension.jdbc.PropertyType;

public class ListResultSetHandler extends AbstractResultSetHandler {

	public ListResultSetHandler() {
	}

	public Object handle(ResultSet rs, DatabaseMetaData dbMetaData)
		throws SQLException {

		ResultSetMetaData rsmd = rs.getMetaData();
		PropertyType[] propertyTypes =
			getPropertyHandler().createPropertyTypes(rsmd);
		List list = new ArrayList();
		while (rs.next()) {
			list.add(getRowHandler().createRowValue(rs, propertyTypes));
		}
		return list;
	}
}
