/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
|
|   TextureManager.h
|
+ -------------------------------------------------------------------------------------------------
|
|	eNX`ǗNX
|
+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#pragma once

struct TEXTURE_DATA{
	LPDIRECT3DTEXTURE9	pTexture;	// eNX`
	LPDIRECT3DTEXTURE9	pShadow;	// eNX`VhE
	string				name;		// O
	int					width;		// 
	int					height;		// 
	int					xPart;		// x
	int					yPart;		// y
	bool				isRev;		// ]
};
typedef vector<TEXTURE_DATA*>			vecTexture;
typedef vector<TEXTURE_DATA*>::iterator	iteTexture;

class TextureManager
{
	private:
		vecTexture	m_textureList;		// eNX`Xg

		void*		m_pCardMask;		// J[h}XNf[^
		int			m_cardSize;			// J[h摜TCY

	private:
		void release(void);			// 
		void loadCardMask(void);	// J[h}XNǂݍ

	public:
		TextureManager();
		~TextureManager();

		int loadCardTexture(char* pStr);													// J[heNX`ǂݍ
		int loadTexture(char* pStr, int xPart = -1, int yPart = -1, bool isRev = false);	// eNX`ǂݍ
		LPDIRECT3DTEXTURE9	getTexture(int num){ return(m_textureList[num]->pTexture); }
		TEXTURE_DATA*		getTexData(int num){ return(m_textureList[num]); }
};

