/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
|
|   systemManager.cpp
|
+ -------------------------------------------------------------------------------------------------
|
+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include "windowManager.h"
#include "Renderer.h"
#include "textureManager.h"
#include "Scene.h"
#include "Mouse.h"

#include "systemManager.h"

//! RXgN^
SystemManager::SystemManager()
{
}

//! fXgN^
SystemManager::~SystemManager()
{
	release();
}

//! 
void SystemManager::release(void)
{
	SAFE_DELETE(m_pTexMan);
	SAFE_DELETE(m_pCamera);
	SAFE_DELETE(m_pMouse);
}

//! 
void SystemManager::init(void)
{
	m_pWinMan = WindowManager::getInstance();
	m_pRenderer = &renderer;
	m_pTexMan = new TextureManager();
	m_pCamera = new Scene();
	m_pMouse = new Mouse();

	m_pCamera->create();
	m_pRenderer->init();
	m_pMouse->init();
}

//! XV
void SystemManager::update(void)
{
	m_pCamera->update();
	m_pMouse->update();
}

//! CX^X擾
SystemManager* SystemManager::getInstance(void)
{
	static SystemManager sysMan;
	return(&sysMan);
}

