
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: Renderer.cpp

+ ------ Explanation of file --------------------------------------------------------------------------

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include "windowManager.h"
#include "systemManager.h"

#include "Scene.h"

#include "Renderer.h"

// ftHgRXgN^
Renderer::Renderer()
{
    m_pD3D = NULL; 
}

// fXgN^
Renderer::~Renderer()
{
	release();
}

//! 
void Renderer::init(bool isFullScr)
{
	m_pWinMan = WindowManager::getInstance();
	m_pCamera = SystemManager::getInstance()->getCamera();

    D3DDISPLAYMODE d3ddm;
    
	// Direct3D9IuWFNg̍쐬
	if((m_pD3D = ::Direct3DCreate9(D3D_SDK_VERSION)) == 0) { return; }	// 擾s

	// ݂̃fBXvC[h擾
    if(FAILED(m_pD3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT, &d3ddm))) { return; }
	m_dispHeight = d3ddm.Height;

	// foCX̃v[e[Vp[^
	ZeroMemory(&m_D3DPP, sizeof(D3DPRESENT_PARAMETERS));
	m_D3DPP.BackBufferCount	= 1;

	if(isFullScr){ 
		m_D3DPP.Windowed			= FALSE;		// tXN[\̎w
		m_D3DPP.BackBufferWidth		= WINDOW_W;		// tXN[̉
		m_D3DPP.BackBufferHeight	= WINDOW_H;		// tXN[̏c
	}else{
		m_D3DPP.Windowed			= TRUE;				// EChE\̎w
	}

	m_D3DPP.BackBufferFormat		= d3ddm.Format;			    // J[[h̎w
	m_D3DPP.SwapEffect				= D3DSWAPEFFECT_DISCARD;	// 
	m_D3DPP.EnableAutoDepthStencil	= TRUE;						// G[΍
//	m_D3DPP.AutoDepthStencilFormat	= D3DFMT_D16;
	m_D3DPP.AutoDepthStencilFormat	= D3DFMT_D24S8;				// 摜tH[}bgAXeVobt@Ή
//	m_D3DPP.PresentationInterval	= D3DPRESENT_INTERVAL_IMMEDIATE;
	
	// fBXvCA_v^\߂̃foCX쐬
	// `ƒ_n[hEFAōsȂ
	if(FAILED(m_pD3D->CreateDevice(D3DADAPTER_DEFAULT, 
									  D3DDEVTYPE_HAL, 
									  getWinMan()->getHWnd(), 
									  D3DCREATE_HARDWARE_VERTEXPROCESSING, 
									  &m_D3DPP, &m_pD3DDevice))) 
    {
		// L̐ݒ肪s
		// `n[hEFAōsA_CPUōsȂ
		if(FAILED(m_pD3D->CreateDevice(D3DADAPTER_DEFAULT, 
										  D3DDEVTYPE_HAL, 
										  getWinMan()->getHWnd(), 
										  D3DCREATE_SOFTWARE_VERTEXPROCESSING, 
										  &m_D3DPP, &m_pD3DDevice))) 
        {
			// L̐ݒ肪s
			// `ƒ_CPUōsȂ
			if(FAILED(m_pD3D->CreateDevice(D3DADAPTER_DEFAULT, 
											  D3DDEVTYPE_REF, getWinMan()->getHWnd(), 
											  D3DCREATE_SOFTWARE_VERTEXPROCESSING, 
											  &m_D3DPP, &m_pD3DDevice))) 
            {
				// s
				return;
			}
		}
	}

	// _OXe[gp[^̐ݒ
	// ʕ`惂[h̎w
    m_pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);
	// yrsȂ
    m_pD3DDevice->SetRenderState(D3DRS_ZENABLE, TRUE);
	// fBUOsȂii`j
	m_pD3DDevice->SetRenderState(D3DRS_DITHERENABLE, TRUE);
	// m[CeBO[h 	
    m_pD3DDevice->SetRenderState(D3DRS_LIGHTING, FALSE);
	// eNX`Xe[W̐ݒ
	m_pD3DDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_SELECTARG1);
	m_pD3DDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
	m_pD3DDevice->SetTextureStageState(1, D3DTSS_COLOROP, D3DTOP_BLENDTEXTUREALPHA);
	m_pD3DDevice->SetTextureStageState(1, D3DTSS_COLORARG1, D3DTA_TEXTURE);
	m_pD3DDevice->SetTextureStageState(1, D3DTSS_COLORARG2, D3DTA_CURRENT);
	m_pD3DDevice->SetTextureStageState(1, D3DTSS_ALPHAOP, D3DTOP_SELECTARG2);
	m_pD3DDevice->SetTextureStageState(1, D3DTSS_ALPHAARG2, D3DTA_CURRENT);
	m_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);
	m_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);
	// At@l̐ݒ
	m_pD3DDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);
    m_pD3DDevice->SetRenderState(D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA);
    m_pD3DDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
	// eNX`[⊮ݒ
	m_pD3DDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_ANISOTROPIC);
	m_pD3DDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_ANISOTROPIC);
	m_pD3DDevice->SetSamplerState(0, D3DSAMP_MIPFILTER, D3DTEXF_ANISOTROPIC);
	m_pD3DDevice->SetSamplerState(0, D3DSAMP_MAXANISOTROPY, 4);

	// r[COs̏
	D3DXMatrixIdentity(&m_view);
	D3DXMatrixLookAtLH(&m_view, &VEC3(0.0f, 10.0f, 0.0f), 
								 &VEC3(0.0f, 0.0f, 0.0f), 
								 &VEC3(0.0f, 1.0f, 0.0f));

	set3D();
}


/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
|
|   Finalize
|       I
+ -------------------------------------------------------------------------------------------------
|	IN --->	NON
|   OUT --> NON
+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */
void Renderer::release(void)
{
	// foCXIuWFNg̉
	SAFE_RELEASE(m_pD3DDevice);

	// DirectXGraphics̉
	SAFE_RELEASE(m_pD3D);
}

//! `Jn
void Renderer::drawStart(void)
{
	// `Jn錾
	if(SUCCEEDED(m_pD3DDevice->BeginScene())){
		// ʃNA
		if(FAILED(m_pD3DDevice->Clear(0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,
										D3DCOLOR_XRGB(64,64,64), 1.0f, 0)))
		{
			return;
		}
	}
}

//! `I
void Renderer::drawEnd(void)
{
	// `I錾
	m_pD3DDevice->EndScene();

	// `挋ʂ̓]
	if(FAILED(m_pD3DDevice->Present(0, 0, 0, 0))){
		// foCX畜A
		m_pD3DDevice->Reset(&m_D3DPP);
	}
}


// 3D`ݒ
void Renderer::set3D(void)
{
	if(!m_pD3DDevice) { return; }

	// r[|[gQ[ʂɕύX
	D3DVIEWPORT9 vp={MENU_W,0,WINDOW_W-MENU_W,WINDOW_H,0.0f,1.0f};
	m_pD3DDevice->SetViewport(&vp);
//	if(FAILED(m_pD3DDevice->GetViewport(&vp))) { return; }

	// AXyNǧvZ
	float aspect;
	aspect = (float)vp.Width / (float)vp.Height;

	// @ˉe
	D3DXMatrixIdentity(&m_proj);
	D3DXMatrixPerspectiveFovLH(&m_proj, D3DXToRadian(45.0f), aspect, NEAR_CLIP, FAR_CLIP);
	m_pD3DDevice->SetTransform(D3DTS_PROJECTION, &m_proj);

	// r[
	D3DXMatrixIdentity(&m_view);
	D3DXMatrixLookAtLH(&m_view, &getCamera()->m_eye, &getCamera()->m_look, &getCamera()->m_up);
	m_pD3DDevice->SetTransform(D3DTS_VIEW, &m_view);
}
// 2D`ݒ
void Renderer::set2D(void)
{
	if(!m_pD3DDevice) { return; }

	// r[|[gʑŜɕύX
	D3DVIEWPORT9 vp={0,0,WINDOW_W,WINDOW_H,0.0f,1.0f};
	m_pD3DDevice->SetViewport(&vp);

	// ˉe
	D3DXMatrixIdentity(&m_proj);
	D3DXMatrixOrthoLH(&m_proj, WINDOW_W, WINDOW_H, 1.0f, 1.0f);
	m_pD3DDevice->SetTransform(D3DTS_PROJECTION, &m_proj);

	// r[
	D3DXMatrixIdentity(&m_view);
	m_pD3DDevice->SetTransform(D3DTS_VIEW, &m_view);
}

// [hWtoXN[W
VEC3 Renderer::conv3Dto2D(VEC3 pos)
{
	VEC3 ret;
	D3DVIEWPORT9 vp;
	D3DXMATRIX mat;
	D3DXMatrixIdentity(&mat);
	GetDevice()->GetViewport(&vp);
	D3DXVec3Project(&ret, &pos, &vp, &m_proj, &m_view, &mat);

	return(ret);
}
