
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: Mouse.h

+ ------ Explanation of file --------------------------------------------------------------------------

	͏AtH[JX

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#pragma once

class Card;
class WindowManager;
class RayTrace;

// ͏
enum{
	MOUSE_PULL,
	MOUSE_PUSH,
	MOUSE_HOLD,
};

// qbg`FbN
enum{
	MOUSE_HIT_NON,
	MOUSE_HIT_FOCUS,
	MOUSE_HIT_CLICK,
};

typedef struct{
	Card*	card;	// J[hւ̃|C^
//	int		zone;	// ][
//	int		num;	// zvf
//	int		ply;	// vC[
	int		serNo;	// ĨJ[h
}FOCUS_ST;

class Mouse
{
	private:
		WindowManager*	m_pWinMan;		// EBhEǗ
		RayTrace*		m_pRayTrace;	// Cg[X

	private:
		void	release(void);			// 

	public:
		void	init(void);				// 

		void	update	(void);			// XV

		POINT	getPos		(void){ POINT pos = {(int)m_pos.x, (int)m_pos.y}; return(pos); };		// }EXW擾
		int		getInputL	(void){ return(m_inputL); };	// LNbNԎ擾
		int		getInputR	(void){ return(m_inputR); };	// RNbNԎ擾
		int		getWheel	(void){ return(m_wheel); }		// zC[擾

		void	setWheel	(int w){ m_updateWheel = w; }

		bool	isHitPlane(VEC3* pPos, D3DXMATRIX* pWorld, VEC3* pHit = NULL);	// 3DʂƂ̃qbg`FbN

	private:
		WindowManager*	getWinMan(void){ return(m_pWinMan); }
		RayTrace*	getRayTrace(void){ return(m_pRayTrace); }

	private:
		VEC2	m_pos;					// W
		int			m_inputL;				// L͏
		int			m_inputR;				// R͏
		int			m_wheel;				// zC[
		int			m_updateWheel;			// bZ[W̃zC[i[
};

