
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: Image2D.h

+ ------ Explanation of file --------------------------------------------------------------------------

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include "systemManager.h"
#include "textureManager.h"
#include "Renderer.h"

#include "Image2D.h"

//! RXgN^
Image2D::Image2D()
{
	m_pTexMan = NULL;
	m_pVB = NULL;
	m_isCreate = false;
}

//! fXgN^
Image2D::~Image2D()
{
	close();
}

void Image2D::init(void)
{
	m_pTexMan = SystemManager::getInstance()->getTexMan();
}

//! (eNX`)
//! 
int Image2D::create(int set_x, int set_y, int set_w, int set_h, D3DXCOLOR color, float set_xc, float set_yc)
{
	IMAGE2D_VERTEX	*v;

	close();

	// _obt@
	GetDevice()->CreateVertexBuffer(
		4 * sizeof(IMAGE2D_VERTEX),	// _obt@TCY
		D3DUSAGE_WRITEONLY,
		IMAGE2D_VERTEX_FVF,
		D3DPOOL_MANAGED,
		&m_pVB,
		NULL);

	// _̐ݒ
	// bN
	m_pVB->Lock(0, 0, (void**)&v, 0);

	// 䗦
	float xcl = 0.0f + set_xc;
	float xcr = 1.0f - set_xc;
	float ycu = 0.0f + set_yc;
	float ycd = 1.0f - set_yc;
	// _W
	float l = -((float)set_w * xcl);
	float r =   (float)set_w * xcr;
	float u = -((float)set_h * ycu);
	float d =   (float)set_h * ycd;

	// _Ww
	v[0].p = VEC3(l, u, 0.0f);
	v[1].p = VEC3(r, u, 0.0f);
	v[2].p = VEC3(l, d, 0.0f);
	v[3].p = VEC3(r, d, 0.0f);

	// Fw
	v[0].color = color;
	v[1].color = color;
	v[2].color = color;
	v[3].color = color;

	// eNX`Wݒ(x])
	v[0].t1 = VEC2(1.0f, 0.0f);
	v[1].t1 = VEC2(0.0f, 0.0f);
	v[2].t1 = VEC2(1.0f, 1.0f);
	v[3].t1 = VEC2(0.0f, 1.0f);
	v[0].t2 = VEC2(1.0f, 0.0f);
	v[1].t2 = VEC2(0.0f, 0.0f);
	v[2].t2 = VEC2(1.0f, 0.0f);
	v[3].t2 = VEC2(0.0f, 0.0f);

	// AbN
	m_pVB->Unlock();

	m_pos = VEC3((float)set_x, (float)set_y, 0.0f);
	m_degree = VEC3(0.0f, 0.0f, 0.0f);
	m_scale = 1.0f;
	m_size.x = (float)set_w;
	m_size.y = (float)set_h;
	m_center = VEC2(set_xc, set_yc);
	m_texID[0] = -1;
	m_texID[1] = -1;
	m_texPart = -1;
	m_isCreate = true;

	return(TRUE);
}

//! XV
void Image2D::update(void)
{
}

//! `
void Image2D::draw(void)
{
	if(!m_isCreate) { return; }

	for(int i = 0; i < 2; i++){
		if(m_texID[i] != -1){
			GetDevice()->SetTexture(i, m_pTexMan->getTexture(m_texID[i]));
		}
	}

	// 2Dϊ
	// r[|[g̒S_ʒɂ邽ߍɈړ
	// ]Sɒ_łĂ̂ōɈړ
	// 2D3Dły㉺tȂ̂Ŕ]
	VEC3 vPos;
	vPos.x =   m_pos.x - (WINDOW_W / 2.0f) + (m_size.x * m_center.x);
	vPos.y = -(m_pos.y - (WINDOW_H / 2.0f) + (m_size.y * m_center.y));
	vPos.z = 0.0f;
	// 0xɂȂĂ̂Ŕ]
	VEC3 vDeg = VEC3(m_degree.x, m_degree.y, m_degree.z + 180.0f);

	GetWorldMatrix(&m_world, &vPos, &vDeg, m_scale);
	GetDevice()->SetTransform(D3DTS_WORLD, &m_world);

	GetDevice()->SetStreamSource(0, m_pVB, 0, sizeof(IMAGE2D_VERTEX));
	GetDevice()->SetFVF(IMAGE2D_VERTEX_FVF);
	GetDevice()->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, 2);

	for(int i = 0; i < 2; i++){
		GetDevice()->SetTexture(i, NULL);
	}
}

//! I
void Image2D::close(void)
{
	SAFE_RELEASE(m_pVB);
}

void Image2D::setTexture(int stage, char* name, int xPart, int yPart, bool isRev)
{
	m_texID[stage] = m_pTexMan->loadTexture(name, xPart, yPart, isRev);
}

//! eNX`؂ւ
void Image2D::setTexPart(int part)
{
	if(m_texID[0] != -1 && m_texPart != part){
		TEXTURE_DATA*	pTex = m_pTexMan->getTexData(m_texID[0]);
		float x = (float)(part % pTex->xPart);
		float y = (float)(part / pTex->xPart);
		float l = x				/ (float)pTex->xPart;
		float r = (x + 1.0f)	/ (float)pTex->xPart;
		float u = y				/ (float)pTex->yPart;
		float d = (y + 1.0f)	/ (float)pTex->yPart;

		IMAGE2D_VERTEX*	v;
		m_pVB->Lock(0, 0, (void**)&v, 0);
		// E]
		v[0].t1 = VEC2(r, u);
		v[1].t1 = VEC2(l, u);
		v[2].t1 = VEC2(r, d);
		v[3].t1 = VEC2(l, d);
		m_pVB->Unlock();

		m_texPart = part;
	}
}


