
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: IME.h

+ ------ Explanation of file --------------------------------------------------------------------------

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include "windowManager.h"

#include "IME.h"

// RXgN^
IME::IME()
{
	m_hWndImc = NULL;
	m_hImc = NULL;
}

// fXgN^
IME::~IME()
{
	close();
}

// 
void IME::init(WindowManager* pWinMan)
{
	m_pWinMan = pWinMan;
	m_hWndImc = ImmGetDefaultIMEWnd(getWinMan()->getHWnd());
	m_hImc = ImmGetContext(m_hWndImc);
}

// I
void IME::close() 
{
	ImmReleaseContext(getWinMan()->getHWnd(), m_hImc);
}

// XV
void IME::update(void)
{
}

// WZbg
void IME::setPos(int x, int y)
{
	// IMEɃZbg
	COMPOSITIONFORM cpf;
	cpf.dwStyle = CFS_POINT;
	cpf.ptCurrentPos.x = x;
	cpf.ptCurrentPos.y = y;
	ImmSetCompositionWindow(m_hImc, &cpf);

	m_pos.x = x;
	m_pos.y = y;
}

// LZbg
void IME::setEnable(bool isEnable)
{
	ImmSetOpenStatus(m_hImc, (int)isEnable);
}

// L擾
bool IME::getEnable(bool isEnable)
{
	return(ImmGetOpenStatus(m_hImc) ? true : false);
}





