/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
|
|   Ground.cpp
|       
+ -------------------------------------------------------------------------------------------------
|
+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include "Renderer.h"

#include "Ground.h"

/* ----------------------------------------------------- */
// RXgN^
Ground::Ground()
{
	m_pVB = NULL;
}

/* ----------------------------------------------------- */
// fXgN^
Ground::~Ground()
{
	close();
}

/* ----------------------------------------------------- */
// 
int Ground::create (void)
{
	GROUND_VERTEX	*v;

	close();

	// _obt@
	GetDevice()->CreateVertexBuffer(
		4 * sizeof(GROUND_VERTEX),	// _obt@TCY
		D3DUSAGE_WRITEONLY,
		GROUND_VERTEX_FVF,
		D3DPOOL_MANAGED,
		&m_pVB,
		NULL);

	// _̐ݒ
	// bN
	m_pVB->Lock(0, 0, (void**)&v, 0);

	float size = 5.22f;
	float tex = 1.0f;
	// Wݒ
	v[0].p = VEC3(-size, -0.12f, -size);
	v[1].p = VEC3( size, -0.12f, -size);
	v[2].p = VEC3(-size, -0.12f,  size);
	v[3].p = VEC3( size, -0.12f,  size);

	// Fݒ
	v[0].color = D3DXCOLOR(0.0f, 0.0f, 0.0f, 0.0f);
	v[1].color = D3DXCOLOR(0.0f, 0.0f, 0.0f, 0.0f);
	v[2].color = D3DXCOLOR(0.0f, 0.0f, 0.0f, 0.0f);
	v[3].color = D3DXCOLOR(0.0f, 0.0f, 0.0f, 0.0f);

	// eNX`Wݒ(pƈႤ)
//	v[0].t = VEC2(-tex,  tex);
//	v[1].t = VEC2( tex,  tex);
//	v[2].t = VEC2(-tex, -tex);
//	v[3].t = VEC2( tex, -tex);
	v[0].t = VEC2(0,  tex);
	v[1].t = VEC2( tex,  tex);
	v[2].t = VEC2(0, 0);
	v[3].t = VEC2( tex, 0);

	// AbN
	m_pVB->Unlock();

	return(TRUE);
}

/* ----------------------------------------------------- */
// `
void Ground::draw(void)
{
	D3DXMatrixIdentity(&m_world);
	GetDevice()->SetTransform(D3DTS_WORLD, &m_world);

	GetDevice()->SetStreamSource(0, m_pVB, 0, sizeof(GROUND_VERTEX));
	GetDevice()->SetFVF(GROUND_VERTEX_FVF);
	GetDevice()->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, 2);

	GetDevice()->SetTexture(0, NULL);
}

/* ----------------------------------------------------- */
// I
void Ground::close(void)
{
	SAFE_RELEASE(m_pVB);
}




