/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
|
|   GridLine_Block.cpp
|       
+ -------------------------------------------------------------------------------------------------
|
+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include "GridLine.h"

/* --------------------------------------------------- */
// RXgN^
GridLine::GridLine()
{
	for(int i = 0; i < GRID_LINE_MAX; i++)
	{
		m_pVB[i] = NULL;
	}
}

/* ----------------------------------------------------- */
// fXgN^
GridLine::~GridLine()
{
	close();
}

/* ----------------------------------------------------- */
// 
int GridLine::create(void)
{
	int					i;
	float				g2, g4;
	GRID_LINE_VERTEX	*v;

	g2 = GRID_LINE_MAX / 2;
	g4 = GRID_LINE_MAX / 4;

	close();

	// _obt@
	for(i = 0; i < GRID_LINE_MAX; i++)
	{
		GetDevice()->CreateVertexBuffer(
			2 * sizeof(GRID_LINE_VERTEX),	// _obt@TCY
			D3DUSAGE_WRITEONLY,
			GRID_LINE_VERTEX_FVF,
			D3DPOOL_MANAGED,
			&m_pVB[i],
			NULL);
	}

	// _̐ݒ
	for(i = 0; i < GRID_LINE_MAX; i++)
	{
		// bN
		m_pVB[i]->Lock(0, 0, (void**)&v, 0);

		// 
		if(i < (GRID_LINE_MAX / 2))
		{
			v[0].p = VEC3(			 -0.1f, 0.0f, (float)i);
			v[1].p = VEC3((g2 - 1.0f), -0.1f, (float)i);
		}
		// c
		else
		{
			v[0].p = VEC3((float)(i - g2), -0.1f, 0.0f);
			v[1].p = VEC3((float)(i - g2), -0.1f, (g2 - 1.0f));
		}
		v[0].p.x += GRID_LINE_PLACE;
		v[0].p.z += GRID_LINE_PLACE;
		v[1].p.x += GRID_LINE_PLACE;
		v[1].p.z += GRID_LINE_PLACE;

		v[0].color = D3DXCOLOR(0.0f, 0.8f, 0.0f, 1.0f);
		v[1].color = D3DXCOLOR(0.0f, 0.8f, 0.0f, 1.0f);

		// AbN
		m_pVB[i]->Unlock();
	}

	return(TRUE);
}

/* ----------------------------------------------------- */
// `
void GridLine::draw(void)
{
	int i;

	D3DXMatrixIdentity(&m_world);
	GetDevice()->SetTransform(D3DTS_WORLD, &m_world);

	for(i = 0; i < GRID_LINE_MAX; i++)
	{
		GetDevice()->SetStreamSource(0, m_pVB[i], 0, sizeof(GRID_LINE_VERTEX));
		GetDevice()->SetFVF(GRID_LINE_VERTEX_FVF);
		GetDevice()->DrawPrimitive(D3DPT_LINELIST, 0, 1);
	}
}

/* ----------------------------------------------------- */
// I
void GridLine::close()
{
	for(int i = 0; i < GRID_LINE_MAX; i++)
	{
		SAFE_RELEASE(m_pVB[i]);
	}
}




