
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: Dialog.cpp

+ ------ Explanation of file --------------------------------------------------------------------------

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include "systemManager.h"
#include "Renderer.h"
#include "Mouse.h"
#include "Phase.h"
#include "Field.h"
#include "Skill.h"

#include "Dialog.h"

//! RXgN^
Dialog::Dialog()
{
	m_isCreate = false;
	m_isOverWrite = true;
}

//! fXgN^
Dialog::~Dialog()
{
}

//! 
void Dialog::init(Skill* pSkill)
{
	m_pMouse = SystemManager::getInstance()->getMouse();
	m_pSkill = pSkill;

	m_base.init();
	m_cardList.init(m_pMouse);
}

//! 
int Dialog::create(int set_x, int set_y, int set_w, int set_h, int id, Card* pCard, int tex)
{
	m_base.create(set_x, set_y, set_w, set_h);

	switch(tex){
		case TEX_DLG_NORMAL:
			m_base.setTexture(0, TEXLOAD_DLGNORMAL);
			break;
		case TEX_DLG_LIST:
			m_base.setTexture(0, TEXLOAD_DLGLIST);
			break;
		case TEX_DLG_BTN1:
			m_base.setTexture(0, TEXLOAD_DLGBTN1);
			break;
		case TEX_DLG_BTN2:
			m_base.setTexture(0, TEXLOAD_DLGBTN2);
			break;
	}

	m_pos.x = (float)set_x;
	m_pos.y = (float)set_y;
	m_w = set_w;
	m_h = set_h;
	m_id = id;
	m_card = pCard;

	m_isCreate = true;

	return(TRUE);
}

//! `
void Dialog::draw(void)
{
	if(!m_isCreate) { return; }

	m_base.draw();
	m_cardList.draw();
	m_text.draw();

	for(ItepBtn ite = m_btnList.begin(); ite != m_btnList.end(); ite++){
		(*ite)->draw();
	}
}

//! I
void Dialog::close(void)
{
	m_isCreate = false;
	m_isOverWrite = true;
	m_id = -1;
	m_base.close();
	m_cardList.close();
	m_text.Release();
	while(!m_btnList.empty()){
		SAFE_DELETE(m_btnList.back());
		m_btnList.pop_back();
	}
}

//! XV
void Dialog::update(void)
{
	if(!m_isCreate) { return; }

	m_base.update();
	if(m_cardList.m_isCreate){
		m_cardList.update();
	}
	for(ItepBtn ite = m_btnList.begin(); ite != m_btnList.end(); ite++){
		(*ite)->update();
	}
}

//! ̎ޔ
void Dialog::openDlg(Card* card)
{
	// _CAO
	if(phase.m_canOpenDlg){
		// _CAO̎
		int type = -1;
		switch(card->m_zone){
			//D
			case ZONE_HAND:
				if(phase.m_phase == PHASE_MAIN){
					if(card->m_ply == PLY_MY){
						if(card->m_ci.type == TYPE_PG){
							type = DLG_HAND_PROGRESS;
						}else if(card->m_ci.type == TYPE_AC){
							type = DLG_HAND_ACTION;
						}
					}
				}
				break;
			//vOX
			case ZONE_PROGRESS:
				if(card->m_ply == PLY_MY){
					if(phase.m_phase == PHASE_MAIN){
						type = DLG_PROGRESS;
					}else if(phase.m_phase == PHASE_ATTACK && phase.m_state == PHASE_ATTACK_SELECT){
						if(card->m_ply == PLY_MY){
							type = DLG_ATTACK;
						}
					}
				}
				break;
			//ANV
			case ZONE_ACTION:
				if(card->m_ply == PLY_MY){
					if(phase.m_phase == PHASE_MAIN){
						type = DLG_ACTION;
					}
				}
				break;
			//̎D
			//O
			case ZONE_DISCARD:
			case ZONE_EXCUDE:
				type = DLG_LIST;
				break;
		}
		if(type != -1){
			open(type, DLG_PLACE_CARD, card);
		}
	}
}

//1 I[v
void Dialog::open(int type, int place, Card* pCard, char* pText)
{
#define PLACE(p)		(p == DLG_PLACE_SEEMY ? -120 : p == DLG_PLACE_TOP ? -230 : 0)
#define CENX(x, w)		((x) != -1 ? (x) - (int)(w*0.2f) : MENU_W + ((WINDOW_W - MENU_W - (w)) / 2))
#define CENY(y, h)		((y) != -1 ? (y) : (WINDOW_H - (h)) / 2 + PLACE(place))
#define SET(sw, sh)		{w = (sw); h = (sh); x = CENX(x, w); y = CENY(y, h);}

	// ㏑֎~̏ꍇIcloseĂ΂ȂƕȂ
	if(!phase.m_canOpenDlg || !m_isOverWrite){
		return;
	}

	close();
	int		x = -1;
	int		y = -1;
	int		w = -1;
	int		h = -1;
	int		col = 0x00222222;
	int		tex;
	Button*	pBtn;

	// J[hWXN[Wɕϊ
	if(pCard && place == DLG_PLACE_CARD){
		VEC3 v = pCard->getDispPos();
		x = (int)v.x;
		y = (int)v.y;
	}

	switch(type){
		// DvOX
		case DLG_HAND_PROGRESS:{
			SET(DLG_BTN1_W, DLG_BTN1_H);
			m_btnList.push_back(new Button());
			pBtn = m_btnList.back();
			pBtn->init();
			pBtn->create(x+5, y+5, BTN_NORMAL_W, BTN_NORMAL_H);
			pBtn->setID(BTN_ID_SHIFT);
			pBtn->setTexType(BUTTONPART(BTNPART_SHIFT));
			m_isOverWrite = true;
			tex = TEX_DLG_BTN1;

			int cost;
			pBtn->setEnable(false);
			// RXg邩
			if(pCard->m_ply == PLY_MY){
				for(int i = 0; i < PROGRESS_MAX; i++){
					cost = field.getAwakeEnergyNum(PLY_MY) - field.getShiftCost(field.getProgress(PLY_MY, i), pCard);
					if(!field.m_shiftPRG[PLY_MY][i] && (cost >= 0)){
						pBtn->setEnable(true);
						break;
					}
				}
			}
			break;
		}
		// DANV
		case DLG_HAND_ACTION:
			SET(DLG_BTN1_W, DLG_BTN1_H);
			m_btnList.push_back(new Button());
			pBtn = m_btnList.back();
			pBtn->init();
			pBtn->create(x+5, y+5, BTN_NORMAL_W, BTN_NORMAL_H);
			pBtn->setID(BTN_ID_SHIFT);
			pBtn->setTexType(BUTTONPART(BTNPART_SHIFT));
			m_isOverWrite = true;
			tex = TEX_DLG_BTN1;



			pBtn->setEnable(false);
			// GiW[邩
			if(pCard->m_ply == PLY_MY){
				if(field.getAwakeEnergyNum(PLY_MY) >= pCard->getSumLevel() && !field.m_shiftAC[pCard->m_ply]){
					pBtn->setEnable(true);
				}
			}
			break;
		// vOX
		case DLG_PROGRESS:{
			bool isOpen = false;
			bool isSkill = false;
			if(pCard->m_ply == PLY_MY && pCard->m_awake == CARD_AWAKE){
				// N
				int snum = m_pSkill->searchTinimg(pCard, SKILL_TIMING_STARTUP);
				if(snum != -1){
					isSkill = true;
					// RXgx\
					if(m_pSkill->invoke(pCard, snum, SKILL_CODE_CHECK_COST)){
						isOpen = true;
					}
				}
			}
			if(!isSkill){
				return;
			}

			SET(DLG_BTN1_W, DLG_BTN1_H);
			m_btnList.push_back(new Button());
			pBtn = m_btnList.back();
			pBtn->init();
			pBtn->create(x+5, y+5, BTN_NORMAL_W, BTN_NORMAL_H);
			pBtn->setID(BTN_ID_INVOKE);
			pBtn->setTexType(BUTTONPART(BTNPART_INVOKE));
			pBtn->setEnable(isOpen);
			m_isOverWrite = true;
			tex = TEX_DLG_BTN1;
			break;
		}
		// ANV
		case DLG_ACTION:
			SET(DLG_BTN1_W, DLG_BTN1_H);
			m_btnList.push_back(new Button());
			pBtn = m_btnList.back();
			pBtn->init();
			pBtn->create(x+5, y+5, BTN_NORMAL_W, BTN_NORMAL_H);
			pBtn->setID(BTN_ID_INVOKE);
			pBtn->setTexType(BUTTONPART(BTNPART_INVOKE));
			m_isOverWrite = true;
			tex = TEX_DLG_BTN1;



			pBtn->setEnable(false);
			if(pCard->m_ply == PLY_MY){
				// N
				int snum = m_pSkill->searchTinimg(pCard, SKILL_TIMING_MAIN);
				if(snum != -1){
					// RXgx\
					if(m_pSkill->invoke(pCard, snum, SKILL_CODE_CHECK_COST)){
						pBtn->setEnable(true);
					}
				}
			}
			break;
		// U
		case DLG_ATTACK:
			SET(DLG_BTN1_W, DLG_BTN1_H);
			m_btnList.push_back(new Button());
			pBtn = m_btnList.back();
			pBtn->init();
			pBtn->create(x+5, y+5, BTN_NORMAL_W, BTN_NORMAL_H);
			pBtn->setID(BTN_ID_ATTACK);
			pBtn->setTexType(BUTTONPART(BTNPART_ATTACK));
			pBtn->setEnable(pCard->m_awake == CARD_AWAKE);
			m_isOverWrite = true;
			tex = TEX_DLG_BTN1;
			break;
		// J[hXg({^)
		case DLG_LIST:
			SET(DLG_BTN1_W, DLG_BTN1_H);
			m_btnList.push_back(new Button());
			pBtn = m_btnList.back();
			pBtn->init();
			pBtn->create(x+5, y+5, BTN_NORMAL_W, BTN_NORMAL_H);
			pBtn->setID(BTN_ID_LIST);
			pBtn->setTexType(BUTTONPART(BTNPART_LIST));
			m_isOverWrite = true;
			tex = TEX_DLG_BTN1;
			break;
		// J[hXg({)
		case DLG_CARDLIST:
			SET(DLG_LIST_W, DLG_LIST_H);
			m_cardList.create(x+5, y+5, DLG_LIST_W-10, DLG_LIST_H-BTN_NORMAL_H-20, (int)(IMG_CARD_W*0.5f), (int)(IMG_CARD_H*0.5f), 5);
			m_btnList.push_back(new Button());
			pBtn = m_btnList.back();
			pBtn->init();
			pBtn->create(x+DLG_LIST_W/2-BTN_NORMAL_W/2, y+DLG_LIST_H-BTN_NORMAL_H-10, BTN_NORMAL_W, BTN_NORMAL_H);
			pBtn->setID(BTN_ID_CLOSE);
			pBtn->setTexType(BUTTONPART(BTNPART_CLOSE));
			m_isOverWrite = false;
			tex = TEX_DLG_LIST;
			break;
		// KCheLXg
		case DLG_TEXT:
			SET(DLG_TEXT_W, DLG_TEXT_H);
			m_text.create(pText, x+10, y+10, x+w-10, y+h-10, 18, col);
			m_text.SetTextAlign(AlignCenter);
			m_isOverWrite = false;
			tex = TEX_DLG_NORMAL;
			break;
		case DLG_T_YESNO:		// ͂/
		case DLG_T_UPDOWN:		// /
		case DLG_T_UPDUMP:{		// /̎D
			int id1, id2;
			int part1, part2;
			if(type == DLG_T_YESNO){
				id1 = BTN_ID_YES;
				id2 = BTN_ID_NO;
				part1 = BTNPART_YES;
				part2 = BTNPART_NO;
			}else if(type == DLG_T_UPDOWN){
				id1 = BTN_ID_UP;
				id2 = BTN_ID_DOWN;
				part1 = BTNPART_UP;
				part2 = BTNPART_DOWN;
			}else if(type == DLG_T_UPDUMP){
				id1 = BTN_ID_UP;
				id2 = BTN_ID_DISCARD;
				part1 = BTNPART_UP;
				part2 = BTNPART_DISCARD;
			}
			SET(DLG_TEXT_W, DLG_TEXT_H);
			int bx = x + w / 2 - BTN_NORMAL_W - 5;
			int by = y + h - BTN_NORMAL_H - 10;
			m_btnList.push_back(new Button());
			pBtn = m_btnList.back();
			pBtn->init();
			pBtn->create(bx, by, BTN_NORMAL_W, BTN_NORMAL_H);
			pBtn->setID(id1);
			pBtn->setTexType(BUTTONPART(part1));
			bx += BTN_NORMAL_W + 10;
			m_btnList.push_back(new Button());
			pBtn = m_btnList.back();
			pBtn->init();
			pBtn->create(bx, by, BTN_NORMAL_W, BTN_NORMAL_H);
			pBtn->setID(id2);
			pBtn->setTexType(BUTTONPART(part2));
			m_text.create(pText, x+10, y+10, x+w-10, y+h-10, 18, col);
			m_text.SetTextAlign(AlignCenter);
			m_isOverWrite = false;
			tex = TEX_DLG_NORMAL;
			break;
		}
	}
	create(x, y, w, h, type, pCard, tex);
	for(ItepBtn ite = m_btnList.begin(); ite != m_btnList.end(); ite++){
		(*ite)->setTexture(0, TEXLOAD_BUTTON);
	}
#undef CENX
#undef CENY
}

//! ꂽ{^ID̎擾
DWORD Dialog::getResult(void)
{
	// HI:_CAOID LO:{^ID
	DWORD dwRet = MDW(0xffff, 0xffff);

	for(ItepBtn ite = m_btnList.begin(); ite != m_btnList.end(); ite++){
		if((*ite)->isSelect()){
			dwRet = MDW(m_id, (*ite)->getID());
			break;
		}
	}

	return(dwRet);
}



