
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: CardData.cpp

+ ------ Explanation of file --------------------------------------------------------------------------

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include "CardData.h"

//! RXgN^
CardData::CardData()
{
}

//! fXgN^
CardData::~CardData()
{
	release();
}

//! 
void CardData::release(void)
{
	for(iteCard ite = m_cardList.begin(); ite != m_cardList.end(); ite++){
		delete(*ite);
	}
	for(iteText ite = m_textList.begin(); ite != m_textList.end(); ite++){
		delete(*ite);
	}
	for(iteProh ite = m_prohList.begin(); ite != m_prohList.end(); ite++){
		delete(*ite);
	}
	for(iteRest ite = m_restList.begin(); ite != m_restList.end(); ite++){
		delete(*ite);
	}
	for(iteComb ite = m_combList.begin(); ite != m_combList.end(); ite++){
		delete(*ite);
	}
}

//! oCiǂݍ
void CardData::readBinary(void)
{
#define READNUM(num)		{memcpy_s(&num, sizeof(int), &rawData[index], sizeof(int)); index += sizeof(int);}
#define READSTR(str)		{str = &rawData[index]; index += strlen(&rawData[index])+1;}

	char*		fileName[5] = {
		"Data\\CardData.dat",
		"Data\\CardText.dat",
		"Data\\CardProhibition.dat",
		"Data\\CardRestriction.dat",
		"Data\\CardCombination.dat",
	};

	FILE*		fp;
	CARD_DATA*	pCard;
	TEXT_DATA*	pText;
	PROH_DATA*	pProh;
	REST_DATA*	pRest;
	COMB_DATA*	pComb;
	char*		rawData;
	int			fileStart;
	int			fileSize;
	int			index;
	int			dataNum;

	for(int i = 0; i < 5; i++){
		fopen_s(&fp, fileName[i], "rb");
		if(!fp){
			printf("error:");
			printf(fileName[i]);
			printf("݂܂\n");
			return;
		}

		// TCY擾
		fileStart = fseek(fp, 0, SEEK_END);
		fileSize = ftell(fp);
		fseek(fp, fileStart, SEEK_SET);

		// obt@ɓǂݍ
		rawData = (char*)malloc(fileSize);
		fread_s(rawData, fileSize, fileSize, 1, fp);
		fclose(fp);

		// obt@番
		index = 0;
		READNUM(dataNum);		// f[^
		for(int j = 0; j < dataNum; j++){
			switch(i){
				// J[h
				case 0:
					m_cardList.push_back(new CARD_DATA());
					pCard = m_cardList.back();

					READSTR(pCard->serStr);		// V[Y
					READNUM(pCard->serNum);		// V[Yԍ
					READSTR(pCard->name);	 	// O
					READNUM(pCard->color);	 	// F
					READNUM(pCard->power);	 	// p[
					READNUM(pCard->guard);	 	// K[h
					READNUM(pCard->level);	 	// x
					READNUM(pCard->strike);	 	// XgCN
					READNUM(pCard->frame);	 	// t[
					READNUM(pCard->boost);	 	// u[Xg
					READNUM(pCard->type);	 	// ^Cv
					READSTR(pCard->race);	 	// 푰
					pCard->serNo = CNtSN(MDW(SStSN(pCard->serStr.c_str()),pCard->serNum));
					break;
				// eLXg
				case 1:
					m_textList.push_back(new TEXT_DATA());
					pText = m_textList.back();

					READSTR(pText->serStr);		// V[Y
					READNUM(pText->serNum);		// V[Yԍ
					READSTR(pText->text);	 	// eLXg
					pText->serNo = CNtSN(MDW(SStSN(pText->serStr.c_str()),pText->serNum));
					break;
				// ֎~
				case 2:
					m_prohList.push_back(new PROH_DATA());
					pProh = m_prohList.back();

					READSTR(pProh->serStr);		// V[Y
					READNUM(pProh->serNum);		// V[Yԍ
					pProh->serNo = CNtSN(MDW(SStSN(pProh->serStr.c_str()),pProh->serNum));
					break;
				// 
				case 3:
					m_restList.push_back(new REST_DATA());
					pRest = m_restList.back();

					READSTR(pRest->serStr);		// V[Y
					READNUM(pRest->serNum);		// V[Yԍ
					READNUM(pRest->num);	 	// 
					pRest->serNo = CNtSN(MDW(SStSN(pRest->serStr.c_str()),pRest->serNum));
					break;
				// Rr
				case 4:
					m_combList.push_back(new COMB_DATA());
					pComb = m_combList.back();

					READSTR(pComb->serStr[0]);		// V[Y
					READNUM(pComb->serNum[0]);		// V[Yԍ
					READSTR(pComb->serStr[1]);		// V[Y
					READNUM(pComb->serNum[1]);		// V[Yԍ
					pComb->serNo[0] = CNtSN(MDW(SStSN(pComb->serStr[0].c_str()),pComb->serNum[0]));
					pComb->serNo[1] = CNtSN(MDW(SStSN(pComb->serStr[1].c_str()),pComb->serNum[1]));
					break;
			}
		}

		free(rawData);
	}
#undef READNUM
#undef READSTR
}

//! fbLǂݍ
void CardData::readDeck(int ply, const char* fileName)
{
#define READNUM(num)		{memcpy_s(&num, sizeof(int), &deckData[index], sizeof(int)); index += sizeof(int);}
#define READSTR(str)		{str = &deckData[index]; index += strlen(&deckData[index])+1;}
	FILE*		fp;
	char*		deckData;
	int			fileStart;
	int			fileSize;
	int			index = 0;
	DECK_DATA*	pDeck;

	fopen_s(&fp, fileName, "rb");
	if(!fp){
		return;
	}

	// TCY擾
	fileStart = fseek(fp, 0, SEEK_END);
	fileSize = ftell(fp);
	fseek(fp, fileStart, SEEK_SET);

	// obt@ɓǂݍ
	deckData = (char*)malloc(fileSize);
	fread_s(deckData, fileSize, fileSize, 1, fp);
	fclose(fp);

	// obt@番
	for(int i = 0; i < DECK_MAX; i++){
		pDeck = &m_deckList[ply][i];
		READSTR(pDeck->serStr);	// V[Y
		READNUM(pDeck->serNum);	// V[Yԍ
		pDeck->serNo = CNtSN(MDW(SStSN(pDeck->serStr.c_str()), pDeck->serNum));
	}

	free(deckData);
#undef READNUM
#undef READSTR
}

//! J[hf[^擾
void CardData::getCardData(int serNo, CARD_INFO* pCI)
{
	CARD_DATA*	pCard;
	bool		isData = false;
	for(iteCard ite = m_cardList.begin(); ite != m_cardList.end(); ite++){
		pCard = *ite;
		if(pCard->serNo == serNo){
			// \Ⴄ̂ł߂ǂǌʃRs[
			strcpy_s(pCI->name, pCard->name.c_str());
			pCI->cardNo = MDW(SStSN(pCard->serStr.c_str()), pCard->serNum);
			pCI->color = pCard->color;
			pCI->power = pCard->power;
			pCI->guard = pCard->guard;
			pCI->level = pCard->level;
			pCI->strike = pCard->strike;
			pCI->frame = pCard->frame;
			pCI->boost = pCard->boost ? true : false;
			pCI->type = pCard->type;
			strcpy_s(pCI->race, pCard->race.c_str());
			pCI->serNo = pCard->serNo;
			isData = true;
			break;
		}
	}

	if(!isData){
		pCI->serNo = -1;
	}
}

//! J[heLXg擾
void CardData::getCardText(int serNo, char* pStr)
{
	TEXT_DATA*	pText;
	bool		isData = false;
	for(iteText ite = m_textList.begin(); ite != m_textList.end(); ite++){
		pText = *ite;
		if(pText->serNo == serNo){
			strcpy_s(pStr, sizeof(char)*1000, pText->text.c_str());
			isData = true;
			break;
		}
	}

	if(!isData){
		strcpy_s(pStr, sizeof(char)*1000, "f[^");
	}
}


