/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
|
|   Card.cpp
|       J[h
+ -------------------------------------------------------------------------------------------------
|
+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include <mmsystem.h>

#include "systemManager.h"
#include "textureManager.h"
#include "Renderer.h"
#include "Mouse.h"
#include "Scene.h"
#include "animeCalc.h"
#include "CardData.h"

#include "Card.h"

#define GETTIME		(float)(timeGetTime() / 1000.0f)

//! RXgN^
Card::Card()
{
	m_pVB = NULL;
	m_isCreate = false;
}

//! fXgN^
Card::~Card()
{
	release();
}

//! I
void Card::release(void)
{
	SAFE_DELETE(m_anime);
	SAFE_DELETE(m_pBrightAnime);
	SAFE_RELEASE(m_pVB);
}

//! 
void Card::init(CardData* pCD)
{
	m_anime = new animeCalcClass();
	m_pBrightAnime = new animeCalcClass();
	m_pCamera = SystemManager::getInstance()->getCamera();
	m_pTexMan = SystemManager::getInstance()->getTexMan();
	m_pCardData = pCD;

	CARD_VERTEX	*v;

	// _obt@
	GetDevice()->CreateVertexBuffer(
		4 * sizeof(CARD_VERTEX),
		D3DUSAGE_WRITEONLY, CARD_VERTEX_FVF, D3DPOOL_MANAGED,
		&m_pVB, NULL);

	// _̐ݒ
	// bN
	m_pVB->Lock(0, 0, (void**)&v, 0);

	// _Ww
	v[0].p = VEC3(-(VER_CARD_W / 2), 0.01f,  (VER_CARD_H / 2));		// 
	v[1].p = VEC3( (VER_CARD_W / 2), 0.01f,  (VER_CARD_H / 2));		// E
	v[2].p = VEC3(-(VER_CARD_W / 2), 0.01f, -(VER_CARD_H / 2));		// 
	v[3].p = VEC3( (VER_CARD_W / 2), 0.01f, -(VER_CARD_H / 2));		// E

	// Fw
	v[0].color = D3DXCOLOR(1.0f, 1.0f, 1.0f, 0.4f);
	v[1].color = D3DXCOLOR(1.0f, 1.0f, 1.0f, 0.4f);
	v[2].color = D3DXCOLOR(1.0f, 1.0f, 1.0f, 0.4f);
	v[3].color = D3DXCOLOR(1.0f, 1.0f, 1.0f, 0.4f);

	// eNX`Wݒ
	v[0].t1 = VEC2(0.0f, 0.0f);
	v[1].t1 = VEC2(1.0f, 0.0f);
	v[2].t1 = VEC2(0.0f, 1.0f);
	v[3].t1 = VEC2(1.0f, 1.0f);
	v[0].t2 = VEC2(0.0f, 0.0f);
	v[1].t2 = VEC2(1.0f, 0.0f);
	v[2].t2 = VEC2(0.0f, 0.0f);
	v[3].t2 = VEC2(1.0f, 0.0f);

	// AbN
	m_pVB->Unlock();

	// [J_W̃Rs[
	for(int i = 0; i < 4; i++){
		memcpy(&m_vPos[i], &v[i].p, sizeof(VEC3));
	}

	m_pos = VEC3(0.0f, 0.0f, 0.0f);
	m_degree = VEC3(0.0f, 0.0f, 0.0f);
	m_scale = 1.0f;

	m_isCreate = true;
	m_select = SELECT_NON;
	m_focus = false;

	MEMARY(m_useSkill, 0);
	m_isTransDraw = false;
}

//! XV
void Card::update(void)
{
	if(m_anime->isRun()){
		m_pos = m_anime->getPos();
		m_degree = m_anime->getDegree();
		m_scale = m_anime->getScale();
	}

	if(m_select == SELECT_ON){
		if(m_pBrightAnime->isRun()){
			VEC3 pos = m_pBrightAnime->getPos();
			CARD_VERTEX* v;
			m_pVB->Lock(0, 0, (void**)&v, 0);
			v[0].t2 = VEC2(0.0f, pos.y);
			v[1].t2 = VEC2(1.0f, pos.y);
			v[2].t2 = VEC2(0.0f, pos.y + 0.25f);
			v[3].t2 = VEC2(1.0f, pos.y + 0.25f);
			m_pVB->Unlock();
		}else{
			m_pBrightAnime->clear();
			m_pBrightAnime->set(0, 0.0f, VEC3(0.0f, 0.75f, 0.0f), VEC3(0.0f, 0.0f, 0.0f), 1.0f);
			m_pBrightAnime->set(1, 1.0f, VEC3(0.0f, 0.0f, 0.0f), VEC3(0.0f, 0.0f, 0.0f), 1.0f);
			m_pBrightAnime->set(2, 1.0f, VEC3(0.0f, 0.0f, 0.0f), VEC3(0.0f, 0.0f, 0.0f), 1.0f);
			m_pBrightAnime->setLoop(true);
			float delay = GETTIME;
			float time = m_pBrightAnime->getSumTime();
			while(delay > time){
				delay -= time;
			}
			delay = time - delay;
			m_pBrightAnime->setDelay(delay);
			m_pBrightAnime->start();

			CARD_VERTEX* v;
			m_pVB->Lock(0, 0, (void**)&v, 0);
			v[0].t2 = VEC2(0.0f, 0.0f);
			v[1].t2 = VEC2(1.0f, 0.0f);
			v[2].t2 = VEC2(0.0f, 0.0f);
			v[3].t2 = VEC2(1.0f, 0.0f);
			m_pVB->Unlock();
		}
	}else if(m_pBrightAnime->isRun()){
		m_pBrightAnime->clear();
	}
}

//! `
void Card::draw(void)
{
	if(!m_isCreate){ return; }

	// JxNg
	VEC3 cam = m_pCamera->m_look - m_pCamera->m_eye;

	// sin/cosvZ
	float sinX = sin(D3DXToRadian(m_degree.x));
	float cosX = cos(D3DXToRadian(m_degree.x));
	float sinY = sin(D3DXToRadian(m_degree.y));
	float cosY = cos(D3DXToRadian(m_degree.y));
	float sinZ = sin(D3DXToRadian(m_degree.z));
	float cosZ = cos(D3DXToRadian(m_degree.z));

	// J[hxNg
	VEC3 nv;
	nv.x = (cosX*sinZ)-(sinX*sinY*cosZ);
	nv.y = (cosX*cosZ)+(sinX*sinY*sinZ);
	nv.z = sinX*cosY;

	if(m_isTransDraw){
		// ߕ\
		GetDevice()->SetTexture(0, NULL);
	}else if(dotProcuct3D(cam, nv) < 0.0f){
		// J[h摜
		GetDevice()->SetTexture(0, m_pTexMan->getTexture(m_texID));
	}else{
		// X[u摜
		GetDevice()->SetTexture(0, m_pTexMan->getTexture(m_sleeveTexID));
	}
	if(m_select == SELECT_ON){
		GetDevice()->SetTexture(1, m_pTexMan->getTexture(m_brightTexID));
	}else{
		GetDevice()->SetTexture(1, NULL);
	}

	float z = ((m_pos.z > 0.0f) || (m_zone == ZONE_PROGRESS) ? fabs(m_pos.z) / 20 : 0.0f);
	if((m_select != SELECT_LOCK) && ((m_focus) || (m_select == SELECT_ON))){
		m_scale = 1.1f;

		if((m_zone != ZONE_DECK) &&
			 (m_zone != ZONE_DISCARD) &&
			 (m_zone != ZONE_EXCUDE)){
			m_pos.y += 0.1f;
			m_pos.z -= z;
		}
	}
	else{
		m_scale = 1.0f;
	}

	GetWorldMatrix(&m_world, &m_pos, &m_degree, m_scale);

	GetDevice()->SetTransform(D3DTS_WORLD, &m_world);

	GetDevice()->SetStreamSource(0, m_pVB, 0, sizeof(CARD_VERTEX));
	GetDevice()->SetFVF(CARD_VERTEX_FVF);
	GetDevice()->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, 2);

	GetDevice()->SetTexture(0, NULL);
	GetDevice()->SetTexture(1, NULL);

	if((m_select != SELECT_LOCK) && ((m_focus) || (m_select == SELECT_ON))){
		if((m_zone != ZONE_DECK) &&
			 (m_zone != ZONE_DISCARD) &&
			 (m_zone != ZONE_EXCUDE)){
			m_pos.y -= 0.1f;
			m_pos.z += z;
		}
	}
}

//! f[^폜
void Card::deleteData(void)
{
	ZeroMemory(&m_ci, sizeof(m_ci));
	m_ci.serNo = -1;
	m_focus = false;
	m_select = false;
}

//! eXgɊ܂܂Ă邩
bool Card::isExistEffect(CARD_EFFECT ce)
{
	bool bRet = false;
	for(IteCE ite = m_listEffect.begin(); ite != m_listEffect.end(); ite++){
		if(ite->id == ce.id && ite->skill == ce.skill){
			bRet = true;
			break;
		}
	}
	return(bRet);
}

//! f[^Zbg
void Card::setData(int serNo)
{
	m_pCardData->getCardData(serNo, &m_ci);
	char str[MAX_PATH] = {};
	wsprintf(str, TEXLOAD_CARD, SNtSS(HIWORD(m_ci.cardNo)), LOWORD(m_ci.cardNo));
	m_texID = m_pTexMan->loadCardTexture(str);
}

void Card::setPos(float x, float y, float z)
{
	m_pos = VEC3(x, y, z);
	GetWorldMatrix(&m_world, &m_pos, &m_degree, m_scale);
}
void Card::setPos(VEC3 pos)
{
	m_pos = pos;
	GetWorldMatrix(&m_world, &m_pos, &m_degree, m_scale);
}
void Card::setDegree(float x, float y, float z)
{
	m_degree = VEC3(x, y, z);
	GetWorldMatrix(&m_world, &m_pos, &m_degree, m_scale);
}
void Card::setDegree(VEC3 deg)
{
	m_degree = deg;
	GetWorldMatrix(&m_world, &m_pos, &m_degree, m_scale);
}
void Card::setScale(float scale)
{
	m_scale = scale;
	GetWorldMatrix(&m_world, &m_pos, &m_degree, m_scale);
}


//! XN[W擾
VEC3 Card::getDispPos(void)
{
	return(renderer.conv3Dto2D(m_pos));
}

//! Zp[擾
int Card::getAddPower(void)
{
	int iRet = 0;

	for(IteTV ite = m_addPower.begin(); ite != m_addPower.end(); ite++){
		iRet += (*ite).value;
	}

	return(iRet);
}

//! ZXgCN擾
int Card::getAddStrike(void)
{
	int iRet = 0;

	for(IteTV ite = m_addStrike.begin(); ite != m_addStrike.end(); ite++){
		iRet += (*ite).value;
	}

	return(iRet);
}

//! ZN擾
int Card::getAddLink(void)
{
	int iRet = 0;

	for(IteTV ite = m_addLink.begin(); ite != m_addLink.end(); ite++){
		iRet += (*ite).value;
	}

	return(iRet);
}

//! Zx擾
int Card::getAddLevel(void)
{
	int iRet = 0;

	for(IteTV ite = m_addLevel.begin(); ite != m_addLevel.end(); ite++){
		iRet += (*ite).value;
	}

	return(iRet);
}

