
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: Button.h

+ ------ Explanation of file --------------------------------------------------------------------------

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#pragma once

#include "Image2D.h"

class Mouse;

#define BTN_NORMAL_W	70
#define BTN_NORMAL_H	30
#define BTN_PHASE_W		70
#define BTN_PHASE_H		20

// {^
enum{
	BTN_ID_SHIFT,		// Vtg
	BTN_ID_INVOKE,		// 
	BTN_ID_ATTACK,		// A^bN

	BTN_ID_P_AWAKE,		// AEFCN
	BTN_ID_P_DRAW,		// h[
	BTN_ID_P_ENERGY,	// GiW[
	BTN_ID_P_MAIN,		// C
	BTN_ID_P_ATTACK,	// A^bN
	BTN_ID_P_END,		// Gh

	BTN_ID_YES,			// ͂
	BTN_ID_NO,			// 
	BTN_ID_UP,			// 
	BTN_ID_DOWN,		// 
	BTN_ID_DISCARD,		// ̎D
	BTN_ID_LIST,		// Xg
	BTN_ID_CLOSE,		// 
};

enum BTNTEX{
	BTNTEX_NORMAL,
	BTNTEX_DISABLE,
	BTNTEX_FOCUS,

	BTNTEX_MAX
};

enum BTNPART{
	BTNPART_YES		= 0,		// ͂
	BTNPART_NO,					// 
	BTNPART_ATTACK,				// A^bN
	BTNPART_SHIFT,				// Vtg
	BTNPART_INVOKE,				// 
	BTNPART_UP		= 15,		// 
	BTNPART_DOWN,				// 
	BTNPART_DISCARD,			// ̎D
	BTNPART_LIST,				// Xg
	BTNPART_CLOSE,				// 
	BTNPART_AWAKE	= 30,		// AEFCN
	BTNPART_DRAW,				// h[
	BTNPART_ENERGY,				// GiW[
	BTNPART_MAIN,				// C
	BTNPART_END,				// Gh
};
#define BUTTONPART(btn)		btn, btn+TEXPARTX_BTN, btn+(TEXPARTX_BTN*2)

class Button : public Image2D
{
	typedef Image2D	Super;

	private:
		Mouse*	m_pMouse;	// }EX

		int		m_texPartList[BTNTEX_MAX];	// eNX`Xg

		int		m_id;		// CID
		bool	m_enable;	// L
		bool	m_focus;	// tH[JX
		bool	m_select;	// I

	private:
		void	release		(void);

	public:
		Button();
		~Button();

		void	init		(void);
		void	update		(bool isSelect = true);

		int		getID		(void){ return(m_id); };
		bool	getEnable	(void){ return(m_enable); };

		void	setTexType	(int normal, int disable = -1, int focus = -1);
		void	setID		(int id){ m_id = id; };
		void	setEnable	(bool b){ m_enable = b; };

		bool	isFocus		(void){ return(m_focus); }
		bool	isSelect	(void){ return(m_select); }
};

typedef vector<Button>					VecBtn;
typedef vector<Button>::iterator		IteBtn;
typedef vector<Button*>					VecpBtn;
typedef vector<Button*>::iterator		ItepBtn;



