
/* _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/

	FILE	: Button.cpp

+ ------ Explanation of file --------------------------------------------------------------------------

+ _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/ */

#include "Common.h"

#include "systemManager.h"
#include "Mouse.h"

#include "Button.h"

//! RXgN^
Button::Button()
{
	m_pMouse = NULL;
	ZeroMemory(m_texPartList, sizeof(int)*3);
}

//! fXgN^
Button::~Button()
{
	release();
}

//! 
void Button::release(void)
{
}

//! 
void Button::init(void)
{
	m_pMouse = SystemManager::getInstance()->getMouse();

	m_select = false;
	m_focus = false;
	m_enable = true;

	Super::init();
}

//! XV
void Button::update(bool isSelect)
{
	if(m_enable){
		// gk̍W
		POINT mPos = m_pMouse->getPos();
		POINT cen;
		cen.x = (int)(m_pos.x + (m_size.x / 2));
		cen.y = (int)(m_pos.y + (m_size.y / 2));
		RECT sPos;
		sPos.left	= (int)(cen.x - ((m_size.x / 2) * m_scale));
		sPos.right	= (int)(cen.x + ((m_size.x / 2) * m_scale));
		sPos.top	= (int)(cen.y - ((m_size.y / 2) * m_scale));
		sPos.bottom	= (int)(cen.y + ((m_size.y / 2) * m_scale));

		// `FbN
		if((sPos.left < mPos.x) && (mPos.x < sPos.right) && (sPos.top < mPos.y) && (mPos.y < sPos.bottom)){
			m_focus = true;
			if(m_pMouse->getInputL() == MOUSE_PUSH){
				if(m_select || isSelect){
					m_select = !m_select;
				}
			}
		}else{
			m_focus = false;
		}
	}else{
		m_focus = false;
		m_select = false;
	}


	if(!m_enable){
		setTexPart(m_texPartList[BTNTEX_DISABLE]);
	}else if(m_focus){
		setTexPart(m_texPartList[BTNTEX_FOCUS]);
	}else{
		setTexPart(m_texPartList[BTNTEX_NORMAL]);
	}

	Super::update();
}

//! eNX`Zbg
void Button::setTexType(int normal, int disable, int focus)
{
	m_texPartList[BTNTEX_NORMAL] = normal;
	m_texPartList[BTNTEX_DISABLE] = disable != -1 ? disable : normal;
	m_texPartList[BTNTEX_FOCUS] = focus != -1 ? focus : normal;
}

