﻿Imports System.Text
Imports System.Xml

Public Class FrmMain
    Public sBinding As SoapCliantControl
    Dim Dtanken As DataTable

    Private DsListdata As DataSet

    Private Sub BtnLoginInfo_Click(sender As System.Object, e As System.EventArgs) Handles BtnLoginInfo.Click
        FrmLoginInfo.ShowDialog()
    End Sub

    Private Sub BtnKartOpen_Click(sender As System.Object, e As System.EventArgs) Handles BtnNewKartOpen.Click
        Dim Rtnid As String
        If IsNothing(Dtanken) Then
            Dtanken = MakeAnkenTablesType()
        End If
        ShowFrmProginfo()
        Application.UseWaitCursor = True
        '新規追加
        Me.BindingContext(Dtanken).AddNew()
        '追加行に移動
        Me.BindingContext(Dtanken).Position = Me.BindingContext(Dtanken).Count - 1
        Dim DrvNew As DataRowView = CType(Me.BindingContext(Dtanken).Current, DataRowView)
        Dim drnew As DataRow = DrvNew.Row
        '件名にタグをつける
        drnew.Item("name") = "【新規】"
        '作業開始日＝au登録日+2
        drnew.Item("resultsDay__c") = DateAdd(DateInterval.Day, 2, drnew.Item("auEntry_Day__c"))
        '保存する
        Rtnid = Save(Dtanken, sBinding)
        If Not Rtnid = "" Then
            '正常に保存されたので、返却されたIDを付加する
            drnew.Item("id") = Rtnid
            'この状態で確定する
            Dtanken.AcceptChanges()
        Else
            'エラーがあるので、待機フォームを閉じる
            Application.UseWaitCursor = False
            FrmProgInfo.Close()
            Exit Sub
        End If

        '選択行の詳細を開く
        FrmKarty.id = Rtnid
        FrmKarty.sDtKart = Dtanken
        FrmKarty.sBinding = sBinding
        Application.UseWaitCursor = False
        FrmProgInfo.Close()
        setKartyWindow()
        If FrmKarty.ShowDialog() = Windows.Forms.DialogResult.OK Then
            '変更があるなら代入
            Dtanken = FrmKarty.sDtKart
            'リストの再描画
            DGList.AutoGenerateColumns = False  '自動でカラムの生成を行わない
            DGList.DataSource = Dtanken
            DGListcnt.AutoGenerateColumns = False  '自動でカラムの生成を行わない
            DGListcnt.DataSource = Dtanken
            LblCnt.Text = "対象レコード件数 >> " & Dtanken.Rows.Count.ToString
        End If
        '画面を閉じ、メモリ解放
        FrmKarty.Close()
        FrmKarty.Dispose()
    End Sub

    Private Sub BtnWhere_Click(sender As System.Object, e As System.EventArgs) Handles BtnWhere.Click
        Dim Qr As QueryResult
        Dim done As Boolean = False

        Dim SOQLStr As New StringBuilder    '高速化
        Dim SOQLWhereStr As New StringBuilder

        ShowFrmProginfo()

        Application.UseWaitCursor = True
        If IsNothing(Dtanken) Then
            Dtanken = MakeAnkenTablesType()
        Else
            Dtanken.Rows.Clear()
        End If
        SOQLStr = ColmunsName(Dtanken)
        SOQLStr.Insert(0, "SELECT ")

        With SOQLStr
            .Append(" from CustomerMG__c")
            .Append(MakeSOQLWhere)
        End With
        If Not IsNothing(sBinding) Then
            Try
                Qr = sBinding.query(SOQLStr.ToString)
                FrmLogionDisp.LogDisplay(SOQLStr.ToString)
                FrmLogionDisp.LogDisplay("クエリ...OK")
                'Qr = sBinding.query("select id,name,auEntry_Day__c,anken_staff__c,LOT__c,irai_staff__c,Type__c from CustomerMG__c")
                While (Not done)

                    Dtanken = sObject2AnkenTables(Dtanken, Qr)
                    'Dtanken.WriteXml("test.xml", XmlWriteMode.WriteSchema)
                    If Qr.done Then
                        done = True
                    Else
                        Qr = sBinding.QueryMore(Qr.queryLocator)
                        '追加Queryが存在するなら、取得する
                        If Qr.records.Count > 0 Then
                            Dtanken = sObject2AnkenTables(Dtanken, Qr)
                        End If
                    End If
                End While
                'Dtanken.DefaultView
                '変更してないけど確定する
                Dtanken.AcceptChanges()
                DGList.AutoGenerateColumns = False  '自動でカラムの生成を行わない
                DGList.DataSource = Dtanken
                DGListcnt.AutoGenerateColumns = False  '自動でカラムの生成を行わない
                DGListcnt.DataSource = Dtanken
                LblCnt.Text = "対象レコード件数 >> " & Dtanken.Rows.Count.ToString
                Application.UseWaitCursor = False

                FrmProgInfo.Close()

            Catch ex As Exception
                Application.UseWaitCursor = False
                FrmProgInfo.Close()
                MessageBox.Show(ex.Message)
                FrmLogionDisp.LogDisplay(ex.Message)
            End Try
        End If

    End Sub

    Private Function MakeSOQLWhere() As String
        Dim SOQLWhereStr As New StringBuilder
        With SOQLWhereStr
            '.Append(" where ")
            If Not txtanken.Text = "" Then  '案件名
                .Append(" name like '%" & txtanken.Text & "%' ")
            End If

            If CKunhold.Checked Then    '日程未確保
                If .Length > 0 Then
                    .Append(" And ")
                End If
                .Append("plan_hold__c = false ")
                'Else
                '    If .Length > 0 Then
                '        .Append(" And ")
                '    End If
                '    .Append(" plan_hold__c = false ")
            End If

            If CK1.Checked Then '案件担当者未設定
                If .Length > 0 Then
                    .Append(" And ")
                End If
                .Append("anken_staff__c =null ")
            ElseIf Not txtAnkenStaff.Text = "" Then '案件担当者
                If .Length > 0 Then
                    .Append(" And ")
                End If
                .Append("anken_staff__c like '%" & txtAnkenStaff.Text & "%' ")
            End If
            If DTPSerchAu.Checked Then  'au登録日 以前
                If .Length > 0 Then
                    .Append(" And ")
                End If
                .Append("auEntry_Day__c <= " & Replace(DTPSerchAu.Value.ToShortDateString, "/", "-") & " ")
            End If
            If DTPDelivalyDay.Checked Then  '納品日
                If .Length > 0 Then
                    .Append(" And ")
                End If
                .Append("Delivery_Day__c = " & Replace(DTPDelivalyDay.Value.ToShortDateString, "/", "-") & " ")
            End If
            If cbWorkPlace.SelectedIndex > 0 Then   '作業場所
                If .Length > 0 Then
                    .Append(" And ")
                End If
                .Append("work_place_Team__c = '" & cbWorkPlace.SelectedValue & "' ")
            End If
            If CKRental.Checked Then    'レンタル
                If .Length > 0 Then
                    .Append(" And ")
                End If
                .Append("rental_flg__c = true ")
            End If
            If CK2.Checked Then '手順書担当者未設定
                If .Length > 0 Then
                    .Append(" And ")
                End If
                .Append("operate_t_staff__c = null ")
            ElseIf Not txtmicroStaff.Text = "" Then '手順書担当者
                If .Length > 0 Then
                    .Append(" And ")
                End If
                .Append("operate_t_staff__c like '%" & txtmicroStaff.Text & "%' ")
            End If

            If DTPWorkDay.Checked Then  '作業日
                If .Length > 0 Then
                    .Append(" And ")
                End If
                .Append("work_day__c >= " & Replace(DTPWorkDay.Value.ToShortDateString, "/", "-") & " ")
            End If
            '条件文が存在するならば、Whereを追加
            If .Length > 0 Then
                .Insert(0, " Where ")
            End If

            'クエリ結果の順序指定 依頼日を昇順
            .Append(" ORDER BY irai__c ASC")
        End With

        Return SOQLWhereStr.ToString

    End Function

    Private Sub BtnExit_Click(sender As System.Object, e As System.EventArgs) Handles BtnExit.Click
        Me.Close()
    End Sub

    Private Sub BtnLogShow_Click(sender As System.Object, e As System.EventArgs) Handles BtnLogShow.Click
        FrmLogionDisp.Show()
        FrmLogionDisp.Activate()
    End Sub

    Private Sub BtnKarty_Click(sender As System.Object, e As System.EventArgs) Handles BtnKarty.Click
        Dim id As String = ""

        If IsNothing(Dtanken) Then
            Dtanken = MakeAnkenTablesType()
        End If

        Dim bm As BindingManagerBase = Me.BindingContext(Dtanken)
        Dim drv As DataRowView
        Try
            drv = CType(bm.Current, DataRowView)
        Catch ex As Exception
            MessageBox.Show("対象レコードが存在しません", "表示できません", MessageBoxButtons.OK, MessageBoxIcon.Information)
            Exit Sub
        End Try
        Dim dr As DataRow = drv.Row
        id = dr("id")
        If IsNothing(id) OrElse id = "" Then
            MessageBox.Show("行が選択されていません", "未選択", MessageBoxButtons.OK, MessageBoxIcon.Information)
            Exit Sub
        Else
            ShowFrmProginfo()
            Application.UseWaitCursor = True

            '選択行の詳細を開く
            Dim tmpDt As DataTable
            '指定データの再取得を行う
            Try
                tmpDt = GetKartyRec(id)
                '元データとマージ
                Dtanken.Merge(tmpDt, False)
                '変更を確定
                Dtanken.AcceptChanges()
            Catch ex As Exception
                Application.UseWaitCursor = False
                FrmProgInfo.Close()
                MessageBox.Show(ex.Message, "エラー", MessageBoxButtons.OK, MessageBoxIcon.Error)
                FrmLogionDisp.LogDisplay(ex.Message)
                Exit Sub
            End Try
            FrmKarty.id = id
            FrmKarty.sDtKart = Dtanken
            FrmKarty.sBinding = sBinding
            Application.UseWaitCursor = False
            FrmProgInfo.Close()
            setKartyWindow()
            If FrmKarty.ShowDialog() = Windows.Forms.DialogResult.OK Then
                '変更があるなら代入
                Dtanken = FrmKarty.sDtKart
                'リストの再描画
                DGList.DataSource = Dtanken
            End If
            '画面を閉じ、メモリ解放
            FrmKarty.Close()
            FrmKarty.Dispose()
        End If
    End Sub

 
    Private Sub FrmMain_FormClosing(sender As Object, e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        If MessageBox.Show("終了します。" & vbCrLf & "よろしいですか？", "終了確認", MessageBoxButtons.YesNo, MessageBoxIcon.Question) = Windows.Forms.DialogResult.Yes Then
            If sBinding.isConnected Then
                sBinding.logout()
            End If
            FrmLogionDisp.Close()
        Else
            e.Cancel = True
        End If

    End Sub

    Private Function GetKartyRec(argid As String) As DataTable
        Dim Dtanken As DataTable
        Dim fieldslist As New StringBuilder
        Dim ids(0) As String
        Dim sObj() As sObject

        If argid = "" Then
            Return Nothing
            Exit Function
        Else
            ids(0) = argid
        End If
        Dtanken = MakeAnkenTablesType()
        fieldslist = ColmunsName(Dtanken)
        sObj = sBinding.retrieve(fieldslist.ToString, TABLE_NAME, ids)
        FrmLogionDisp.LogDisplay(ids(0).ToString)
        FrmLogionDisp.LogDisplay("リトリーブ...OK")
        If Not IsNothing(sObj) Then
            Return sObject2AnkenTables(Dtanken, sObj)
        Else
            Return Nothing
        End If

    End Function


    Private Sub FrmMain_Load(sender As Object, e As System.EventArgs) Handles Me.Load
        Dim DB As New CustDB

        DsListdata = DB.GetListData()
        DsListdata = MakeListData(DsListdata)
        ControlBind()

        LblCnt.Text = ""
    End Sub

    Private Sub ControlBind()
        cbWorkPlace.DataBindings.Clear()

        cbWorkPlace.DataSource = DsListdata.Tables("WORK")
        cbWorkPlace.DisplayMember = "label"
        cbWorkPlace.ValueMember = "val"
        cbWorkPlace.SelectedIndex = 0
        'cbWorkPlace.DataBindings.Add("selectedvalue", sDtKart, "work_place_Team__c")
    End Sub


    Private Sub CK1_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles CK1.CheckedChanged
        If CK1.Checked = True Then
            txtAnkenStaff.ReadOnly = True
        Else
            txtAnkenStaff.ReadOnly = False
        End If
    End Sub

    Private Sub CK2_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles CK2.CheckedChanged
        If CK2.Checked = True Then
            txtmicroStaff.ReadOnly = True
        Else
            txtmicroStaff.ReadOnly = False
        End If
    End Sub


    Private Sub BtnSearch_Click(sender As System.Object, e As System.EventArgs) Handles BtnSearch.Click
        Const FIND As String = "find{"
        Const FIND_RETURN As String = "}IN ALL FIELDS RETURNING CustomerMG__c"
        Dim searchSOSL As New StringBuilder
        Dim sq As SearchResult

        If txtKeyword.Text = "" Then
            Exit Sub
        End If

        ShowFrmProginfo()
        Application.UseWaitCursor = True

        If IsNothing(Dtanken) Then
            Dtanken = MakeAnkenTablesType()
        Else
            Dtanken.Rows.Clear()
        End If
        searchSOSL = ColmunsName(Dtanken)
        '先頭に追加
        searchSOSL.Insert(0, FIND & txtKeyword.Text & FIND_RETURN & "(")
        '末尾に追加
        searchSOSL.Append(" ORDER BY irai__c ASC)")

        Try
            sq = sBinding.search(searchSOSL.ToString)
            Dtanken = sObject2AnkenTables(Dtanken, sq)
            Dtanken.AcceptChanges()
            DGList.AutoGenerateColumns = False  '自動でカラムの生成を行わない
            DGList.DataSource = Dtanken
            DGListcnt.AutoGenerateColumns = False  '自動でカラムの生成を行わない
            DGListcnt.DataSource = Dtanken
            LblCnt.Text = "対象レコード件数 >> " & Dtanken.Rows.Count.ToString
            Application.UseWaitCursor = False
            FrmProgInfo.Close()
        Catch ex As Exception
            Application.UseWaitCursor = False
            FrmProgInfo.Close()
            MessageBox.Show(ex.Message)
            FrmLogionDisp.LogDisplay(ex.Message)
        End Try

    End Sub

    Private Sub txtKeyword_GotFocus(sender As Object, e As System.EventArgs) Handles txtKeyword.GotFocus
        txtKeyword.BackColor = Color.Yellow
    End Sub

    Private Sub txtKeyword_KeyPress(sender As Object, e As KeyPressEventArgs) Handles txtKeyword.KeyPress
        If e.KeyChar = Chr(13) Then
            BtnSearch.PerformClick()
        End If
    End Sub

    Private Sub txtKeyword_LostFocus(sender As Object, e As System.EventArgs) Handles txtKeyword.LostFocus
        txtKeyword.BackColor = Color.White
    End Sub

    Private Sub BtnCopy_Click(sender As Object, e As EventArgs) Handles BtnCopy.Click
        Dim id As String

        If IsNothing(Dtanken) Then
            Dtanken = MakeAnkenTablesType()
        End If
        ShowFrmProginfo()
        Application.UseWaitCursor = True
        '新規レコードを作成する
        Dim bm As BindingManagerBase = Me.BindingContext(Dtanken)
        Dim drv As DataRowView
        Try
            drv = CType(bm.Current, DataRowView)
        Catch ex As Exception
            Application.UseWaitCursor = False
            FrmProgInfo.Close()
            MessageBox.Show("対象レコードが存在しないので、コピーできません", "コピーできません", MessageBoxButtons.OK, MessageBoxIcon.Information)
            Exit Sub
        End Try
        Dim dr As DataRow = drv.Row
        '新規追加
        Me.BindingContext(Dtanken).AddNew()
        'NewRecDefault(Me.BindingContext(Dtanken))
        '新規行に移動
        Me.BindingContext(Dtanken).Position = Me.BindingContext(Dtanken).Count - 1
        Dim DrvNew As DataRowView = CType(Me.BindingContext(Dtanken).Current, DataRowView)
        Dim drnew As DataRow = DrvNew.Row
        '項目単位でのコピーを行う
        'idはキー項目のため、値の重複を許していないためコピー除外
        For i As Integer = 0 To drnew.Table.Columns.Count - 1
            Select Case drnew.Table.Columns(i).ColumnName
                Case "id"
                    '//除外
                Case "irai__c", "resultsDay__c", "work_Day__c"
                    '//本日
                Case "TSSC_store_flg__c", "store_flg__c", "plan_hold__c", "errorhour__c", "yoteihour__c", "resultshour__c"
                    '//工数＝0　フラグはなし
                Case Else
                    drnew.Item(i) = dr.Item(i)
            End Select
        Next
        '件名にタグをつける
        drnew.Item("name") = "【コピー】" & dr.Item("name")

        '保存する
        id = Save(Dtanken, sBinding)
        If Not id = "" Then
            '正常に保存されたので、返却されたIDを付加する
            drnew.Item("id") = id
            'この状態で確定する
            Dtanken.AcceptChanges()
            LblCnt.Text = "対象レコード件数 >> " & Dtanken.Rows.Count.ToString
        Else
            'エラーがあるので、待機フォームを閉じる
            Application.UseWaitCursor = False
            FrmProgInfo.Close()
            Exit Sub
        End If
        Application.UseWaitCursor = False
        FrmProgInfo.Close()

    End Sub

    Private Sub BtnCSVOutPut_Click(sender As Object, e As EventArgs) Handles BtnCSVOutPut.Click
        SaveDialogDefault()
    End Sub

    Private Sub BtnDelete_Click(sender As Object, e As EventArgs) Handles BtnDelete.Click
        Dim id As String = ""
        Dim name As String = ""

        For Each r As DataGridViewRow In DGList.SelectedRows
            id = r.Cells("ID").Value
            name = r.Cells("anken").Value
            Exit For
        Next
        If IsNothing(id) OrElse id = "" Then
            MessageBox.Show("行が選択されていません", "未選択", MessageBoxButtons.OK, MessageBoxIcon.Asterisk)
            Exit Sub
        End If
        If MessageBox.Show("案件名: " & name & " を削除します" & vbCrLf & "よろしいですか？", "確認", MessageBoxButtons.OKCancel, MessageBoxIcon.Question) = Windows.Forms.DialogResult.OK Then

            ShowFrmProginfo()
            Application.UseWaitCursor = True

            Dim dr As DataRow()
            dr = Dtanken.Select("id = '" & id & "'")
            If ActualDelete(id) Then
                'データセットから削除
                Dtanken.Rows.Remove(dr(0))
                '削除を確定させる（実データと同期させるため）
                Dtanken.AcceptChanges()
                LblCnt.Text = "対象レコード件数 >> " & Dtanken.Rows.Count.ToString
            End If
            Application.UseWaitCursor = False
            FrmProgInfo.Close()
        End If

    End Sub

    Private Function ActualDelete(argid As String) As Boolean
        Dim ids(0) As String
        Dim dR() As DeleteResult

        If argid = "" Then
            Return Nothing
            Exit Function
        Else
            ids(0) = argid
        End If
        '削除と言ってるが、データは「ゴミ箱」に移動する
        'ごみ箱では、過去15 日間に削除したレコードを参照および復元できます。
        dR = sBinding.Delete(ids)

        For i = 0 To dR.Length - 1
            If (dR(i).success) Then
                FrmLogionDisp.LogDisplay(ids(0).ToString)
                FrmLogionDisp.LogDisplay("削除...OK")
            Else
                FrmLogionDisp.LogDisplay(ids(0).ToString)
                FrmLogionDisp.LogDisplay("削除...エラー：" & dR(i).errors(0).ToString)
                '                MessageBox.Show("エラー内容=" & dR(i).errors(0).ToString, "削除エラー", MessageBoxButtons.OK, MessageBoxIcon.Error)
                Return False
                Exit Function
            End If
        Next
        Return True
    End Function

    Private Sub DGList_DoubleClick(sender As Object, e As EventArgs) Handles DGList.DoubleClick, DGListcnt.DoubleClick
        BtnKarty.PerformClick()
    End Sub

    Private Sub SaveDialogDefault()
        Dim sfd As New SaveFileDialog

        '初期ファイル名指定
        sfd.FileName = Now.Year.ToString & Now.Month.ToString & Now.Day.ToString & Now.Hour.ToString & Now.Minute.ToString & Now.Second.ToString & ".csv"
        '初期フォルダ(デスクトップ）
        sfd.InitialDirectory = System.Environment.GetFolderPath(Environment.SpecialFolder.DesktopDirectory)
        'ファイルフィルタ
        sfd.Filter = "すべてのファイル(*.*)|*.*|CSVファイル(*.csv)|*.csv|テキストファイル(*.txt)|*.txt"
        sfd.FilterIndex = 0
        'タイトルを設定する
        sfd.Title = "保存先のファイルを選択してください"
        'ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
        sfd.RestoreDirectory = True

        Try

            If Not sfd.ShowDialog = Windows.Forms.DialogResult.OK Then
                Exit Sub
            End If
            Application.UseWaitCursor = True
            If IsNothing(Dtanken) Then
                Dtanken = MakeAnkenTablesType()
            End If
            ConvertDataTableToCsv(Dtanken, sfd.FileName, True)
            Application.UseWaitCursor = False
            MessageBox.Show("ファイルを作成しました", "CSV", MessageBoxButtons.OK, MessageBoxIcon.Information)
        Catch ex As Exception
            Application.UseWaitCursor = False
            MessageBox.Show(ex.Message)
        End Try
    End Sub

    ''' <summary>
    ''' 検索条件の初期化
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub BtnClear_Click(sender As Object, e As EventArgs) Handles BtnClear.Click
        txtanken.Text = ""
        txtAnkenStaff.Text = ""
        txtmicroStaff.Text = ""
        CKunhold.Checked = False
        CK1.Checked = False
        CK2.Checked = False
        DTPSerchAu.Checked = False
        DTPDelivalyDay.Checked = False
        DTPWorkDay.Checked = False
        cbWorkPlace.SelectedIndex = 0
    End Sub

End Class