#include <stdio.h> 
#include <string.h> 
#include <stdint.h> 
#include <netdb.h> 
#include <time.h> 
#include <unistd.h> 
#include <errno.h> 
#include <stdlib.h>
#include <sys/time.h>
#include <signal.h>
#include <sysexits.h>

#define	PID_FILE	"/var/run/dstar_ntpdate.pid"

//---------------------------------------------------------------------------------------------------- 
#define JAN_1970    0x83aa7e80 // 2208988800 1970 - 1900 in seconds 
#define NTP_PORT    (123) 
#define NTPFRAC(x)  (4294*(x) + ((1981*(x))>>11)) 
#define NTP_SERVER	"ntp.nict.jp"
//---------------------------------------------------------------------------------------------------- 

#define	TRUE	1
#define	FALSE	0
void	exit (int n);

void send_packet(int usd) 
{ 
    uint32_t data[12]; 
    struct timeval now; 
    static const int LI = 0, VN = 3, MODE = 3, STRATUM = 0, POLL = 4, PREC = -6; 
    bzero((char *) data,sizeof(data)); 
    data[0] = htonl ((LI << 30) | (VN << 27) | (MODE << 24) | (STRATUM << 16) | (POLL << 8) | (PREC & 0xff)); 
    data[1] = htonl(1<<16); // Root Delay (seconds) 
    data[2] = htonl(1<<16); // Root Dispersion (seconds) 
    gettimeofday(&now,NULL); 
    data[10] = htonl(now.tv_sec + JAN_1970); // Transmit Timestamp coarse 
    data[11] = htonl(NTPFRAC(now.tv_usec));  // Transmit Timestamp fine 
    send(usd,data,48,0); 
} 

void rfc1305(uint32_t *data) 
{
	struct	timeval	s_time;
	time_t	n;

    	time_t sec = ntohl(((uint32_t *)data)[10]) - JAN_1970;

	time (&n);
	if (abs(sec - n) >= 2)
	{
		s_time.tv_sec = sec;
		s_time.tv_usec = 0;
		settimeofday (&s_time, NULL);
	}
} 

int ntpdate(void) 
{ 
    int ntp_sd; 
    struct hostent *he; 
    if ( (ntp_sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)) == -1 ) { perror("socket"); return -1; } 
    if ( (he = gethostbyname(NTP_SERVER)) == NULL ) return -1; 
  
    struct sockaddr_in sa; 
    memset(&sa, 0, sizeof(sa)); 
    memcpy(&sa.sin_addr, he->h_addr_list[0], sizeof(sa.sin_addr)); 
    sa.sin_port = htons(NTP_PORT); 
    sa.sin_family = AF_INET; 
    if ( connect(ntp_sd, (struct sockaddr*)&sa, sizeof(sa)) == -1 ) return -1; 
    // send ntp packet 
    send_packet(ntp_sd); 
    // recv ntp packet 
    struct timeval tv = {3,0}; 
    fd_set fds;
 
	FD_ZERO(&fds); FD_SET(ntp_sd, &fds); 
    	if ( select(ntp_sd + 1, &fds, NULL, NULL, &tv) == 1 ) 
	{ 
        	uint32_t packet[12]; 
        	int len = recv(ntp_sd, packet, sizeof(packet), 0); 
        	if ( len == sizeof(packet) ) 
		{ 
			rfc1305(packet); 
			close(ntp_sd); return 0; 
		} 
    		return -1; 
	} 
	return 0;
}

void    handler (int sig)
{
        if ((sig == SIGTERM) || (sig == SIGINT))
        {
                remove (PID_FILE);
                exit (1);
        }
}

void    handler_init(void)
{
        time_t atime;

        time (&atime);
        signal(SIGUSR1, handler);
        signal(SIGUSR2, handler);
        signal(SIGTERM, handler);
        signal(SIGINT, handler);
}
  
int main(int argc, char *argv[]) 
{
	time_t	atime;
	FILE	*pid_file;

        pid_file = fopen(PID_FILE, "r");
        if (pid_file == NULL)
        {
                pid_file = fopen(PID_FILE, "w");
        }
        else
        {
		time (&atime);
                printf ("%24.24s Already running status.\n", ctime(&atime));
                return -1;
        }
        fprintf (pid_file, "%d", getpid());
        fclose (pid_file);

	handler_init();
	while (1)
	{
    		if (ntpdate()) break; 
		sleep (60*60);	// 1 hour
	}
    	return 0; 
}

