package net.sf.jhpdf.test.matcher

import org.hamcrest.BaseMatcher
import org.hamcrest.Description;

class EqualToArray extends BaseMatcher {

    private Object expected
    
    public EqualToArray(Object expected) {
        super()
        if (!expected.getClass().isArray()) {
            throw new IllegalArgumentException(
                "expected value is not Array"
                )
        }
        this.expected = expected
    }

    @Override
    public boolean matches(Object item) {
        if (!item.getClass().isArray()) {
            return false
        } else {
            return Arrays.equals(this.expected, item)
        }
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(
            String.format("expected %s[] size=%d ",
                this.expected.getClass().name, this.expected.length
            )
        )
        description.appendValue(this.expected)
    }

}
