/*
 * JHPdf Free PDF Library : HPdfCIDTypexFont.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.font;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jhpdf.HPdfErrorCode;
import net.sf.jhpdf.HPdfException;
import net.sf.jhpdf.encoder.HPdfCMapEncoder;
import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.encoder.HPdfEncoder.HPdfEncoderType;
import net.sf.jhpdf.encrypt.HPdfEncrypt;
import net.sf.jhpdf.graphics.HPdfRect;
import net.sf.jhpdf.graphics.HPdfTextWidth;
import net.sf.jhpdf.io.HPdfWriteStream;
import net.sf.jhpdf.pdfobject.HPdfDict;
import net.sf.jhpdf.pdfobject.HPdfFont;
import net.sf.jhpdf.pdfobject.HPdfXref;
import net.sf.jhpdf.pdfobject.font.HPdfFontDef.HPdfFontDefType;

/**
 * Abstract class represents PDF Font for type0 font's descendant.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public abstract class HPdfDescendantFont extends HPdfFontImpl {
    
    private static final Logger logger = LoggerFactory.getLogger(HPdfDescendantFont.class);
    
    protected HPdfDescendantFont(HPdfType0Font parent, HPdfXref xref) {
        super(parent.getFontDef(), parent.getEncoder(), xref);
    }

    /**
     * implementation of beforeWrite() method.<br>
     * this method exists to keep beforeWrite() itself 'protected'
     * and to make beforeWrite() function of descendant fonts callable from type0 font class.
     * 
     * @param obj the instance to be written.
     */
    abstract void beforeWriteImpl(HPdfType0Font obj);

    @Deprecated
    @Override
    protected final HPdfTextWidth textWidthImpl(String text, int len) {
        logger.trace("HPdfDescendantFont#textWidthImpl");
        // MEMO: do not call this method of this class.
        throw new HPdfException(HPdfErrorCode.HPDF_UNSUPPORTED_FUNC, 0);
    }

    @Deprecated
    @Override
    protected final int measureTextImpl(String text, int len, float width,
            float fontSize, float charSpace, float wordSpace, boolean wordWrap,
            float[] realWidth) {
        logger.trace("HPdfDescendantFont#measureTextImpl");
        // MEMO: do not call this method of this class.
        throw new HPdfException(HPdfErrorCode.HPDF_UNSUPPORTED_FUNC, 0);
    }
    
    
}
