/*
 * JHPdf Free PDF Library : HPdfProjectionAnnotation.java
 *
 * URL:
 *
 * Copyright (c) 2012- Toshiaki Yoshida <toshi@doju-m.jp>
 * {
 * Based on 'Haru Free PDF Library' (http://libharu.org)
 * Copyright (c) 1999-2006 Takeshi Kanno <takeshi_kanno@est.hi-ho.ne.jp>
 * Copyright (c) 2007-2009 Antony Dovgal <tony@daylessday.org>
 * }
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 * It is provided "as is" without express or implied warranty.
 *
 */

package net.sf.jhpdf.pdfobject.annotation;

import net.sf.jhpdf.pdfobject.HPdfAnnotation;
import net.sf.jhpdf.pdfobject.HPdfExData;
import net.sf.jhpdf.pdfobject.HPdfString;
import net.sf.jhpdf.pdfobject.HPdfXref;
import net.sf.jhpdf.encoder.HPdfEncoder;
import net.sf.jhpdf.graphics.HPdfRect;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Class represents PDF projection annotation.
 * @author Toshiaki Yoshida
 * @version 0.1
 *
 */
public class HPdfProjectionAnnotation extends HPdfAnnotation {

    private static final Logger logger = LoggerFactory.getLogger(HPdfProjectionAnnotation.class);
    
    public HPdfProjectionAnnotation(HPdfXref xref, HPdfRect rect, String text, HPdfEncoder encoder) {
        super(xref, rect);
        
        // MEMO: original code; HPDF_PTRACE((" HPDF_StampAnnot_New\n"));
        // Probably it is misspell.
        logger.trace("HPdfProjectionAnnotation#ctor");
        
        this.addName("SubType", "Projection");
        
        this.add("Contents", new HPdfString(text, encoder));
    }
    
    public void setExData(HPdfExData exdata) {
        this.add("ExData", exdata);
    }

}
